/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.future;

import com.airg.android.async.future.Promise;

public final class SimplePromise<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private Promise.OnCompleteListener<RESULT> onCompleteListener;
    private Promise.OnFailListener onFailListener;
    private Promise.OnCancelListener onCancelListener;
    private Throwable error = null;
    private RESULT result = null;
    private boolean done = false;
    private boolean failed = false;
    private boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(RESULT r) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                return;
            }
            this.result = r;
            this.done = true;
            this.notifyDoneMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                return;
            }
            this.error = t;
            this.failed = true;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.done || this.failed) {
                return;
            }
            this.cancelled = true;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCompleteListener = listener;
            this.notifyDoneMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onFailListener = listener;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCancelListener = listener;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return this.failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.$lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    private void assertNotComplete() {
        if (this.done || this.failed) {
            throw new IllegalStateException("Already marked as " + (this.done ? "done" : "failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDoneMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.done || null == this.onCompleteListener) {
                return;
            }
            this.onCompleteListener.onComplete(this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailedMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.failed || null == this.onFailListener) {
                return;
            }
            this.onFailListener.onFailed(this.error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelledMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.cancelled || null == this.onCancelListener) {
                return;
            }
            this.onCancelListener.onCancelled();
        }
    }
}

