/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async;

import android.support.annotation.NonNull;
import com.airg.android.async.CPUWorkerThreadFactory;
import com.airg.android.async.UIThreadExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class ThreadPool {
    private static final Object $LOCK = new Object[0];
    private static final Executor UI = new UIThreadExecutor();
    private static ExecutorService BACKGROUND;

    public static void fg(@NonNull Runnable runnable) {
        UI.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bg(@NonNull Runnable runnable) {
        Object object = $LOCK;
        synchronized (object) {
            ThreadPool.background().execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> submit(@NonNull Runnable runnable) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(@NonNull Callable<T> callable) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(@NonNull Runnable runnable, T result) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(runnable, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService background() {
        Object object = $LOCK;
        synchronized (object) {
            if (null == BACKGROUND) {
                ThreadPool.init(null);
            }
            return BACKGROUND;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Config config) {
        Object object = $LOCK;
        synchronized (object) {
            if (null != BACKGROUND) {
                throw new IllegalStateException("Thread pool already initialized. You should call this method before any other calls to this class' methods");
            }
            Config initConfig = null == config ? new Config() : config;
            int poolSize = initConfig.overRidePoolSize > 0 ? initConfig.overRidePoolSize : Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
            BACKGROUND = Executors.newFixedThreadPool(poolSize, new CPUWorkerThreadFactory(initConfig.workerThreadNamePrefix, initConfig.backgroundThreadPriority));
        }
    }

    public static class Config {
        private String workerThreadNamePrefix = "AsyncWorker";
        private int overRidePoolSize = 0;
        private int backgroundThreadPriority = 5;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        private Config() {
        }

        Config(String workerThreadNamePrefix, int overRidePoolSize, int backgroundThreadPriority) {
            this.workerThreadNamePrefix = workerThreadNamePrefix;
            this.overRidePoolSize = overRidePoolSize;
            this.backgroundThreadPriority = backgroundThreadPriority;
        }

        public static class ConfigBuilder {
            private String workerThreadNamePrefix;
            private int overRidePoolSize;
            private int backgroundThreadPriority;

            ConfigBuilder() {
            }

            public ConfigBuilder workerThreadNamePrefix(String workerThreadNamePrefix) {
                this.workerThreadNamePrefix = workerThreadNamePrefix;
                return this;
            }

            public ConfigBuilder overRidePoolSize(int overRidePoolSize) {
                this.overRidePoolSize = overRidePoolSize;
                return this;
            }

            public ConfigBuilder backgroundThreadPriority(int backgroundThreadPriority) {
                this.backgroundThreadPriority = backgroundThreadPriority;
                return this;
            }

            public Config build() {
                return new Config(this.workerThreadNamePrefix, this.overRidePoolSize, this.backgroundThreadPriority);
            }

            public String toString() {
                return "ThreadPool.Config.ConfigBuilder(workerThreadNamePrefix=" + this.workerThreadNamePrefix + ", overRidePoolSize=" + this.overRidePoolSize + ", backgroundThreadPriority=" + this.backgroundThreadPriority + ")";
            }
        }
    }
}

