/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async;

import android.support.annotation.NonNull;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class CPUWorkerThreadFactory
implements ThreadFactory {
    private final AtomicInteger nameCounter = new AtomicInteger();
    private final String namePrefix;
    private final int threadPriority;

    CPUWorkerThreadFactory() {
        this("Worker");
    }

    CPUWorkerThreadFactory(String name) {
        this(name, 5);
    }

    CPUWorkerThreadFactory(String name, int priority) {
        this.namePrefix = name;
        this.threadPriority = priority;
    }

    @Override
    public Thread newThread(@NonNull Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName(String.format(Locale.ENGLISH, "%s[%s]", this.namePrefix, this.nameCounter.getAndIncrement()));
        thread.setPriority(this.threadPriority);
        return thread;
    }
}

