/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.paris.spannables;

import android.content.Context;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import com.airbnb.paris.spannables.StyleConverter;
import com.airbnb.paris.styles.ResourceStyle;
import com.airbnb.paris.styles.Style;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0003\u0010\u0014\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/airbnb/paris/spannables/SpannableBuilder;", "", "()V", "markupItems", "", "Lcom/airbnb/paris/spannables/StyleConverter$MarkupItem;", "getMarkupItems$paris_release", "()Ljava/util/Set;", "setMarkupItems$paris_release", "(Ljava/util/Set;)V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getStringBuilder$paris_release", "()Ljava/lang/StringBuilder;", "append", "text", "", "style", "Lcom/airbnb/paris/styles/Style;", "styleRes", "", "applyTo", "", "textView", "Landroid/widget/TextView;", "build", "", "context", "Landroid/content/Context;", "paris_release"})
public final class SpannableBuilder {
    @NotNull
    private Set<StyleConverter.MarkupItem> markupItems = new HashSet();
    @NotNull
    private final StringBuilder stringBuilder = new StringBuilder();

    @NotNull
    public final Set<StyleConverter.MarkupItem> getMarkupItems$paris_release() {
        return this.markupItems;
    }

    public final void setMarkupItems$paris_release(@NotNull Set<StyleConverter.MarkupItem> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.markupItems = set;
    }

    @NotNull
    public final StringBuilder getStringBuilder$paris_release() {
        return this.stringBuilder;
    }

    @JvmOverloads
    @NotNull
    public final SpannableBuilder append(@NotNull String text, @StyleRes int styleRes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (styleRes == 0) {
            this.stringBuilder.append(text);
        } else {
            this.append(text, new ResourceStyle(styleRes, null, 2, null));
        }
        return this;
    }

    public static /* synthetic */ SpannableBuilder append$default(SpannableBuilder spannableBuilder, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return spannableBuilder.append(string2, n);
    }

    @NotNull
    public final SpannableBuilder append(@NotNull String text, @NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        int currentStrLength = this.stringBuilder.length();
        SpannableBuilder spannableBuilder = this;
        spannableBuilder.markupItems = SetsKt.plus(spannableBuilder.markupItems, (Object)new StyleConverter.MarkupItem(new IntRange(currentStrLength, currentStrLength + text.length()), style2));
        this.stringBuilder.append(text);
        return this;
    }

    @NotNull
    public final CharSequence build(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StyleConverter styleConverter = new StyleConverter(context);
        String string2 = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
        return (CharSequence)styleConverter.createSpannable(string2, this.markupItems);
    }

    public final void applyTo(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Context context = textView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"textView.context");
        textView.setText(this.build(context));
    }

    @JvmOverloads
    @NotNull
    public final SpannableBuilder append(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return SpannableBuilder.append$default(this, text, 0, 2, null);
    }
}

