/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.paris.proxies;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.StyleRes;
import androidx.core.widget.TextViewCompat;
import com.airbnb.paris.annotations.AfterStyle;
import com.airbnb.paris.annotations.Attr;
import com.airbnb.paris.annotations.Styleable;
import com.airbnb.paris.proxies.BaseProxy;
import com.airbnb.paris.styles.Style;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Styleable(value="Paris_TextView")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u001b\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u001c\u001a\u00020\u00142\b\b\u0001\u0010\u001d\u001a\u00020\u000bH\u0007J\u0012\u0010\u001e\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u001f\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u000bH\u0007J\u0012\u0010\"\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0012\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0007J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H\u0007J\u0012\u0010,\u001a\u00020\u00142\b\b\u0001\u0010-\u001a\u00020\u000bH\u0007J\u0012\u0010.\u001a\u00020\u00142\b\b\u0001\u0010/\u001a\u00020\u000bH\u0007J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020+H\u0007J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u000bH\u0007J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u000bH\u0007J\u0012\u00106\u001a\u00020\u00142\b\b\u0001\u00107\u001a\u00020\u000bH\u0007J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u000bH\u0007J\u0012\u0010:\u001a\u00020\u00142\b\b\u0001\u0010;\u001a\u00020\u000bH\u0007J\u0010\u0010<\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010=\u001a\u00020\u00142\b\u0010>\u001a\u0004\u0018\u00010'H\u0007J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u000eH\u0007J\u0012\u0010A\u001a\u00020\u00142\b\b\u0001\u0010B\u001a\u00020\u000bH\u0007J\u0012\u0010C\u001a\u00020\u00142\b\u0010D\u001a\u0004\u0018\u00010EH\u0007J\u0012\u0010F\u001a\u00020\u00142\b\u0010D\u001a\u0004\u0018\u00010EH\u0007J\u0012\u0010G\u001a\u00020\u00142\b\b\u0001\u0010H\u001a\u00020\u000bH\u0007J\u0010\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u000bH\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/airbnb/paris/proxies/TextViewProxy;", "Lcom/airbnb/paris/proxies/BaseProxy;", "Landroid/widget/TextView;", "view", "(Landroid/widget/TextView;)V", "drawableBottom", "Landroid/graphics/drawable/Drawable;", "drawableLeft", "drawableRight", "drawableTop", "inputType", "", "Ljava/lang/Integer;", "singleLine", "", "Ljava/lang/Boolean;", "textStyleIndex", "typeface", "Landroid/graphics/Typeface;", "afterStyle", "", "style", "Lcom/airbnb/paris/styles/Style;", "isMultilineInputType", "isPasswordInputType", "setDrawableBottom", "drawable", "setDrawableLeft", "setDrawablePadding", "padding", "setDrawableRight", "setDrawableTop", "setEllipsize", "ellipsize", "setFontFamily", "setGravity", "gravity", "setHint", "hint", "", "setInputType", "setLetterSpacing", "letterSpacing", "", "setLineHeight", "lineHeight", "setLineSpacingExtra", "lineSpacingExtra", "setLineSpacingMultiplier", "lineSpacingMultiplier", "setLines", "lines", "setMaxLines", "maxLines", "setMaxWidth", "maxWidth", "setMinLines", "minLines", "setMinWidth", "minWidth", "setSingleLine", "setText", "text", "setTextAllCaps", "textAllCaps", "setTextAppearance", "textAppearance", "setTextColor", "colors", "Landroid/content/res/ColorStateList;", "setTextColorHint", "setTextSize", "textSize", "setTextStyle", "styleIndex", "paris_release"})
public final class TextViewProxy
extends BaseProxy<TextViewProxy, TextView> {
    @Nullable
    private Drawable drawableLeft;
    @Nullable
    private Drawable drawableTop;
    @Nullable
    private Drawable drawableRight;
    @Nullable
    private Drawable drawableBottom;
    @Nullable
    private Boolean singleLine;
    @Nullable
    private Integer inputType;
    @Nullable
    private Typeface typeface;
    @Nullable
    private Integer textStyleIndex;

    public TextViewProxy(@NotNull TextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super((View)view);
    }

    @Attr(value=1558)
    public final void setTextAppearance(@StyleRes int textAppearance) {
        TextViewCompat.setTextAppearance((TextView)((TextView)this.getView()), (int)textAppearance);
    }

    @Attr(value=1536)
    public final void setDrawableBottom(@Nullable Drawable drawable2) {
        this.drawableBottom = drawable2;
    }

    @Attr(value=1537)
    public final void setDrawableLeft(@Nullable Drawable drawable2) {
        this.drawableLeft = drawable2;
    }

    @Attr(value=1539)
    public final void setDrawableRight(@Nullable Drawable drawable2) {
        this.drawableRight = drawable2;
    }

    @Attr(value=1540)
    public final void setDrawableTop(@Nullable Drawable drawable2) {
        this.drawableTop = drawable2;
    }

    @Attr(value=1538)
    public final void setDrawablePadding(@Px int padding) {
        ((TextView)this.getView()).setCompoundDrawablePadding(padding);
    }

    @Attr(value=1541)
    public final void setEllipsize(int ellipsize) {
        TextUtils.TruncateAt truncateAt;
        TextView textView = (TextView)this.getView();
        int n = ellipsize;
        switch (n) {
            case 1: {
                truncateAt = TextUtils.TruncateAt.START;
                break;
            }
            case 2: {
                truncateAt = TextUtils.TruncateAt.MIDDLE;
                break;
            }
            case 3: {
                truncateAt = TextUtils.TruncateAt.END;
                break;
            }
            case 4: {
                truncateAt = TextUtils.TruncateAt.MARQUEE;
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Invalid value for ellipsize. ", (Object)ellipsize));
            }
        }
        textView.setEllipsize(truncateAt);
    }

    @Attr(value=1542)
    public final void setFontFamily(@Nullable Typeface typeface) {
        this.typeface = typeface;
    }

    @Attr(value=1544)
    public final void setHint(@Nullable CharSequence hint) {
        ((TextView)this.getView()).setHint(hint);
    }

    @Attr(value=1545)
    public final void setInputType(int inputType) {
        this.inputType = inputType;
        ((TextView)this.getView()).setInputType(inputType);
    }

    @Attr(value=1543)
    public final void setGravity(int gravity) {
        ((TextView)this.getView()).setGravity(gravity);
    }

    @Attr(value=1546)
    @RequiresApi(value=21)
    public final void setLetterSpacing(float letterSpacing) {
        ((TextView)this.getView()).setLetterSpacing(letterSpacing);
    }

    @Attr(value=1550)
    public final void setLines(int lines) {
        ((TextView)this.getView()).setLines(lines);
    }

    @Attr(value=1548)
    public final void setLineSpacingExtra(@Px int lineSpacingExtra) {
        ((TextView)this.getView()).setLineSpacing((float)lineSpacingExtra, ((TextView)this.getView()).getLineSpacingMultiplier());
    }

    @Attr(value=1549)
    public final void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        ((TextView)this.getView()).setLineSpacing(((TextView)this.getView()).getLineSpacingExtra(), lineSpacingMultiplier);
    }

    @Attr(value=1551)
    public final void setMaxLines(int maxLines) {
        ((TextView)this.getView()).setMaxLines(maxLines);
    }

    @Attr(value=1553)
    public final void setMinLines(int minLines) {
        ((TextView)this.getView()).setMinLines(minLines);
    }

    @Attr(value=1552)
    public final void setMaxWidth(@Px int maxWidth) {
        ((TextView)this.getView()).setMaxWidth(maxWidth);
    }

    @Attr(value=1554)
    public final void setMinWidth(@Px int minWidth) {
        ((TextView)this.getView()).setMinWidth(minWidth);
    }

    @Attr(value=1555)
    public final void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
    }

    @Attr(value=1556)
    public final void setText(@Nullable CharSequence text) {
        ((TextView)this.getView()).setText(text);
    }

    @Attr(value=1557)
    public final void setTextAllCaps(boolean textAllCaps) {
        ((TextView)this.getView()).setAllCaps(textAllCaps);
    }

    @Attr(value=1559)
    public final void setTextColor(@Nullable ColorStateList colors) {
        ColorStateList colorStateList;
        ((TextView)this.getView()).setTextColor((colorStateList = colors) == null ? ColorStateList.valueOf((int)-16777216) : colorStateList);
    }

    @Attr(value=1560)
    public final void setTextColorHint(@Nullable ColorStateList colors) {
        ((TextView)this.getView()).setHintTextColor(colors);
    }

    @Attr(value=1561)
    public final void setTextSize(@Px int textSize) {
        ((TextView)this.getView()).setTextSize(0, (float)textSize);
    }

    @Attr(value=1562)
    public final void setTextStyle(int styleIndex) {
        this.textStyleIndex = styleIndex;
    }

    @Attr(value=1547)
    public final void setLineHeight(@Px @IntRange(from=0L) int lineHeight) {
        TextViewCompat.setLineHeight((TextView)((TextView)this.getView()), (int)lineHeight);
    }

    @AfterStyle
    public final void afterStyle(@Nullable Style style2) {
        Drawable[] drawables = ((TextView)this.getView()).getCompoundDrawables();
        Drawable drawable2 = this.drawableLeft;
        Drawable drawable3 = drawable2 == null ? drawables[0] : drawable2;
        drawable2 = this.drawableTop;
        Drawable drawable4 = drawable2 == null ? drawables[1] : drawable2;
        drawable2 = this.drawableRight;
        Drawable drawable5 = drawable2 == null ? drawables[2] : drawable2;
        drawable2 = this.drawableBottom;
        ((TextView)this.getView()).setCompoundDrawablesWithIntrinsicBounds(drawable3, drawable4, drawable5, drawable2 == null ? drawables[3] : drawable2);
        this.drawableLeft = null;
        this.drawableTop = null;
        this.drawableRight = null;
        this.drawableBottom = null;
        if (this.singleLine != null) {
            if (this.inputType != null) {
                Integer n = this.inputType;
                Intrinsics.checkNotNull((Object)n);
                this.singleLine = !this.isMultilineInputType(n);
            }
            TextView textView = (TextView)this.getView();
            Boolean bl = this.singleLine;
            Intrinsics.checkNotNull((Object)bl);
            textView.setSingleLine(bl.booleanValue());
        }
        if (this.inputType != null) {
            Integer n = this.inputType;
            Intrinsics.checkNotNull((Object)n);
            if (this.isPasswordInputType(n)) {
                ((TextView)this.getView()).setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            }
        }
        this.inputType = null;
        if (this.typeface != null || this.textStyleIndex != null) {
            Typeface typeface = this.typeface;
            Typeface typefaceToSet = typeface == null ? ((TextView)this.getView()).getTypeface() : typeface;
            Integer n = this.textStyleIndex;
            int textStyleToSet = n == null ? typefaceToSet.getStyle() : n.intValue();
            Typeface typeface2 = Typeface.create((Typeface)typefaceToSet, (int)textStyleToSet);
            ((TextView)this.getView()).setTypeface(typeface2, textStyleToSet);
        }
    }

    private final boolean isMultilineInputType(int inputType) {
        return (inputType & 0x2000F) == 131073;
    }

    private final boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }
}

