/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewStyleApplier;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import com.airbnb.paris.R;
import com.airbnb.paris.StyleApplier;
import com.airbnb.paris.proxies.ImageViewProxy;
import com.airbnb.paris.styles.Style;
import com.airbnb.paris.typed_array_wrappers.TypedArrayWrapper;

@UiThread
public final class ImageViewStyleApplier
extends StyleApplier<ImageViewProxy, ImageView> {
    public ImageViewStyleApplier(ImageView view) {
        super(new ImageViewProxy(view));
    }

    @Override
    protected void applyParent(Style style2) {
        ViewStyleApplier applier = new ViewStyleApplier((View)this.getView());
        applier.setDebugListener(this.getDebugListener());
        applier.apply(style2);
    }

    @Override
    protected int[] attributes() {
        return R.styleable.Paris_ImageView;
    }

    @Override
    protected void processStyleableFields(Style style2, TypedArrayWrapper a) {
        Context context = ((ImageView)this.getView()).getContext();
        Resources res = context.getResources();
    }

    @Override
    protected void processAttributes(Style style2, TypedArrayWrapper a) {
        Context context = ((ImageView)this.getView()).getContext();
        Resources res = context.getResources();
        if (a.hasValue(R.styleable.Paris_ImageView_android_scaleType)) {
            ((ImageViewProxy)this.getProxy()).setScaleType(a.getInt(R.styleable.Paris_ImageView_android_scaleType));
        }
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.Paris_ImageView_android_tint)) {
            ((ImageViewProxy)this.getProxy()).setTint(a.getColorStateList(R.styleable.Paris_ImageView_android_tint));
        }
        if (a.hasValue(R.styleable.Paris_ImageView_android_src)) {
            ((ImageViewProxy)this.getProxy()).setSrc(a.getDrawable(R.styleable.Paris_ImageView_android_src));
        }
    }

    public StyleBuilder builder() {
        return new StyleBuilder(this);
    }

    public void applyDefault() {
    }

    public static void assertStylesContainSameAttributes(Context context) {
    }

    @UiThread
    public static final class StyleBuilder
    extends BaseStyleBuilder<StyleBuilder, ImageViewStyleApplier> {
        public StyleBuilder(ImageViewStyleApplier applier) {
            super(applier);
        }

        public StyleBuilder() {
        }

        public StyleBuilder addDefault() {
            return this;
        }
    }

    public static abstract class BaseStyleBuilder<B extends BaseStyleBuilder<B, A>, A extends StyleApplier<?, ?>>
    extends ViewStyleApplier.BaseStyleBuilder<B, A> {
        public BaseStyleBuilder(A applier) {
            super(applier);
        }

        public BaseStyleBuilder() {
        }

        public B scaleType(int value) {
            this.getBuilder().put(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_scaleType], value);
            return (B)this;
        }

        public B scaleTypeRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_scaleType], resId2);
            return (B)this;
        }

        @RequiresApi(value=21)
        public B tint(@Nullable ColorStateList value) {
            this.getBuilder().put(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_tint], value);
            return (B)this;
        }

        @RequiresApi(value=21)
        public B tintRes(@ColorRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_tint], resId2);
            return (B)this;
        }

        @RequiresApi(value=21)
        public B tint(@ColorInt int color2) {
            this.getBuilder().putColor(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_tint], color2);
            return (B)this;
        }

        public B src(@Nullable Drawable value) {
            this.getBuilder().put(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_src], value);
            return (B)this;
        }

        public B srcRes(@DrawableRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_ImageView[R.styleable.Paris_ImageView_android_src], resId2);
            return (B)this;
        }

        public B applyTo(ImageView view) {
            new ImageViewStyleApplier(view).apply(this.build());
            return (B)this;
        }
    }
}

