/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewStyleApplier;
import android.widget.TextView;
import androidx.annotation.AnyRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.FontRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import com.airbnb.paris.R;
import com.airbnb.paris.StyleApplier;
import com.airbnb.paris.proxies.TextViewProxy;
import com.airbnb.paris.styles.Style;
import com.airbnb.paris.typed_array_wrappers.TypedArrayWrapper;

@UiThread
public final class TextViewStyleApplier
extends StyleApplier<TextViewProxy, TextView> {
    public TextViewStyleApplier(TextView view) {
        super(new TextViewProxy(view));
    }

    @Override
    protected void applyParent(Style style2) {
        ViewStyleApplier applier = new ViewStyleApplier((View)this.getView());
        applier.setDebugListener(this.getDebugListener());
        applier.apply(style2);
    }

    @Override
    protected int[] attributes() {
        return R.styleable.Paris_TextView;
    }

    @Override
    protected void processStyleableFields(Style style2, TypedArrayWrapper a) {
        Context context = ((TextView)this.getView()).getContext();
        Resources res = context.getResources();
    }

    @Override
    protected void processAttributes(Style style2, TypedArrayWrapper a) {
        Context context = ((TextView)this.getView()).getContext();
        Resources res = context.getResources();
        if (a.hasValue(R.styleable.Paris_TextView_android_textAppearance)) {
            ((TextViewProxy)this.getProxy()).setTextAppearance(a.getResourceId(R.styleable.Paris_TextView_android_textAppearance));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_drawableBottom)) {
            ((TextViewProxy)this.getProxy()).setDrawableBottom(a.getDrawable(R.styleable.Paris_TextView_android_drawableBottom));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_drawableLeft)) {
            ((TextViewProxy)this.getProxy()).setDrawableLeft(a.getDrawable(R.styleable.Paris_TextView_android_drawableLeft));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_drawableRight)) {
            ((TextViewProxy)this.getProxy()).setDrawableRight(a.getDrawable(R.styleable.Paris_TextView_android_drawableRight));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_drawableTop)) {
            ((TextViewProxy)this.getProxy()).setDrawableTop(a.getDrawable(R.styleable.Paris_TextView_android_drawableTop));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_drawablePadding)) {
            ((TextViewProxy)this.getProxy()).setDrawablePadding(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_drawablePadding));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_ellipsize)) {
            ((TextViewProxy)this.getProxy()).setEllipsize(a.getInt(R.styleable.Paris_TextView_android_ellipsize));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_fontFamily)) {
            ((TextViewProxy)this.getProxy()).setFontFamily(a.getFont(R.styleable.Paris_TextView_android_fontFamily));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_hint)) {
            ((TextViewProxy)this.getProxy()).setHint(a.getText(R.styleable.Paris_TextView_android_hint));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_inputType)) {
            ((TextViewProxy)this.getProxy()).setInputType(a.getInt(R.styleable.Paris_TextView_android_inputType));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_gravity)) {
            ((TextViewProxy)this.getProxy()).setGravity(a.getInt(R.styleable.Paris_TextView_android_gravity));
        }
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.Paris_TextView_android_letterSpacing)) {
            ((TextViewProxy)this.getProxy()).setLetterSpacing(a.getFloat(R.styleable.Paris_TextView_android_letterSpacing));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_lines)) {
            ((TextViewProxy)this.getProxy()).setLines(a.getInt(R.styleable.Paris_TextView_android_lines));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_lineSpacingExtra)) {
            ((TextViewProxy)this.getProxy()).setLineSpacingExtra(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_lineSpacingExtra));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_lineSpacingMultiplier)) {
            ((TextViewProxy)this.getProxy()).setLineSpacingMultiplier(a.getFloat(R.styleable.Paris_TextView_android_lineSpacingMultiplier));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_maxLines)) {
            ((TextViewProxy)this.getProxy()).setMaxLines(a.getInt(R.styleable.Paris_TextView_android_maxLines));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_minLines)) {
            ((TextViewProxy)this.getProxy()).setMinLines(a.getInt(R.styleable.Paris_TextView_android_minLines));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_maxWidth)) {
            ((TextViewProxy)this.getProxy()).setMaxWidth(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_maxWidth));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_minWidth)) {
            ((TextViewProxy)this.getProxy()).setMinWidth(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_minWidth));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_singleLine)) {
            ((TextViewProxy)this.getProxy()).setSingleLine(a.getBoolean(R.styleable.Paris_TextView_android_singleLine));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_text)) {
            ((TextViewProxy)this.getProxy()).setText(a.getText(R.styleable.Paris_TextView_android_text));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_textAllCaps)) {
            ((TextViewProxy)this.getProxy()).setTextAllCaps(a.getBoolean(R.styleable.Paris_TextView_android_textAllCaps));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_textColor)) {
            ((TextViewProxy)this.getProxy()).setTextColor(a.getColorStateList(R.styleable.Paris_TextView_android_textColor));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_textColorHint)) {
            ((TextViewProxy)this.getProxy()).setTextColorHint(a.getColorStateList(R.styleable.Paris_TextView_android_textColorHint));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_textSize)) {
            ((TextViewProxy)this.getProxy()).setTextSize(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_textSize));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_textStyle)) {
            ((TextViewProxy)this.getProxy()).setTextStyle(a.getInt(R.styleable.Paris_TextView_android_textStyle));
        }
        if (a.hasValue(R.styleable.Paris_TextView_android_lineHeight)) {
            ((TextViewProxy)this.getProxy()).setLineHeight(a.getDimensionPixelSize(R.styleable.Paris_TextView_android_lineHeight));
        }
        ((TextViewProxy)this.getProxy()).afterStyle(style2);
    }

    public StyleBuilder builder() {
        return new StyleBuilder(this);
    }

    public void applyDefault() {
    }

    public static void assertStylesContainSameAttributes(Context context) {
    }

    @UiThread
    public static final class StyleBuilder
    extends BaseStyleBuilder<StyleBuilder, TextViewStyleApplier> {
        public StyleBuilder(TextViewStyleApplier applier) {
            super(applier);
        }

        public StyleBuilder() {
        }

        public StyleBuilder addDefault() {
            return this;
        }
    }

    public static abstract class BaseStyleBuilder<B extends BaseStyleBuilder<B, A>, A extends StyleApplier<?, ?>>
    extends ViewStyleApplier.BaseStyleBuilder<B, A> {
        public BaseStyleBuilder(A applier) {
            super(applier);
        }

        public BaseStyleBuilder() {
        }

        public B textAppearanceRes(@AnyRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textAppearance], resId2);
            return (B)this;
        }

        public B drawableBottom(@Nullable Drawable value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableBottom], value);
            return (B)this;
        }

        public B drawableBottomRes(@DrawableRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableBottom], resId2);
            return (B)this;
        }

        public B drawableLeft(@Nullable Drawable value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableLeft], value);
            return (B)this;
        }

        public B drawableLeftRes(@DrawableRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableLeft], resId2);
            return (B)this;
        }

        public B drawableRight(@Nullable Drawable value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableRight], value);
            return (B)this;
        }

        public B drawableRightRes(@DrawableRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableRight], resId2);
            return (B)this;
        }

        public B drawableTop(@Nullable Drawable value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableTop], value);
            return (B)this;
        }

        public B drawableTopRes(@DrawableRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawableTop], resId2);
            return (B)this;
        }

        public B drawablePadding(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawablePadding], value);
            return (B)this;
        }

        public B drawablePaddingRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawablePadding], resId2);
            return (B)this;
        }

        public B drawablePaddingDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_drawablePadding], value);
            return (B)this;
        }

        public B ellipsize(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_ellipsize], value);
            return (B)this;
        }

        public B ellipsizeRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_ellipsize], resId2);
            return (B)this;
        }

        public B fontFamily(@Nullable Typeface value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_fontFamily], value);
            return (B)this;
        }

        public B fontFamilyRes(@FontRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_fontFamily], resId2);
            return (B)this;
        }

        public B hint(@Nullable CharSequence value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_hint], value);
            return (B)this;
        }

        public B hintRes(@StringRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_hint], resId2);
            return (B)this;
        }

        public B inputType(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_inputType], value);
            return (B)this;
        }

        public B inputTypeRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_inputType], resId2);
            return (B)this;
        }

        public B gravity(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_gravity], value);
            return (B)this;
        }

        public B gravityRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_gravity], resId2);
            return (B)this;
        }

        @RequiresApi(value=21)
        public B letterSpacing(float value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_letterSpacing], Float.valueOf(value));
            return (B)this;
        }

        @RequiresApi(value=21)
        public B letterSpacingRes(@AnyRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_letterSpacing], resId2);
            return (B)this;
        }

        public B lines(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lines], value);
            return (B)this;
        }

        public B linesRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lines], resId2);
            return (B)this;
        }

        public B lineSpacingExtra(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineSpacingExtra], value);
            return (B)this;
        }

        public B lineSpacingExtraRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineSpacingExtra], resId2);
            return (B)this;
        }

        public B lineSpacingExtraDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineSpacingExtra], value);
            return (B)this;
        }

        public B lineSpacingMultiplier(float value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineSpacingMultiplier], Float.valueOf(value));
            return (B)this;
        }

        public B lineSpacingMultiplierRes(@AnyRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineSpacingMultiplier], resId2);
            return (B)this;
        }

        public B maxLines(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_maxLines], value);
            return (B)this;
        }

        public B maxLinesRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_maxLines], resId2);
            return (B)this;
        }

        public B minLines(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_minLines], value);
            return (B)this;
        }

        public B minLinesRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_minLines], resId2);
            return (B)this;
        }

        public B maxWidth(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_maxWidth], value);
            return (B)this;
        }

        public B maxWidthRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_maxWidth], resId2);
            return (B)this;
        }

        public B maxWidthDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_maxWidth], value);
            return (B)this;
        }

        @Override
        public B minWidth(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_minWidth], value);
            return (B)this;
        }

        @Override
        public B minWidthRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_minWidth], resId2);
            return (B)this;
        }

        @Override
        public B minWidthDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_minWidth], value);
            return (B)this;
        }

        public B singleLine(boolean value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_singleLine], value);
            return (B)this;
        }

        public B singleLineRes(@BoolRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_singleLine], resId2);
            return (B)this;
        }

        public B text(@Nullable CharSequence value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_text], value);
            return (B)this;
        }

        public B textRes(@StringRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_text], resId2);
            return (B)this;
        }

        public B textAllCaps(boolean value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textAllCaps], value);
            return (B)this;
        }

        public B textAllCapsRes(@BoolRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textAllCaps], resId2);
            return (B)this;
        }

        public B textColor(@Nullable ColorStateList value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColor], value);
            return (B)this;
        }

        public B textColorRes(@ColorRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColor], resId2);
            return (B)this;
        }

        public B textColor(@ColorInt int color2) {
            this.getBuilder().putColor(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColor], color2);
            return (B)this;
        }

        public B textColorHint(@Nullable ColorStateList value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColorHint], value);
            return (B)this;
        }

        public B textColorHintRes(@ColorRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColorHint], resId2);
            return (B)this;
        }

        public B textColorHint(@ColorInt int color2) {
            this.getBuilder().putColor(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textColorHint], color2);
            return (B)this;
        }

        public B textSize(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textSize], value);
            return (B)this;
        }

        public B textSizeRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textSize], resId2);
            return (B)this;
        }

        public B textSizeDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textSize], value);
            return (B)this;
        }

        public B textStyle(int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textStyle], value);
            return (B)this;
        }

        public B textStyleRes(@IntegerRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_textStyle], resId2);
            return (B)this;
        }

        public B lineHeight(@Px int value) {
            this.getBuilder().put(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineHeight], value);
            return (B)this;
        }

        public B lineHeightRes(@DimenRes int resId2) {
            this.getBuilder().putRes(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineHeight], resId2);
            return (B)this;
        }

        public B lineHeightDp(@Dimension(unit=0) int value) {
            this.getBuilder().putDp(R.styleable.Paris_TextView[R.styleable.Paris_TextView_android_lineHeight], value);
            return (B)this;
        }

        public B applyTo(TextView view) {
            new TextViewStyleApplier(view).apply(this.build());
            return (B)this;
        }
    }
}

