/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.mvrx;

import com.airbnb.mvrx.MvRxStateStore;
import io.reactivex.Observable;
import io.reactivex.subjects.BehaviorSubject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00102\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J!\u0010\u0017\u001a\u00020\u00102\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0002\b\u0019H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/airbnb/mvrx/ScriptableMvRxStateStore;", "S", "", "Lcom/airbnb/mvrx/MvRxStateStore;", "initialState", "(Ljava/lang/Object;)V", "observable", "Lio/reactivex/Observable;", "getObservable", "()Lio/reactivex/Observable;", "state", "getState", "()Ljava/lang/Object;", "subject", "Lio/reactivex/subjects/BehaviorSubject;", "dispose", "", "get", "block", "Lkotlin/Function1;", "isDisposed", "", "next", "set", "stateReducer", "Lkotlin/ExtensionFunctionType;", "mvrx_release"})
public final class ScriptableMvRxStateStore<S>
implements MvRxStateStore<S> {
    private final BehaviorSubject<S> subject;
    @NotNull
    private final Observable<S> observable;

    @Override
    @NotNull
    public Observable<S> getObservable() {
        return this.observable;
    }

    @Override
    @NotNull
    public S getState() {
        Object object = this.subject.getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (S)object;
    }

    @Override
    public void get(@NotNull Function1<? super S, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke(this.getState());
    }

    @Override
    public void set(@NotNull Function1<? super S, ? extends S> stateReducer) {
        Intrinsics.checkParameterIsNotNull(stateReducer, (String)"stateReducer");
    }

    public final void next(@NotNull S state) {
        Intrinsics.checkParameterIsNotNull(state, (String)"state");
        this.subject.onNext(state);
    }

    public boolean isDisposed() {
        return false;
    }

    public void dispose() {
    }

    public ScriptableMvRxStateStore(@NotNull S initialState) {
        Intrinsics.checkParameterIsNotNull(initialState, (String)"initialState");
        BehaviorSubject behaviorSubject = BehaviorSubject.createDefault(initialState);
        Intrinsics.checkExpressionValueIsNotNull((Object)behaviorSubject, (String)"BehaviorSubject.createDefault(initialState)");
        this.subject = behaviorSubject;
        Observable observable = this.subject.distinctUntilChanged();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"subject.distinctUntilChanged()");
        this.observable = observable;
    }
}

