/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.mvrx;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a \u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0000\u001a \u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0000\"2\u0010\u0000\u001a \u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"primitiveWrapperMap", "", "Ljava/lang/Class;", "", "getPrimitiveWrapperMap", "()Ljava/util/Map;", "isAssignableTo", "", "from", "to", "isPrimitiveWrapperOf", "targetClass", "primitive", "mvrx_release"})
public final class ReflectionExtensionsKt {
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> primitiveWrapperMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Boolean.TYPE, Boolean.TYPE), TuplesKt.to(Byte.TYPE, Byte.class), TuplesKt.to(Character.TYPE, Character.class), TuplesKt.to(Double.TYPE, Double.class), TuplesKt.to(Float.TYPE, Float.class), TuplesKt.to(Integer.TYPE, Integer.class), TuplesKt.to(Long.TYPE, Long.class), TuplesKt.to(Short.TYPE, Short.class)});

    @NotNull
    public static final Map<Class<? extends Object>, Class<? extends Object>> getPrimitiveWrapperMap() {
        return primitiveWrapperMap;
    }

    public static final boolean isPrimitiveWrapperOf(@NotNull Class<?> targetClass, @NotNull Class<?> primitive) {
        Intrinsics.checkParameterIsNotNull(targetClass, (String)"targetClass");
        Intrinsics.checkParameterIsNotNull(primitive, (String)"primitive");
        if (!primitive.isPrimitive()) {
            throw (Throwable)new IllegalArgumentException("First argument has to be primitive type");
        }
        return Intrinsics.areEqual(primitiveWrapperMap.get(primitive), targetClass);
    }

    public static final boolean isAssignableTo(@NotNull Class<?> from, @NotNull Class<?> to) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Intrinsics.checkParameterIsNotNull(to, (String)"to");
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            return ReflectionExtensionsKt.isPrimitiveWrapperOf(to, from);
        }
        return to.isPrimitive() ? ReflectionExtensionsKt.isPrimitiveWrapperOf(from, to) : false;
    }
}

