/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.mvrx;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.airbnb.mvrx.DeliveryMode;
import com.airbnb.mvrx.RedeliverOnStart;
import com.airbnb.mvrx.UniqueOnly;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.observers.LambdaObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u00052\b\u0012\u0004\u0012\u0002H\u00010\u00062\u00020\u0004:\u00011B{\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0011\u0012\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0011\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018BK\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000\u0012\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010$\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u0017H\u0002J\b\u0010\u000e\u001a\u00020\u0017H\u0016J\b\u0010'\u001a\u00020\u0017H\u0007J\u0010\u0010\u0012\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0013H\u0016J\b\u0010)\u001a\u00020\u0017H\u0007J\u0015\u0010\u0014\u001a\u00020\u00172\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010\u0010\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\bH\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\b\u0010/\u001a\u00020\u0017H\u0002J\b\u00100\u001a\u00020\u0017H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0012\u0010\u0019\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0012\u0010 \u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0012\u0010!\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/airbnb/mvrx/MvRxLifecycleAwareObserver;", "T", "", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/reactivex/disposables/Disposable;", "Landroidx/lifecycle/LifecycleObserver;", "Lio/reactivex/Observer;", "owner", "Landroidx/lifecycle/LifecycleOwner;", "activeState", "Landroidx/lifecycle/Lifecycle$State;", "deliveryMode", "Lcom/airbnb/mvrx/DeliveryMode;", "lastDeliveredValue", "onComplete", "Lio/reactivex/functions/Action;", "onSubscribe", "Lio/reactivex/functions/Consumer;", "onError", "", "onNext", "onDispose", "Lkotlin/Function0;", "", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/Lifecycle$State;Lcom/airbnb/mvrx/DeliveryMode;Ljava/lang/Object;Lio/reactivex/functions/Action;Lio/reactivex/functions/Consumer;Lio/reactivex/functions/Consumer;Lio/reactivex/functions/Consumer;Lkotlin/jvm/functions/Function0;)V", "lastDeliveredValueFromPriorObserver", "sourceObserver", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/Lifecycle$State;Lcom/airbnb/mvrx/DeliveryMode;Ljava/lang/Object;Lio/reactivex/Observer;Lkotlin/jvm/functions/Function0;)V", "isUnlocked", "", "()Z", "Ljava/lang/Object;", "lastUndeliveredValue", "lastValue", "locked", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dispose", "isDisposed", "lock", "onDestroy", "e", "onLifecycleEvent", "nextValue", "(Ljava/lang/Object;)V", "d", "requireOwner", "requireSourceObserver", "unlock", "updateLock", "Companion", "mvrx_release"})
public final class MvRxLifecycleAwareObserver<T>
extends AtomicReference<Disposable>
implements LifecycleObserver,
Observer<T>,
Disposable {
    private T lastUndeliveredValue;
    private T lastValue;
    private final AtomicBoolean locked;
    private LifecycleOwner owner;
    private final Lifecycle.State activeState;
    private final DeliveryMode deliveryMode;
    private T lastDeliveredValueFromPriorObserver;
    private Observer<T> sourceObserver;
    private final Function0<Unit> onDispose;
    private static final Lifecycle.State DEFAULT_ACTIVE_STATE;
    public static final Companion Companion;

    private final boolean isUnlocked() {
        return !this.locked.get();
    }

    public void onSubscribe(@NotNull Disposable d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)d)) {
            this.requireOwner().getLifecycle().addObserver((LifecycleObserver)this);
            this.requireSourceObserver().onSubscribe((Disposable)this);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.requireOwner().getLifecycle().removeObserver((LifecycleObserver)this);
        if (!this.isDisposed()) {
            this.dispose();
        }
        this.owner = null;
        this.sourceObserver = null;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
    public final void onLifecycleEvent() {
        this.updateLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateLock() {
        LifecycleOwner lifecycleOwner2 = this.owner;
        if (lifecycleOwner2 != null && (lifecycleOwner2 = lifecycleOwner2.getLifecycle()) != null && (lifecycleOwner2 = lifecycleOwner2.getCurrentState()) != null) {
            if (lifecycleOwner2.isAtLeast(this.activeState)) {
                this.unlock();
                return;
            }
        }
        this.lock();
    }

    public void onNext(@NotNull T nextValue) {
        Intrinsics.checkParameterIsNotNull(nextValue, (String)"nextValue");
        if (this.isUnlocked()) {
            boolean suppressRepeatedFirstValue = this.deliveryMode instanceof UniqueOnly && Intrinsics.areEqual(this.lastDeliveredValueFromPriorObserver, nextValue);
            this.lastDeliveredValueFromPriorObserver = null;
            if (!suppressRepeatedFirstValue) {
                this.requireSourceObserver().onNext(nextValue);
            }
        } else {
            this.lastUndeliveredValue = nextValue;
        }
        this.lastValue = nextValue;
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            this.requireSourceObserver().onError(e);
        }
    }

    public void onComplete() {
        this.requireSourceObserver().onComplete();
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
        this.onDispose.invoke();
    }

    public boolean isDisposed() {
        return (Disposable)this.get() == DisposableHelper.DISPOSED;
    }

    private final void unlock() {
        if (!this.locked.getAndSet(false)) {
            return;
        }
        if (!this.isDisposed()) {
            T t;
            if (this.deliveryMode instanceof UniqueOnly) {
                t = this.lastUndeliveredValue;
            } else if (this.deliveryMode instanceof RedeliverOnStart && this.lastUndeliveredValue != null) {
                t = this.lastUndeliveredValue;
            } else if (this.deliveryMode instanceof RedeliverOnStart && this.lastUndeliveredValue == null) {
                t = this.lastValue;
            } else {
                throw (Throwable)new IllegalStateException("Value to deliver on unlock should be exhaustive.");
            }
            T valueToDeliverOnUnlock = t;
            this.lastUndeliveredValue = null;
            if (valueToDeliverOnUnlock != null) {
                this.onNext(valueToDeliverOnUnlock);
            }
        }
    }

    private final void lock() {
        this.locked.set(true);
    }

    private final LifecycleOwner requireOwner() {
        LifecycleOwner lifecycleOwner2 = this.owner;
        boolean bl = false;
        boolean bl2 = false;
        if (lifecycleOwner2 == null) {
            boolean bl3 = false;
            String string = "Cannot access lifecycleOwner after onDestroy.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return lifecycleOwner2;
    }

    private final Observer<T> requireSourceObserver() {
        Observer<T> observer = this.sourceObserver;
        boolean bl = false;
        boolean bl2 = false;
        if (observer == null) {
            boolean bl3 = false;
            String string = "Cannot access observer after onDestroy.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return observer;
    }

    public MvRxLifecycleAwareObserver(@Nullable LifecycleOwner owner, @NotNull Lifecycle.State activeState, @NotNull DeliveryMode deliveryMode, @Nullable T lastDeliveredValueFromPriorObserver, @Nullable Observer<T> sourceObserver, @NotNull Function0<Unit> onDispose) {
        Intrinsics.checkParameterIsNotNull((Object)activeState, (String)"activeState");
        Intrinsics.checkParameterIsNotNull((Object)deliveryMode, (String)"deliveryMode");
        Intrinsics.checkParameterIsNotNull(onDispose, (String)"onDispose");
        this.owner = owner;
        this.activeState = activeState;
        this.deliveryMode = deliveryMode;
        this.lastDeliveredValueFromPriorObserver = lastDeliveredValueFromPriorObserver;
        this.sourceObserver = sourceObserver;
        this.onDispose = onDispose;
        this.locked = new AtomicBoolean(true);
    }

    public /* synthetic */ MvRxLifecycleAwareObserver(LifecycleOwner lifecycleOwner2, Lifecycle.State state, DeliveryMode deliveryMode, Object object, Observer observer, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            state = DEFAULT_ACTIVE_STATE;
        }
        if ((n & 4) != 0) {
            deliveryMode = RedeliverOnStart.INSTANCE;
        }
        this(lifecycleOwner2, state, deliveryMode, object, observer, (Function0<Unit>)function0);
    }

    public MvRxLifecycleAwareObserver(@NotNull LifecycleOwner owner, @NotNull Lifecycle.State activeState, @NotNull DeliveryMode deliveryMode, @Nullable T lastDeliveredValue, @NotNull Action onComplete, @NotNull Consumer<? super Disposable> onSubscribe, @NotNull Consumer<? super Throwable> onError, @NotNull Consumer<T> onNext, @NotNull Function0<Unit> onDispose) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)activeState, (String)"activeState");
        Intrinsics.checkParameterIsNotNull((Object)deliveryMode, (String)"deliveryMode");
        Intrinsics.checkParameterIsNotNull((Object)onComplete, (String)"onComplete");
        Intrinsics.checkParameterIsNotNull(onSubscribe, (String)"onSubscribe");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Intrinsics.checkParameterIsNotNull(onNext, (String)"onNext");
        Intrinsics.checkParameterIsNotNull(onDispose, (String)"onDispose");
        this(owner, activeState, deliveryMode, lastDeliveredValue, (Observer)new LambdaObserver(onNext, onError, onComplete, onSubscribe), onDispose);
    }

    public /* synthetic */ MvRxLifecycleAwareObserver(LifecycleOwner lifecycleOwner2, Lifecycle.State state, DeliveryMode deliveryMode, Object object, Action action, Consumer consumer, Consumer consumer2, Consumer consumer3, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            state = DEFAULT_ACTIVE_STATE;
        }
        if ((n & 4) != 0) {
            deliveryMode = RedeliverOnStart.INSTANCE;
        }
        if ((n & 8) != 0) {
            object = null;
        }
        if ((n & 0x10) != 0) {
            Action action2 = Functions.EMPTY_ACTION;
            Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"Functions.EMPTY_ACTION");
            action = action2;
        }
        if ((n & 0x20) != 0) {
            Consumer consumer4 = Functions.emptyConsumer();
            Intrinsics.checkExpressionValueIsNotNull((Object)consumer4, (String)"Functions.emptyConsumer()");
            consumer = consumer4;
        }
        if ((n & 0x40) != 0) {
            Consumer consumer5 = Functions.ON_ERROR_MISSING;
            Intrinsics.checkExpressionValueIsNotNull((Object)consumer5, (String)"Functions.ON_ERROR_MISSING");
            consumer2 = consumer5;
        }
        if ((n & 0x80) != 0) {
            Consumer consumer6 = Functions.emptyConsumer();
            Intrinsics.checkExpressionValueIsNotNull((Object)consumer6, (String)"Functions.emptyConsumer()");
            consumer3 = consumer6;
        }
        this(lifecycleOwner2, state, deliveryMode, object, action, (Consumer<? super Disposable>)consumer, (Consumer<? super Throwable>)consumer2, consumer3, (Function0<Unit>)function0);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_ACTIVE_STATE = Lifecycle.State.STARTED;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/airbnb/mvrx/MvRxLifecycleAwareObserver$Companion;", "", "()V", "DEFAULT_ACTIVE_STATE", "Landroidx/lifecycle/Lifecycle$State;", "mvrx_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

