/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.airbnb.lottie.network.LottieFetchResult;
import com.airbnb.lottie.utils.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DefaultLottieFetchResult
implements LottieFetchResult {
    @NonNull
    private final HttpURLConnection connection;

    public DefaultLottieFetchResult(@NonNull HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isSuccessful() {
        try {
            return this.connection.getResponseCode() / 100 == 2;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    @NonNull
    public InputStream bodyByteStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    @Nullable
    public String contentType() {
        return this.connection.getContentType();
    }

    @Override
    @Nullable
    public String error() {
        try {
            return this.isSuccessful() ? null : "Unable to fetch " + this.connection.getURL() + ". Failed with " + this.connection.getResponseCode() + "\n" + this.getErrorFromConnection(this.connection);
        }
        catch (IOException | NullPointerException e) {
            Logger.warning("get error failed ", e);
            return e.getMessage();
        }
    }

    @Override
    public void close() {
        this.connection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorFromConnection(HttpURLConnection connection) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        StringBuilder error = new StringBuilder();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                error.append(line).append('\n');
            }
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
        return error.toString();
    }
}

