/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Matrix;
import android.graphics.PointF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.SplitDimensionPathKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.Transform3D;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.ScaleXY;
import java.util.Collections;

public class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final Matrix skewMatrix1;
    private final Matrix skewMatrix2;
    private final Matrix skewMatrix3;
    private final float[] skewValues;
    private float cachedRotationX = Float.NaN;
    private float cachedRotationY = Float.NaN;
    private float cachedRotationZ = Float.NaN;
    private float cachedCosX = 1.0f;
    private float cachedCosY = 1.0f;
    private boolean rotation3DCacheDirty = true;
    @Nullable
    private BaseKeyframeAnimation<PointF, PointF> anchorPoint;
    @Nullable
    private BaseKeyframeAnimation<?, PointF> position;
    @Nullable
    private BaseKeyframeAnimation<ScaleXY, ScaleXY> scale;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> rotation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> opacity;
    @Nullable
    private FloatKeyframeAnimation skew;
    @Nullable
    private FloatKeyframeAnimation skewAngle;
    @Nullable
    private FloatKeyframeAnimation rotationX;
    @Nullable
    private FloatKeyframeAnimation rotationY;
    @Nullable
    private FloatKeyframeAnimation rotationZ;
    @Nullable
    private BaseKeyframeAnimation<?, Float> startOpacity;
    @Nullable
    private BaseKeyframeAnimation<?, Float> endOpacity;
    private final boolean autoOrient;

    public TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint() == null ? null : animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition() == null ? null : animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale() == null ? null : animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation() == null ? null : animatableTransform.getRotation().createAnimation();
        this.skew = animatableTransform.getSkew() == null ? null : animatableTransform.getSkew().createAnimation();
        this.autoOrient = animatableTransform.isAutoOrient();
        this.rotationX = animatableTransform.getRotationX() == null ? null : animatableTransform.getRotationX().createAnimation();
        this.rotationY = animatableTransform.getRotationY() == null ? null : animatableTransform.getRotationY().createAnimation();
        FloatKeyframeAnimation floatKeyframeAnimation = this.rotationZ = animatableTransform.getRotationZ() == null ? null : animatableTransform.getRotationZ().createAnimation();
        if (this.skew != null) {
            this.skewMatrix1 = new Matrix();
            this.skewMatrix2 = new Matrix();
            this.skewMatrix3 = new Matrix();
            this.skewValues = new float[9];
        } else {
            this.skewMatrix1 = null;
            this.skewMatrix2 = null;
            this.skewMatrix3 = null;
            this.skewValues = null;
        }
        FloatKeyframeAnimation floatKeyframeAnimation2 = this.skewAngle = animatableTransform.getSkewAngle() == null ? null : animatableTransform.getSkewAngle().createAnimation();
        if (animatableTransform.getOpacity() != null) {
            this.opacity = animatableTransform.getOpacity().createAnimation();
        }
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    public void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.opacity);
        layer.addAnimation(this.startOpacity);
        layer.addAnimation(this.endOpacity);
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        layer.addAnimation(this.skew);
        layer.addAnimation(this.skewAngle);
        layer.addAnimation(this.rotationX);
        layer.addAnimation(this.rotationY);
        layer.addAnimation(this.rotationZ);
    }

    public void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        if (this.opacity != null) {
            this.opacity.addUpdateListener(listener);
        }
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(listener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(listener);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.addUpdateListener(listener);
        }
        if (this.position != null) {
            this.position.addUpdateListener(listener);
        }
        if (this.scale != null) {
            this.scale.addUpdateListener(listener);
        }
        if (this.rotation != null) {
            this.rotation.addUpdateListener(listener);
        }
        if (this.skew != null) {
            this.skew.addUpdateListener(listener);
        }
        if (this.skewAngle != null) {
            this.skewAngle.addUpdateListener(listener);
        }
        if (this.rotationX != null) {
            this.rotationX.addUpdateListener(listener);
            this.rotationX.addUpdateListener(() -> {
                this.rotation3DCacheDirty = true;
            });
        }
        if (this.rotationY != null) {
            this.rotationY.addUpdateListener(listener);
            this.rotationY.addUpdateListener(() -> {
                this.rotation3DCacheDirty = true;
            });
        }
        if (this.rotationZ != null) {
            this.rotationZ.addUpdateListener(listener);
            this.rotationZ.addUpdateListener(() -> {
                this.rotation3DCacheDirty = true;
            });
        }
    }

    public void setProgress(float progress) {
        if (this.opacity != null) {
            this.opacity.setProgress(progress);
        }
        if (this.startOpacity != null) {
            this.startOpacity.setProgress(progress);
        }
        if (this.endOpacity != null) {
            this.endOpacity.setProgress(progress);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.setProgress(progress);
        }
        if (this.position != null) {
            this.position.setProgress(progress);
        }
        if (this.scale != null) {
            this.scale.setProgress(progress);
        }
        if (this.rotation != null) {
            this.rotation.setProgress(progress);
        }
        if (this.skew != null) {
            this.skew.setProgress(progress);
        }
        if (this.skewAngle != null) {
            this.skewAngle.setProgress(progress);
        }
        if (this.rotationX != null) {
            this.rotationX.setProgress(progress);
        }
        if (this.rotationY != null) {
            this.rotationY.setProgress(progress);
        }
        if (this.rotationZ != null) {
            this.rotationZ.setProgress(progress);
        }
    }

    @Nullable
    public BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getEndOpacity() {
        return this.endOpacity;
    }

    public Matrix getMatrix() {
        PointF anchorPointValue;
        BaseKeyframeAnimation<PointF, PointF> anchorPoint;
        ScaleXY scaleTransform;
        BaseKeyframeAnimation<ScaleXY, ScaleXY> scale;
        FloatKeyframeAnimation skew;
        PointF positionValue;
        boolean has3DRotation;
        this.matrix.reset();
        boolean bl = has3DRotation = this.rotationX != null && this.rotationX.getFloatValue() != 0.0f || this.rotationY != null && this.rotationY.getFloatValue() != 0.0f || this.rotationZ != null && this.rotationZ.getFloatValue() != 0.0f;
        if (has3DRotation) {
            float rotZ;
            float rotX = this.rotationX != null ? this.rotationX.getFloatValue() : 0.0f;
            float rotY = this.rotationY != null ? this.rotationY.getFloatValue() : 0.0f;
            float f = rotZ = this.rotationZ != null ? this.rotationZ.getFloatValue() : 0.0f;
            if (this.rotation3DCacheDirty || rotX != this.cachedRotationX || rotY != this.cachedRotationY || rotZ != this.cachedRotationZ) {
                this.cachedRotationX = rotX;
                this.cachedRotationY = rotY;
                this.cachedRotationZ = rotZ;
                this.cachedCosX = rotX != 0.0f ? (float)Math.cos(Math.toRadians(rotX)) : 1.0f;
                this.cachedCosY = rotY != 0.0f ? (float)Math.cos(Math.toRadians(rotY)) : 1.0f;
                this.rotation3DCacheDirty = false;
            }
            PointF anchorPointValue2 = this.anchorPoint == null ? null : this.anchorPoint.getValue();
            PointF positionValue2 = this.position == null ? null : this.position.getValue();
            ScaleXY scaleValue = this.scale == null ? null : this.scale.getValue();
            float scaleX = scaleValue != null ? scaleValue.getScaleX() : 1.0f;
            float scaleY = scaleValue != null ? scaleValue.getScaleY() : 1.0f;
            Transform3D.applyTransform(this.matrix, anchorPointValue2, positionValue2, scaleX, scaleY, rotX, rotY, rotZ, this.cachedCosX, this.cachedCosY);
            return this.matrix;
        }
        BaseKeyframeAnimation<?, PointF> position = this.position;
        if (position != null && (positionValue = position.getValue()) != null && (positionValue.x != 0.0f || positionValue.y != 0.0f)) {
            this.matrix.preTranslate(positionValue.x, positionValue.y);
        }
        if (this.autoOrient) {
            if (position != null) {
                float currentProgress = position.getProgress();
                PointF startPosition = position.getValue();
                float startX = startPosition.x;
                float startY = startPosition.y;
                position.setProgress(currentProgress + 1.0E-4f);
                PointF nextPosition = position.getValue();
                position.setProgress(currentProgress);
                double rotationValue = Math.toDegrees(Math.atan2(nextPosition.y - startY, nextPosition.x - startX));
                this.matrix.preRotate((float)rotationValue);
            }
        } else {
            float rotationValue;
            BaseKeyframeAnimation<Float, Float> rotation = this.rotation;
            if (rotation != null && (rotationValue = rotation instanceof ValueCallbackKeyframeAnimation ? rotation.getValue().floatValue() : ((FloatKeyframeAnimation)rotation).getFloatValue()) != 0.0f) {
                this.matrix.preRotate(rotationValue);
            }
        }
        if ((skew = this.skew) != null) {
            float mCos = this.skewAngle == null ? 0.0f : (float)Math.cos(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float mSin = this.skewAngle == null ? 1.0f : (float)Math.sin(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float aTan = (float)Math.tan(Math.toRadians(skew.getFloatValue()));
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = mSin;
            this.skewValues[3] = -mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix1.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = 1.0f;
            this.skewValues[3] = aTan;
            this.skewValues[4] = 1.0f;
            this.skewValues[8] = 1.0f;
            this.skewMatrix2.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = -mSin;
            this.skewValues[3] = mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix3.setValues(this.skewValues);
            this.skewMatrix2.preConcat(this.skewMatrix1);
            this.skewMatrix3.preConcat(this.skewMatrix2);
            this.matrix.preConcat(this.skewMatrix3);
        }
        if ((scale = this.scale) != null && (scaleTransform = scale.getValue()) != null && (scaleTransform.getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f)) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        if ((anchorPoint = this.anchorPoint) != null && (anchorPointValue = anchorPoint.getValue()) != null && (anchorPointValue.x != 0.0f || anchorPointValue.y != 0.0f)) {
            this.matrix.preTranslate(-anchorPointValue.x, -anchorPointValue.y);
        }
        return this.matrix;
    }

    private void clearSkewValues() {
        for (int i = 0; i < 9; ++i) {
            this.skewValues[i] = 0.0f;
        }
    }

    public Matrix getMatrixForRepeater(float amount) {
        boolean has3DRotation;
        PointF position = this.position == null ? null : this.position.getValue();
        ScaleXY scale = this.scale == null ? null : this.scale.getValue();
        PointF anchorPoint = this.anchorPoint == null ? null : this.anchorPoint.getValue();
        this.matrix.reset();
        if (position != null) {
            this.matrix.preTranslate(position.x * amount, position.y * amount);
        }
        float rotX = this.rotationX != null ? this.rotationX.getFloatValue() * amount : 0.0f;
        float rotY = this.rotationY != null ? this.rotationY.getFloatValue() * amount : 0.0f;
        float rotZ = this.rotationZ != null ? this.rotationZ.getFloatValue() * amount : 0.0f;
        boolean bl = has3DRotation = rotX != 0.0f || rotY != 0.0f || rotZ != 0.0f;
        if (has3DRotation) {
            float cosY;
            float cosX = rotX != 0.0f ? (float)Math.cos(Math.toRadians(rotX)) : 1.0f;
            float f = cosY = rotY != 0.0f ? (float)Math.cos(Math.toRadians(rotY)) : 1.0f;
            if (rotZ != 0.0f) {
                this.matrix.preRotate(rotZ, anchorPoint == null ? 0.0f : anchorPoint.x, anchorPoint == null ? 0.0f : anchorPoint.y);
            }
            Transform3D.apply3DRotations(this.matrix, rotX, rotY, 0.0f, cosX, cosY);
        } else if (this.rotation != null) {
            float rotation = this.rotation.getValue().floatValue();
            this.matrix.preRotate(rotation * amount, anchorPoint == null ? 0.0f : anchorPoint.x, anchorPoint == null ? 0.0f : anchorPoint.y);
        }
        if (scale != null) {
            this.matrix.preScale((float)Math.pow(scale.getScaleX(), amount), (float)Math.pow(scale.getScaleY(), amount));
        }
        return this.matrix;
    }

    public <T> boolean applyValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.TRANSFORM_ANCHOR_POINT) {
            if (this.anchorPoint == null) {
                this.anchorPoint = new ValueCallbackKeyframeAnimation<PointF, PointF>(callback, new PointF());
            } else {
                this.anchorPoint.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_POSITION) {
            if (this.position == null) {
                this.position = new ValueCallbackKeyframeAnimation(callback, new PointF());
            } else {
                this.position.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_POSITION_X && this.position instanceof SplitDimensionPathKeyframeAnimation) {
            ((SplitDimensionPathKeyframeAnimation)this.position).setXValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_POSITION_Y && this.position instanceof SplitDimensionPathKeyframeAnimation) {
            ((SplitDimensionPathKeyframeAnimation)this.position).setYValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SCALE) {
            if (this.scale == null) {
                this.scale = new ValueCallbackKeyframeAnimation<ScaleXY, ScaleXY>(callback, new ScaleXY());
            } else {
                this.scale.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_ROTATION) {
            if (this.rotation == null) {
                this.rotation = new ValueCallbackKeyframeAnimation<Float, Float>(callback, Float.valueOf(0.0f));
            } else {
                this.rotation.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_OPACITY) {
            if (this.opacity == null) {
                this.opacity = new ValueCallbackKeyframeAnimation<Integer, Integer>(callback, 100);
            } else {
                this.opacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_START_OPACITY) {
            if (this.startOpacity == null) {
                this.startOpacity = new ValueCallbackKeyframeAnimation(callback, Float.valueOf(100.0f));
            } else {
                this.startOpacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_END_OPACITY) {
            if (this.endOpacity == null) {
                this.endOpacity = new ValueCallbackKeyframeAnimation(callback, Float.valueOf(100.0f));
            } else {
                this.endOpacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_SKEW) {
            if (this.skew == null) {
                this.skew = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.skew.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SKEW_ANGLE) {
            if (this.skewAngle == null) {
                this.skewAngle = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.skewAngle.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_ROTATION_X) {
            if (this.rotationX == null) {
                this.rotationX = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.rotationX.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_ROTATION_Y) {
            if (this.rotationY == null) {
                this.rotationY = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.rotationY.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_ROTATION_Z) {
            if (this.rotationZ == null) {
                this.rotationZ = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.rotationZ.setValueCallback(callback);
        } else {
            return false;
        }
        return true;
    }
}

