/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.graphics.PointF;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentData {
    public String text;
    public String fontName;
    public float size;
    public Justification justification;
    public int tracking;
    public float lineHeight;
    public float baselineShift;
    @ColorInt
    public int color;
    @ColorInt
    public int strokeColor;
    public float strokeWidth;
    public boolean strokeOverFill;
    @Nullable
    public PointF boxPosition;
    @Nullable
    public PointF boxSize;

    public DocumentData(String text, String fontName, float size, Justification justification, int tracking, float lineHeight, float baselineShift, @ColorInt int color, @ColorInt int strokeColor, float strokeWidth, boolean strokeOverFill, PointF boxPosition, PointF boxSize) {
        this.set(text, fontName, size, justification, tracking, lineHeight, baselineShift, color, strokeColor, strokeWidth, strokeOverFill, boxPosition, boxSize);
    }

    public DocumentData() {
    }

    public void set(String text, String fontName, float size, Justification justification, int tracking, float lineHeight, float baselineShift, @ColorInt int color, @ColorInt int strokeColor, float strokeWidth, boolean strokeOverFill, PointF boxPosition, PointF boxSize) {
        this.text = text;
        this.fontName = fontName;
        this.size = size;
        this.justification = justification;
        this.tracking = tracking;
        this.lineHeight = lineHeight;
        this.baselineShift = baselineShift;
        this.color = color;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.strokeOverFill = strokeOverFill;
        this.boxPosition = boxPosition;
        this.boxSize = boxSize;
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.fontName.hashCode();
        result = (int)((float)(31 * result) + this.size);
        result = 31 * result + this.justification.ordinal();
        result = 31 * result + this.tracking;
        long temp = Float.floatToRawIntBits(this.lineHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.color;
        return result;
    }

    public static enum Justification {
        LEFT_ALIGN,
        RIGHT_ALIGN,
        CENTER;

    }
}

