/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

public class LottieImageAsset {
    private final int width;
    private final int height;
    private final String id;
    private final String fileName;
    private final String dirName;
    @Nullable
    private Bitmap bitmap;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public LottieImageAsset(int width, int height, String id, String fileName, String dirName) {
        this.width = width;
        this.height = height;
        this.id = id;
        this.fileName = fileName;
        this.dirName = dirName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDirName() {
        return this.dirName;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(@Nullable Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public LottieImageAsset copyWithScale(float scale) {
        LottieImageAsset newAsset = new LottieImageAsset((int)((float)this.width * scale), (int)((float)this.height * scale), this.id, this.fileName, this.dirName);
        if (this.bitmap != null) {
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)newAsset.width, (int)newAsset.height, (boolean)true);
            newAsset.setBitmap(scaledBitmap);
        }
        return newAsset;
    }

    public boolean hasBitmap() {
        return this.bitmap != null || this.fileName.startsWith("data:") && this.fileName.indexOf("base64,") > 0;
    }
}

