/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import com.airbnb.lottie.animation.keyframe.KeyframeAnimation;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.Keyframe;
import java.util.List;

public class IntegerKeyframeAnimation
extends KeyframeAnimation<Integer> {
    public IntegerKeyframeAnimation(List<Keyframe<Integer>> keyframes) {
        super(keyframes);
    }

    @Override
    Integer getValue(Keyframe<Integer> keyframe, float keyframeProgress) {
        return this.getIntValue(keyframe, keyframeProgress);
    }

    int getIntValue(Keyframe<Integer> keyframe, float keyframeProgress) {
        Integer value;
        int endValue;
        if (keyframe.startValue == null) {
            throw new IllegalStateException("Missing values for keyframe.");
        }
        int n = endValue = keyframe.endValue == null ? keyframe.getStartValueInt() : keyframe.getEndValueInt();
        if (this.valueCallback != null && (value = this.valueCallback.getValueInternal(keyframe.startFrame, keyframe.endFrame.floatValue(), (Integer)keyframe.startValue, endValue, keyframeProgress, this.getLinearCurrentKeyframeProgress(), this.getProgress())) != null) {
            return value;
        }
        return MiscUtils.lerp(keyframe.getStartValueInt(), endValue, keyframeProgress);
    }

    public int getIntValue() {
        return this.getIntValue(this.getCurrentKeyframe(), this.getInterpolatedCurrentKeyframeProgress());
    }
}

