/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.content.GreedyContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.KeyPathElement;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.DropShadow;
import com.airbnb.lottie.utils.OffscreenLayer;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public class ContentGroup
implements DrawingContent,
PathContent,
BaseKeyframeAnimation.AnimationListener,
KeyPathElement {
    private final OffscreenLayer.ComposeOp offscreenOp = new OffscreenLayer.ComposeOp();
    private final RectF offScreenRectF = new RectF();
    private final OffscreenLayer offscreenLayer = new OffscreenLayer();
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final boolean hidden;
    private final List<Content> contents;
    private final LottieDrawable lottieDrawable;
    @Nullable
    private List<PathContent> pathContents;
    @Nullable
    private TransformKeyframeAnimation transformAnimation;

    private static List<Content> contentsFromModels(LottieDrawable drawable, LottieComposition composition, BaseLayer layer, List<ContentModel> contentModels) {
        ArrayList<Content> contents = new ArrayList<Content>(contentModels.size());
        for (int i = 0; i < contentModels.size(); ++i) {
            Content content = contentModels.get(i).toContent(drawable, composition, layer);
            if (content == null) continue;
            contents.add(content);
        }
        return contents;
    }

    @Nullable
    static AnimatableTransform findTransform(List<ContentModel> contentModels) {
        for (int i = 0; i < contentModels.size(); ++i) {
            ContentModel contentModel = contentModels.get(i);
            if (!(contentModel instanceof AnimatableTransform)) continue;
            return (AnimatableTransform)contentModel;
        }
        return null;
    }

    public ContentGroup(LottieDrawable lottieDrawable, BaseLayer layer, ShapeGroup shapeGroup, LottieComposition composition) {
        this(lottieDrawable, layer, shapeGroup.getName(), shapeGroup.isHidden(), ContentGroup.contentsFromModels(lottieDrawable, composition, layer, shapeGroup.getItems()), ContentGroup.findTransform(shapeGroup.getItems()));
    }

    ContentGroup(LottieDrawable lottieDrawable, BaseLayer layer, String name, boolean hidden, List<Content> contents, @Nullable AnimatableTransform transform) {
        int i;
        this.name = name;
        this.lottieDrawable = lottieDrawable;
        this.hidden = hidden;
        this.contents = contents;
        if (transform != null) {
            this.transformAnimation = transform.createAnimation();
            this.transformAnimation.addAnimationsToLayer(layer);
            this.transformAnimation.addListener(this);
        }
        ArrayList<GreedyContent> greedyContents = new ArrayList<GreedyContent>();
        for (i = contents.size() - 1; i >= 0; --i) {
            Content content = contents.get(i);
            if (!(content instanceof GreedyContent)) continue;
            greedyContents.add((GreedyContent)((Object)content));
        }
        for (i = greedyContents.size() - 1; i >= 0; --i) {
            ((GreedyContent)greedyContents.get(i)).absorbContent(contents.listIterator(contents.size()));
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        ArrayList<Content> myContentsBefore = new ArrayList<Content>(contentsBefore.size() + this.contents.size());
        myContentsBefore.addAll(contentsBefore);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            content.setContents(myContentsBefore, this.contents.subList(0, i));
            myContentsBefore.add(content);
        }
    }

    public List<Content> getContents() {
        return this.contents;
    }

    List<PathContent> getPathList() {
        if (this.pathContents == null) {
            this.pathContents = new ArrayList<PathContent>();
            for (int i = 0; i < this.contents.size(); ++i) {
                Content content = this.contents.get(i);
                if (!(content instanceof PathContent)) continue;
                this.pathContents.add((PathContent)content);
            }
        }
        return this.pathContents;
    }

    Matrix getTransformationMatrix() {
        if (this.transformAnimation != null) {
            return this.transformAnimation.getMatrix();
        }
        this.matrix.reset();
        return this.matrix;
    }

    @Override
    public Path getPath() {
        this.matrix.reset();
        if (this.transformAnimation != null) {
            this.matrix.set(this.transformAnimation.getMatrix());
        }
        this.path.reset();
        if (this.hidden) {
            return this.path;
        }
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof PathContent)) continue;
            this.path.addPath(((PathContent)content).getPath(), this.matrix);
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha, @Nullable DropShadow shadowToApply) {
        int layerAlpha;
        if (this.hidden) {
            return;
        }
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
            int opacity = this.transformAnimation.getOpacity() == null ? 100 : this.transformAnimation.getOpacity().getValue();
            layerAlpha = (int)((float)opacity / 100.0f * (float)parentAlpha / 255.0f * 255.0f);
        } else {
            layerAlpha = parentAlpha;
        }
        boolean isRenderingWithOffScreen = this.lottieDrawable.isApplyingOpacityToLayersEnabled() && this.hasTwoOrMoreDrawableContent() && layerAlpha != 255 || shadowToApply != null && this.lottieDrawable.isApplyingShadowToLayersEnabled() && this.hasTwoOrMoreDrawableContent();
        int childAlpha = isRenderingWithOffScreen ? 255 : layerAlpha;
        Canvas contentCanvas = canvas;
        if (isRenderingWithOffScreen) {
            this.offScreenRectF.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.getBounds(this.offScreenRectF, parentMatrix, true);
            this.offscreenOp.alpha = layerAlpha;
            if (shadowToApply != null) {
                shadowToApply.applyTo(this.offscreenOp);
                shadowToApply = null;
            } else {
                this.offscreenOp.shadow = null;
            }
            contentCanvas = this.offscreenLayer.start(canvas, this.offScreenRectF, this.offscreenOp);
        } else if (shadowToApply != null) {
            shadowToApply = new DropShadow(shadowToApply);
            shadowToApply.multiplyOpacity(childAlpha);
        }
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).draw(contentCanvas, this.matrix, childAlpha, shadowToApply);
        }
        if (isRenderingWithOffScreen) {
            this.offscreenLayer.finish();
        }
    }

    private boolean hasTwoOrMoreDrawableContent() {
        int drawableContentCount = 0;
        for (int i = 0; i < this.contents.size(); ++i) {
            if (!(this.contents.get(i) instanceof DrawingContent) || ++drawableContentCount < 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
        }
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).getBounds(this.rect, this.matrix, applyParents);
            outBounds.union(this.rect);
        }
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        if (!keyPath.matches(this.getName(), depth) && !"__container".equals(this.getName())) {
            return;
        }
        if (!"__container".equals(this.getName())) {
            currentPartialKeyPath = currentPartialKeyPath.addKey(this.getName());
            if (keyPath.fullyResolvesTo(this.getName(), depth)) {
                accumulator.add(currentPartialKeyPath.resolve(this));
            }
        }
        if (keyPath.propagateToChildren(this.getName(), depth)) {
            int newDepth = depth + keyPath.incrementDepthBy(this.getName(), depth);
            for (int i = 0; i < this.contents.size(); ++i) {
                Content content = this.contents.get(i);
                if (!(content instanceof KeyPathElement)) continue;
                KeyPathElement element = (KeyPathElement)((Object)content);
                element.resolveKeyPath(keyPath, newDepth, accumulator, currentPartialKeyPath);
            }
        }
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (this.transformAnimation != null) {
            this.transformAnimation.applyValueCallback(property, callback);
        }
    }
}

