/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.core.graphics.BlendModeCompat;
import androidx.core.graphics.PaintCompat;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.utils.DropShadow;
import com.airbnb.lottie.utils.Utils;

public class OffscreenLayer {
    @Nullable
    private Canvas parentCanvas;
    @Nullable
    private ComposeOp op;
    private RenderStrategy currentStrategy;
    @Nullable
    private RectF targetRect;
    @Nullable
    private RectF rectIncludingShadow;
    @Nullable
    private Rect intRectIncludingShadow;
    @Nullable
    private RectF tmpRect;
    @Nullable
    private RectF scaledRectIncludingShadow;
    @Nullable
    private Rect shadowBitmapSrcRect;
    @Nullable
    private RectF scaledBounds;
    private static final Matrix IDENTITY_MATRIX = new Matrix();
    @Nullable
    private Paint composePaint;
    @Nullable
    private Bitmap bitmap;
    @Nullable
    private Canvas bitmapCanvas;
    @Nullable
    private Rect bitmapSrcRect;
    @Nullable
    private LPaint clearPaint;
    @Nullable
    Matrix parentCanvasMatrix;
    @Nullable
    float[] preExistingTransform;
    @Nullable
    private Bitmap shadowBitmap;
    @Nullable
    private Bitmap shadowMaskBitmap;
    @Nullable
    private Canvas shadowBitmapCanvas;
    @Nullable
    private Canvas shadowMaskBitmapCanvas;
    @Nullable
    private LPaint shadowPaint;
    @Nullable
    private BlurMaskFilter shadowBlurFilter;
    private float lastShadowBlurRadius = 0.0f;
    @Nullable
    private RenderNode renderNode;
    @Nullable
    private RenderNode shadowRenderNode;
    @Nullable
    private DropShadow lastRenderNodeShadow;

    private RenderStrategy chooseRenderStrategy(Canvas parentCanvas, ComposeOp op) {
        if (op.isNoop()) {
            return RenderStrategy.DIRECT;
        }
        if (!op.hasShadow()) {
            return RenderStrategy.SAVE_LAYER;
        }
        if (Build.VERSION.SDK_INT < 29 || !parentCanvas.isHardwareAccelerated()) {
            return RenderStrategy.BITMAP;
        }
        if (Build.VERSION.SDK_INT <= 31) {
            return RenderStrategy.BITMAP;
        }
        return RenderStrategy.RENDER_NODE;
    }

    private Bitmap allocateBitmap(RectF bounds, Bitmap.Config cfg) {
        int width = (int)Math.ceil((double)bounds.width() * 1.05);
        int height = (int)Math.ceil((double)bounds.height() * 1.05);
        return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)cfg);
    }

    private void deallocateBitmap(Bitmap bitmap) {
        bitmap.recycle();
    }

    private boolean needNewBitmap(@Nullable Bitmap bitmap, RectF bounds) {
        if (bitmap == null) {
            return true;
        }
        if (bounds.width() >= (float)bitmap.getWidth() || bounds.height() >= (float)bitmap.getHeight()) {
            return true;
        }
        return bounds.width() < (float)bitmap.getWidth() * 0.75f || bounds.height() < (float)bitmap.getHeight() * 0.75f;
    }

    public Canvas start(Canvas parentCanvas, RectF bounds, ComposeOp op) {
        Canvas childCanvas;
        if (this.parentCanvas != null) {
            throw new IllegalStateException("Cannot nest start() calls on a single OffscreenBitmap - call finish() first");
        }
        if (this.preExistingTransform == null) {
            this.preExistingTransform = new float[9];
        }
        if (this.parentCanvasMatrix == null) {
            this.parentCanvasMatrix = new Matrix();
        }
        parentCanvas.getMatrix(this.parentCanvasMatrix);
        this.parentCanvasMatrix.getValues(this.preExistingTransform);
        float pixelScaleX = this.preExistingTransform[0];
        float pixelScaleY = this.preExistingTransform[4];
        if (this.scaledBounds == null) {
            this.scaledBounds = new RectF();
        }
        this.scaledBounds.set(bounds.left * pixelScaleX, bounds.top * pixelScaleY, bounds.right * pixelScaleX, bounds.bottom * pixelScaleY);
        this.parentCanvas = parentCanvas;
        this.op = op;
        this.currentStrategy = this.chooseRenderStrategy(parentCanvas, op);
        if (this.targetRect == null) {
            this.targetRect = new RectF();
        }
        this.targetRect.set((float)((int)bounds.left), (float)((int)bounds.top), (float)((int)bounds.right), (float)((int)bounds.bottom));
        if (this.composePaint == null) {
            this.composePaint = new LPaint();
        }
        this.composePaint.reset();
        switch (this.currentStrategy.ordinal()) {
            case 0: {
                childCanvas = parentCanvas;
                childCanvas.save();
                break;
            }
            case 1: {
                this.composePaint.setAlpha(op.alpha);
                this.composePaint.setColorFilter(op.colorFilter);
                if (op.hasBlendMode()) {
                    PaintCompat.setBlendMode((Paint)this.composePaint, (BlendModeCompat)op.blendMode);
                }
                Utils.saveLayerCompat(parentCanvas, bounds, this.composePaint);
                childCanvas = parentCanvas;
                break;
            }
            case 2: {
                if (this.clearPaint == null) {
                    this.clearPaint = new LPaint();
                    this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
                }
                if (this.needNewBitmap(this.bitmap, this.scaledBounds)) {
                    if (this.bitmap != null) {
                        this.deallocateBitmap(this.bitmap);
                    }
                    this.bitmap = this.allocateBitmap(this.scaledBounds, Bitmap.Config.ARGB_8888);
                    this.bitmapCanvas = new Canvas(this.bitmap);
                } else {
                    if (this.bitmapCanvas == null) {
                        throw new IllegalStateException("If needNewBitmap() returns true, we should have a canvas ready");
                    }
                    this.bitmapCanvas.setMatrix(IDENTITY_MATRIX);
                    this.bitmapCanvas.drawRect(-1.0f, -1.0f, this.scaledBounds.width() + 1.0f, this.scaledBounds.height() + 1.0f, (Paint)this.clearPaint);
                }
                PaintCompat.setBlendMode((Paint)this.composePaint, (BlendModeCompat)op.blendMode);
                this.composePaint.setColorFilter(op.colorFilter);
                this.composePaint.setAlpha(op.alpha);
                childCanvas = this.bitmapCanvas;
                childCanvas.scale(pixelScaleX, pixelScaleY);
                childCanvas.translate(-bounds.left, -bounds.top);
                break;
            }
            case 3: {
                if (Build.VERSION.SDK_INT < 29) {
                    throw new IllegalStateException("RenderNode not supported but we chose it as render strategy");
                }
                if (this.renderNode == null) {
                    this.renderNode = new RenderNode("OffscreenLayer.main");
                }
                if (op.hasShadow() && this.shadowRenderNode == null) {
                    this.shadowRenderNode = new RenderNode("OffscreenLayer.shadow");
                    this.lastRenderNodeShadow = null;
                }
                if (op.hasBlendMode() || op.hasColorFilter()) {
                    if (this.composePaint == null) {
                        this.composePaint = new LPaint();
                    }
                    this.composePaint.reset();
                    PaintCompat.setBlendMode((Paint)this.composePaint, (BlendModeCompat)op.blendMode);
                    this.composePaint.setColorFilter(op.colorFilter);
                    this.renderNode.setUseCompositingLayer(true, this.composePaint);
                    if (op.hasShadow()) {
                        if (this.shadowRenderNode == null) {
                            throw new IllegalStateException("Must initialize shadowRenderNode when we have shadow");
                        }
                        this.shadowRenderNode.setUseCompositingLayer(true, this.composePaint);
                    }
                }
                this.renderNode.setAlpha((float)op.alpha / 255.0f);
                if (op.hasShadow()) {
                    if (this.shadowRenderNode == null) {
                        throw new IllegalStateException("Must initialize shadowRenderNode when we have shadow");
                    }
                    this.shadowRenderNode.setAlpha((float)op.alpha / 255.0f);
                }
                this.renderNode.setHasOverlappingRendering(true);
                this.renderNode.setPosition((int)this.scaledBounds.left, (int)this.scaledBounds.top, (int)this.scaledBounds.right, (int)this.scaledBounds.bottom);
                childCanvas = this.renderNode.beginRecording((int)this.scaledBounds.width(), (int)this.scaledBounds.height());
                childCanvas.setMatrix(IDENTITY_MATRIX);
                childCanvas.scale(pixelScaleX, pixelScaleY);
                childCanvas.translate(-bounds.left, -bounds.top);
                break;
            }
            default: {
                throw new RuntimeException("Invalid render strategy for OffscreenLayer");
            }
        }
        return childCanvas;
    }

    public void finish() {
        if (this.parentCanvas == null || this.op == null || this.preExistingTransform == null || this.targetRect == null) {
            throw new IllegalStateException("OffscreenBitmap: finish() call without matching start()");
        }
        switch (this.currentStrategy.ordinal()) {
            case 0: {
                this.parentCanvas.restore();
                break;
            }
            case 1: {
                this.parentCanvas.restore();
                break;
            }
            case 2: {
                if (this.bitmap == null) {
                    throw new IllegalStateException("Bitmap is not ready; should've been initialized at start() time");
                }
                if (this.op.hasShadow()) {
                    this.renderBitmapShadow(this.parentCanvas, this.op.shadow);
                }
                if (this.bitmapSrcRect == null) {
                    this.bitmapSrcRect = new Rect();
                }
                this.bitmapSrcRect.set(0, 0, (int)(this.targetRect.width() * this.preExistingTransform[0]), (int)(this.targetRect.height() * this.preExistingTransform[4]));
                this.parentCanvas.drawBitmap(this.bitmap, this.bitmapSrcRect, this.targetRect, this.composePaint);
                break;
            }
            case 3: {
                if (this.renderNode == null) {
                    throw new IllegalStateException("RenderNode is not ready; should've been initialized at start() time");
                }
                if (Build.VERSION.SDK_INT < 29) {
                    throw new IllegalStateException("RenderNode not supported but we chose it as render strategy");
                }
                this.parentCanvas.save();
                this.parentCanvas.scale(1.0f / this.preExistingTransform[0], 1.0f / this.preExistingTransform[4]);
                this.renderNode.endRecording();
                if (this.op.hasShadow()) {
                    this.renderHardwareShadow(this.parentCanvas, this.op.shadow);
                }
                this.parentCanvas.drawRenderNode(this.renderNode);
                this.parentCanvas.restore();
            }
        }
        this.parentCanvas = null;
    }

    private RectF calculateRectIncludingShadow(RectF rect, DropShadow shadow) {
        if (this.rectIncludingShadow == null) {
            this.rectIncludingShadow = new RectF();
        }
        if (this.tmpRect == null) {
            this.tmpRect = new RectF();
        }
        this.rectIncludingShadow.set(rect);
        this.rectIncludingShadow.offsetTo(rect.left + shadow.getDx(), rect.top + shadow.getDy());
        this.rectIncludingShadow.inset(-shadow.getRadius(), -shadow.getRadius());
        this.tmpRect.set(rect);
        this.rectIncludingShadow.union(this.tmpRect);
        return this.rectIncludingShadow;
    }

    private void renderBitmapShadow(Canvas targetCanvas, DropShadow shadow) {
        float pixelScaleY;
        if (this.targetRect == null || this.bitmap == null) {
            throw new IllegalStateException("Cannot render to bitmap outside a start()/finish() block");
        }
        RectF rectIncludingShadow = this.calculateRectIncludingShadow(this.targetRect, shadow);
        if (this.intRectIncludingShadow == null) {
            this.intRectIncludingShadow = new Rect();
        }
        this.intRectIncludingShadow.set((int)Math.floor(rectIncludingShadow.left), (int)Math.floor(rectIncludingShadow.top), (int)Math.ceil(rectIncludingShadow.right), (int)Math.ceil(rectIncludingShadow.bottom));
        float pixelScaleX = this.preExistingTransform != null ? this.preExistingTransform[0] : 1.0f;
        float f = pixelScaleY = this.preExistingTransform != null ? this.preExistingTransform[4] : 1.0f;
        if (this.scaledRectIncludingShadow == null) {
            this.scaledRectIncludingShadow = new RectF();
        }
        this.scaledRectIncludingShadow.set(rectIncludingShadow.left * pixelScaleX, rectIncludingShadow.top * pixelScaleY, rectIncludingShadow.right * pixelScaleX, rectIncludingShadow.bottom * pixelScaleY);
        if (this.shadowBitmapSrcRect == null) {
            this.shadowBitmapSrcRect = new Rect();
        }
        this.shadowBitmapSrcRect.set(0, 0, Math.round(this.scaledRectIncludingShadow.width()), Math.round(this.scaledRectIncludingShadow.height()));
        if (this.needNewBitmap(this.shadowBitmap, this.scaledRectIncludingShadow)) {
            if (this.shadowBitmap != null) {
                this.deallocateBitmap(this.shadowBitmap);
            }
            if (this.shadowMaskBitmap != null) {
                this.deallocateBitmap(this.shadowMaskBitmap);
            }
            this.shadowBitmap = this.allocateBitmap(this.scaledRectIncludingShadow, Bitmap.Config.ARGB_8888);
            this.shadowMaskBitmap = this.allocateBitmap(this.scaledRectIncludingShadow, Bitmap.Config.ALPHA_8);
            this.shadowBitmapCanvas = new Canvas(this.shadowBitmap);
            this.shadowMaskBitmapCanvas = new Canvas(this.shadowMaskBitmap);
        } else {
            if (this.shadowBitmapCanvas == null || this.shadowMaskBitmapCanvas == null || this.clearPaint == null) {
                throw new IllegalStateException("If needNewBitmap() returns true, we should have a canvas and bitmap ready");
            }
            this.shadowBitmapCanvas.drawRect(this.shadowBitmapSrcRect, (Paint)this.clearPaint);
            this.shadowMaskBitmapCanvas.drawRect(this.shadowBitmapSrcRect, (Paint)this.clearPaint);
        }
        if (this.shadowMaskBitmap == null) {
            throw new IllegalStateException("Expected to have allocated a shadow mask bitmap");
        }
        if (this.shadowPaint == null) {
            this.shadowPaint = new LPaint(1);
        }
        float offsetX = this.targetRect.left - rectIncludingShadow.left;
        float offsetY = this.targetRect.top - rectIncludingShadow.top;
        this.shadowMaskBitmapCanvas.drawBitmap(this.bitmap, (float)Math.round(offsetX * pixelScaleX), (float)Math.round(offsetY * pixelScaleY), null);
        if (this.shadowBlurFilter == null || this.lastShadowBlurRadius != shadow.getRadius()) {
            float scaledRadius = shadow.getRadius() * (pixelScaleX + pixelScaleY) / 2.0f;
            this.shadowBlurFilter = scaledRadius > 0.0f ? new BlurMaskFilter(scaledRadius, BlurMaskFilter.Blur.NORMAL) : null;
            this.lastShadowBlurRadius = shadow.getRadius();
        }
        this.shadowPaint.setColor(shadow.getColor());
        if (shadow.getRadius() > 0.0f) {
            this.shadowPaint.setMaskFilter((MaskFilter)this.shadowBlurFilter);
        } else {
            this.shadowPaint.setMaskFilter(null);
        }
        this.shadowPaint.setFilterBitmap(true);
        this.shadowBitmapCanvas.drawBitmap(this.shadowMaskBitmap, (float)Math.round(shadow.getDx() * pixelScaleX), (float)Math.round(shadow.getDy() * pixelScaleY), (Paint)this.shadowPaint);
        targetCanvas.drawBitmap(this.shadowBitmap, this.shadowBitmapSrcRect, this.intRectIncludingShadow, this.composePaint);
    }

    private void renderHardwareShadow(Canvas targetCanvas, DropShadow shadow) {
        float pixelScaleY;
        if (this.renderNode == null || this.shadowRenderNode == null) {
            throw new IllegalStateException("Cannot render to render node outside a start()/finish() block");
        }
        if (Build.VERSION.SDK_INT < 31) {
            throw new RuntimeException("RenderEffect is not supported on API level <31");
        }
        float pixelScaleX = this.preExistingTransform != null ? this.preExistingTransform[0] : 1.0f;
        float f = pixelScaleY = this.preExistingTransform != null ? this.preExistingTransform[4] : 1.0f;
        if (this.lastRenderNodeShadow == null || !shadow.sameAs(this.lastRenderNodeShadow)) {
            RenderEffect effect = RenderEffect.createColorFilterEffect((ColorFilter)new PorterDuffColorFilter(shadow.getColor(), PorterDuff.Mode.SRC_IN));
            if (shadow.getRadius() > 0.0f) {
                float scaledRadius = shadow.getRadius() * (pixelScaleX + pixelScaleY) / 2.0f;
                effect = RenderEffect.createBlurEffect((float)scaledRadius, (float)scaledRadius, (RenderEffect)effect, (Shader.TileMode)Shader.TileMode.CLAMP);
            }
            this.shadowRenderNode.setRenderEffect(effect);
            this.lastRenderNodeShadow = shadow;
        }
        RectF rectIncludingShadow = this.calculateRectIncludingShadow(this.targetRect, shadow);
        RectF scaledRectIncludingShadow = new RectF(rectIncludingShadow.left * pixelScaleX, rectIncludingShadow.top * pixelScaleY, rectIncludingShadow.right * pixelScaleX, rectIncludingShadow.bottom * pixelScaleY);
        this.shadowRenderNode.setPosition(0, 0, (int)scaledRectIncludingShadow.width(), (int)scaledRectIncludingShadow.height());
        RecordingCanvas shadowCanvas = this.shadowRenderNode.beginRecording((int)scaledRectIncludingShadow.width(), (int)scaledRectIncludingShadow.height());
        shadowCanvas.translate(-scaledRectIncludingShadow.left + shadow.getDx() * pixelScaleX, -scaledRectIncludingShadow.top + shadow.getDy() * pixelScaleY);
        shadowCanvas.drawRenderNode(this.renderNode);
        this.shadowRenderNode.endRecording();
        targetCanvas.save();
        targetCanvas.translate(scaledRectIncludingShadow.left, scaledRectIncludingShadow.top);
        targetCanvas.drawRenderNode(this.shadowRenderNode);
        targetCanvas.restore();
    }

    public static class ComposeOp {
        public int alpha;
        @Nullable
        public BlendModeCompat blendMode;
        @Nullable
        public ColorFilter colorFilter;
        @Nullable
        public DropShadow shadow;

        public ComposeOp() {
            this.reset();
        }

        public boolean isTranslucent() {
            return this.alpha < 255;
        }

        public boolean hasBlendMode() {
            return this.blendMode != null && this.blendMode != BlendModeCompat.SRC_OVER;
        }

        public boolean hasShadow() {
            return this.shadow != null;
        }

        public boolean hasColorFilter() {
            return this.colorFilter != null;
        }

        public boolean isNoop() {
            return !this.isTranslucent() && !this.hasBlendMode() && !this.hasShadow() && !this.hasColorFilter();
        }

        public void reset() {
            this.alpha = 255;
            this.blendMode = null;
            this.colorFilter = null;
            this.shadow = null;
        }
    }

    protected static enum RenderStrategy {
        DIRECT,
        SAVE_LAYER,
        BITMAP,
        RENDER_NODE;

    }
}

