/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import androidx.annotation.Nullable;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.parser.DropShadowEffect;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;

public class DropShadowKeyframeAnimation
implements BaseKeyframeAnimation.AnimationListener {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float AFTER_EFFECT_SOFTNESS_SCALE_FACTOR = 0.33f;
    private final BaseLayer layer;
    private final BaseKeyframeAnimation.AnimationListener listener;
    private final BaseKeyframeAnimation<Integer, Integer> color;
    private final FloatKeyframeAnimation opacity;
    private final FloatKeyframeAnimation direction;
    private final FloatKeyframeAnimation distance;
    private final FloatKeyframeAnimation radius;
    private float paintRadius = Float.NaN;
    private float paintX = Float.NaN;
    private float paintY = Float.NaN;
    private int paintColor = 0;
    private final float[] matrixValues = new float[9];

    public DropShadowKeyframeAnimation(BaseKeyframeAnimation.AnimationListener listener, BaseLayer layer, DropShadowEffect dropShadowEffect) {
        this.listener = listener;
        this.layer = layer;
        this.color = dropShadowEffect.getColor().createAnimation();
        this.color.addUpdateListener(this);
        layer.addAnimation(this.color);
        this.opacity = dropShadowEffect.getOpacity().createAnimation();
        this.opacity.addUpdateListener(this);
        layer.addAnimation(this.opacity);
        this.direction = dropShadowEffect.getDirection().createAnimation();
        this.direction.addUpdateListener(this);
        layer.addAnimation(this.direction);
        this.distance = dropShadowEffect.getDistance().createAnimation();
        this.distance.addUpdateListener(this);
        layer.addAnimation(this.distance);
        this.radius = dropShadowEffect.getRadius().createAnimation();
        this.radius.addUpdateListener(this);
        layer.addAnimation(this.radius);
    }

    @Override
    public void onValueChanged() {
        this.listener.onValueChanged();
    }

    public void applyTo(Paint paint, Matrix parentMatrix, int parentAlpha) {
        float directionRad = this.direction.getFloatValue() * ((float)Math.PI / 180);
        float distance = ((Float)this.distance.getValue()).floatValue();
        float rawX = (float)Math.sin(directionRad) * distance;
        float rawY = (float)Math.cos((double)directionRad + Math.PI) * distance;
        this.layer.transform.getMatrix().getValues(this.matrixValues);
        float layerScaleX = this.matrixValues[0];
        float layerScaleY = this.matrixValues[4];
        parentMatrix.getValues(this.matrixValues);
        float parentScaleX = this.matrixValues[0];
        float parentScaleY = this.matrixValues[4];
        float scaleX = parentScaleX / layerScaleX;
        float scaleY = parentScaleY / layerScaleY;
        float x = rawX * scaleX;
        float y = rawY * scaleY;
        int baseColor = this.color.getValue();
        int opacity = Math.round(((Float)this.opacity.getValue()).floatValue() * (float)parentAlpha / 255.0f);
        int color = Color.argb((int)opacity, (int)Color.red((int)baseColor), (int)Color.green((int)baseColor), (int)Color.blue((int)baseColor));
        float radius = Math.max(((Float)this.radius.getValue()).floatValue() * scaleX * 0.33f, Float.MIN_VALUE);
        if (this.paintRadius == radius && this.paintX == x && this.paintY == y && this.paintColor == color) {
            return;
        }
        this.paintRadius = radius;
        this.paintX = x;
        this.paintY = y;
        this.paintColor = color;
        paint.setShadowLayer(radius, x, y, color);
    }

    public void setColorCallback(@Nullable LottieValueCallback<Integer> callback) {
        this.color.setValueCallback(callback);
    }

    public void setOpacityCallback(final @Nullable LottieValueCallback<Float> callback) {
        if (callback == null) {
            this.opacity.setValueCallback(null);
            return;
        }
        this.opacity.setValueCallback(new LottieValueCallback<Float>(){

            @Override
            @Nullable
            public Float getValue(LottieFrameInfo<Float> frameInfo) {
                Float value = callback.getValue(frameInfo);
                if (value == null) {
                    return null;
                }
                return Float.valueOf(value.floatValue() * 2.55f);
            }
        });
    }

    public void setDirectionCallback(@Nullable LottieValueCallback<Float> callback) {
        this.direction.setValueCallback(callback);
    }

    public void setDistanceCallback(@Nullable LottieValueCallback<Float> callback) {
        this.distance.setValueCallback(callback);
    }

    public void setRadiusCallback(@Nullable LottieValueCallback<Float> callback) {
        this.radius.setValueCallback(callback);
    }
}

