/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.content.BaseStrokeContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.content.GradientColor;
import com.airbnb.lottie.model.content.GradientStroke;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.value.LottieValueCallback;

public class GradientStrokeContent
extends BaseStrokeContent {
    private static final int CACHE_STEPS_MS = 32;
    private final String name;
    private final boolean hidden;
    private final LongSparseArray<LinearGradient> linearGradientCache = new LongSparseArray();
    private final LongSparseArray<RadialGradient> radialGradientCache = new LongSparseArray();
    private final RectF boundsRect = new RectF();
    private final GradientType type;
    private final int cacheSteps;
    private final BaseKeyframeAnimation<GradientColor, GradientColor> colorAnimation;
    private final BaseKeyframeAnimation<PointF, PointF> startPointAnimation;
    private final BaseKeyframeAnimation<PointF, PointF> endPointAnimation;
    @Nullable
    private ValueCallbackKeyframeAnimation colorCallbackAnimation;

    public GradientStrokeContent(LottieDrawable lottieDrawable, BaseLayer layer, GradientStroke stroke) {
        super(lottieDrawable, layer, stroke.getCapType().toPaintCap(), stroke.getJoinType().toPaintJoin(), stroke.getMiterLimit(), stroke.getOpacity(), stroke.getWidth(), stroke.getLineDashPattern(), stroke.getDashOffset());
        this.name = stroke.getName();
        this.type = stroke.getGradientType();
        this.hidden = stroke.isHidden();
        this.cacheSteps = (int)(lottieDrawable.getComposition().getDuration() / 32.0f);
        this.colorAnimation = stroke.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        layer.addAnimation(this.colorAnimation);
        this.startPointAnimation = stroke.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = stroke.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.endPointAnimation);
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        if (this.hidden) {
            return;
        }
        this.getBounds(this.boundsRect, parentMatrix, false);
        Object shader = this.type == GradientType.LINEAR ? this.getLinearGradient() : this.getRadialGradient();
        this.paint.setShader((Shader)shader);
        super.draw(canvas, parentMatrix, parentAlpha);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private LinearGradient getLinearGradient() {
        int gradientHash = this.getGradientHash();
        LinearGradient gradient = (LinearGradient)this.linearGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = this.startPointAnimation.getValue();
        PointF endPoint = this.endPointAnimation.getValue();
        GradientColor gradientColor = this.colorAnimation.getValue();
        int[] colors = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] positions = gradientColor.getPositions();
        float x0 = startPoint.x;
        float y0 = startPoint.y;
        float x1 = endPoint.x;
        float y1 = endPoint.y;
        gradient = new LinearGradient(x0, y0, x1, y1, colors, positions, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private RadialGradient getRadialGradient() {
        int gradientHash = this.getGradientHash();
        RadialGradient gradient = (RadialGradient)this.radialGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = this.startPointAnimation.getValue();
        PointF endPoint = this.endPointAnimation.getValue();
        GradientColor gradientColor = this.colorAnimation.getValue();
        int[] colors = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] positions = gradientColor.getPositions();
        float x0 = startPoint.x;
        float y0 = startPoint.y;
        float x1 = endPoint.x;
        float y1 = endPoint.y;
        float r = (float)Math.hypot(x1 - x0, y1 - y0);
        gradient = new RadialGradient(x0, y0, r, colors, positions, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private int getGradientHash() {
        int startPointProgress = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int endPointProgress = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int colorProgress = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int hash = 17;
        if (startPointProgress != 0) {
            hash = hash * 31 * startPointProgress;
        }
        if (endPointProgress != 0) {
            hash = hash * 31 * endPointProgress;
        }
        if (colorProgress != 0) {
            hash = hash * 31 * colorProgress;
        }
        return hash;
    }

    private int[] applyDynamicColorsIfNeeded(int[] colors) {
        block4: {
            if (this.colorCallbackAnimation == null) break block4;
            Integer[] dynamicColors = (Integer[])this.colorCallbackAnimation.getValue();
            if (colors.length == dynamicColors.length) {
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = dynamicColors[i];
                }
            } else {
                colors = new int[dynamicColors.length];
                for (int i = 0; i < dynamicColors.length; ++i) {
                    colors[i] = dynamicColors[i];
                }
            }
        }
        return colors;
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.GRADIENT_COLOR) {
            if (this.colorCallbackAnimation != null) {
                this.layer.removeAnimation(this.colorCallbackAnimation);
            }
            if (callback == null) {
                this.colorCallbackAnimation = null;
            } else {
                this.colorCallbackAnimation = new ValueCallbackKeyframeAnimation(callback);
                this.colorCallbackAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorCallbackAnimation);
            }
        }
    }
}

