/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.airbnb.lottie.network.FileExtension;
import com.airbnb.lottie.network.LottieNetworkCacheProvider;
import com.airbnb.lottie.utils.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkCache {
    @NonNull
    private final LottieNetworkCacheProvider cacheProvider;

    public NetworkCache(@NonNull LottieNetworkCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void clear() {
        File parentDir = this.parentDir();
        if (parentDir.exists()) {
            File[] files = parentDir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    file.delete();
                }
            }
            parentDir.delete();
        }
    }

    @Nullable
    @WorkerThread
    Pair<FileExtension, InputStream> fetch(String url) {
        FileInputStream inputStream;
        File cachedFile;
        try {
            cachedFile = this.getCachedFile(url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (cachedFile == null) {
            return null;
        }
        try {
            inputStream = new FileInputStream(cachedFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        FileExtension extension = cachedFile.getAbsolutePath().endsWith(".zip") ? FileExtension.ZIP : (cachedFile.getAbsolutePath().endsWith(".gz") ? FileExtension.GZIP : FileExtension.JSON);
        Logger.debug("Cache hit for " + url + " at " + cachedFile.getAbsolutePath());
        return new Pair((Object)extension, (Object)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File writeTempCacheFile(String url, InputStream stream, FileExtension extension) throws IOException {
        String fileName = NetworkCache.filenameForUrl(url, extension, true);
        File file = new File(this.parentDir(), fileName);
        try (FileOutputStream output = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, read);
            }
            output.flush();
        }
        finally {
            stream.close();
        }
        return file;
    }

    void renameTempFile(String url, FileExtension extension) {
        String fileName = NetworkCache.filenameForUrl(url, extension, true);
        File file = new File(this.parentDir(), fileName);
        String newFileName = file.getAbsolutePath().replace(".temp", "");
        File newFile = new File(newFileName);
        boolean renamed = file.renameTo(newFile);
        Logger.debug("Copying temp file to real file (" + newFile + ")");
        if (!renamed) {
            Logger.warning("Unable to rename cache file " + file.getAbsolutePath() + " to " + newFile.getAbsolutePath() + ".");
        }
    }

    @Nullable
    private File getCachedFile(String url) throws FileNotFoundException {
        File jsonFile = new File(this.parentDir(), NetworkCache.filenameForUrl(url, FileExtension.JSON, false));
        if (jsonFile.exists()) {
            return jsonFile;
        }
        File zipFile = new File(this.parentDir(), NetworkCache.filenameForUrl(url, FileExtension.ZIP, false));
        if (zipFile.exists()) {
            return zipFile;
        }
        File gzipFile = new File(this.parentDir(), NetworkCache.filenameForUrl(url, FileExtension.GZIP, false));
        if (gzipFile.exists()) {
            return gzipFile;
        }
        return null;
    }

    private File parentDir() {
        File file = this.cacheProvider.getCacheDir();
        if (file.isFile()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static String filenameForUrl(String url, FileExtension extension, boolean isTemp) {
        String prefix = "lottie_cache_";
        String suffix = isTemp ? extension.tempExtension() : extension.extension;
        String sanitizedUrl = url.replaceAll("\\W+", "");
        int maxUrlLength = 255 - prefix.length() - suffix.length();
        if (sanitizedUrl.length() > maxUrlLength) {
            sanitizedUrl = NetworkCache.getMD5(sanitizedUrl, maxUrlLength);
        }
        return prefix + sanitizedUrl + suffix;
    }

    private static String getMD5(String input, int maxLength) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return input.substring(0, maxLength);
        }
        byte[] messageDigest = md.digest(input.getBytes());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            byte b = messageDigest[i];
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

