/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import com.airbnb.lottie.animation.keyframe.KeyframeAnimation;
import com.airbnb.lottie.model.content.GradientColor;
import com.airbnb.lottie.value.Keyframe;
import java.util.List;

public class GradientColorKeyframeAnimation
extends KeyframeAnimation<GradientColor> {
    private final GradientColor gradientColor;

    public GradientColorKeyframeAnimation(List<Keyframe<GradientColor>> keyframes) {
        super(keyframes);
        int size = 0;
        for (int i = 0; i < keyframes.size(); ++i) {
            GradientColor startValue = (GradientColor)keyframes.get((int)i).startValue;
            if (startValue == null) continue;
            size = Math.max(size, startValue.getSize());
        }
        this.gradientColor = new GradientColor(new float[size], new int[size]);
    }

    @Override
    GradientColor getValue(Keyframe<GradientColor> keyframe, float keyframeProgress) {
        this.gradientColor.lerp((GradientColor)keyframe.startValue, (GradientColor)keyframe.endValue, keyframeProgress);
        return this.gradientColor;
    }
}

