/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Path;
import androidx.annotation.Nullable;
import com.airbnb.lottie.animation.content.ShapeModifierContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.model.content.ShapeData;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.Keyframe;
import java.util.List;

public class ShapeKeyframeAnimation
extends BaseKeyframeAnimation<ShapeData, Path> {
    private final ShapeData tempShapeData = new ShapeData();
    private final Path tempPath = new Path();
    private Path valueCallbackStartPath;
    private Path valueCallbackEndPath;
    private List<ShapeModifierContent> shapeModifiers;

    public ShapeKeyframeAnimation(List<Keyframe<ShapeData>> keyframes) {
        super(keyframes);
    }

    @Override
    public Path getValue(Keyframe<ShapeData> keyframe, float keyframeProgress) {
        ShapeData startShapeData = (ShapeData)keyframe.startValue;
        ShapeData endShapeData = (ShapeData)keyframe.endValue;
        this.tempShapeData.interpolateBetween(startShapeData, endShapeData == null ? startShapeData : endShapeData, keyframeProgress);
        ShapeData modifiedShapeData = this.tempShapeData;
        if (this.shapeModifiers != null) {
            for (int i = this.shapeModifiers.size() - 1; i >= 0; --i) {
                modifiedShapeData = this.shapeModifiers.get(i).modifyShape(modifiedShapeData);
            }
        }
        MiscUtils.getPathFromData(modifiedShapeData, this.tempPath);
        if (this.valueCallback != null) {
            if (this.valueCallbackStartPath == null) {
                this.valueCallbackStartPath = new Path();
                this.valueCallbackEndPath = new Path();
            }
            MiscUtils.getPathFromData(startShapeData, this.valueCallbackStartPath);
            if (endShapeData != null) {
                MiscUtils.getPathFromData(endShapeData, this.valueCallbackEndPath);
            }
            return this.valueCallback.getValueInternal(keyframe.startFrame, keyframe.endFrame.floatValue(), this.valueCallbackStartPath, endShapeData == null ? this.valueCallbackStartPath : this.valueCallbackEndPath, keyframeProgress, this.getLinearCurrentKeyframeProgress(), this.getProgress());
        }
        return this.tempPath;
    }

    public void setShapeModifiers(@Nullable List<ShapeModifierContent> shapeModifiers) {
        this.shapeModifiers = shapeModifiers;
    }
}

