/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.airbnb.lottie.LottieListener;
import com.airbnb.lottie.LottieResult;
import com.airbnb.lottie.utils.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class LottieTask<T> {
    public static Executor EXECUTOR = Executors.newCachedThreadPool();
    private final Set<LottieListener<T>> successListeners = new LinkedHashSet<LottieListener<T>>(1);
    private final Set<LottieListener<Throwable>> failureListeners = new LinkedHashSet<LottieListener<Throwable>>(1);
    private final Handler handler = new Handler(Looper.getMainLooper());
    @Nullable
    private volatile LottieResult<T> result = null;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public LottieTask(Callable<LottieResult<T>> runnable) {
        this(runnable, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    LottieTask(Callable<LottieResult<T>> runnable, boolean runNow) {
        if (runNow) {
            try {
                this.setResult(runnable.call());
            }
            catch (Throwable e) {
                this.setResult(new LottieResult(e));
            }
        } else {
            EXECUTOR.execute(new LottieFutureTask(runnable));
        }
    }

    private void setResult(@Nullable LottieResult<T> result) {
        if (this.result != null) {
            throw new IllegalStateException("A task may only be set once.");
        }
        this.result = result;
        this.notifyListeners();
    }

    public synchronized LottieTask<T> addListener(LottieListener<T> listener) {
        LottieResult<T> result = this.result;
        if (result != null && result.getValue() != null) {
            listener.onResult(result.getValue());
        }
        this.successListeners.add(listener);
        return this;
    }

    public synchronized LottieTask<T> removeListener(LottieListener<T> listener) {
        this.successListeners.remove(listener);
        return this;
    }

    public synchronized LottieTask<T> addFailureListener(LottieListener<Throwable> listener) {
        LottieResult<T> result = this.result;
        if (result != null && result.getException() != null) {
            listener.onResult(result.getException());
        }
        this.failureListeners.add(listener);
        return this;
    }

    public synchronized LottieTask<T> removeFailureListener(LottieListener<Throwable> listener) {
        this.failureListeners.remove(listener);
        return this;
    }

    private void notifyListeners() {
        this.handler.post(() -> {
            LottieResult<T> result = this.result;
            if (result == null) {
                return;
            }
            if (result.getValue() != null) {
                this.notifySuccessListeners(result.getValue());
            } else {
                this.notifyFailureListeners(result.getException());
            }
        });
    }

    private synchronized void notifySuccessListeners(T value) {
        ArrayList<LottieListener<T>> listenersCopy = new ArrayList<LottieListener<T>>(this.successListeners);
        for (LottieListener lottieListener : listenersCopy) {
            lottieListener.onResult(value);
        }
    }

    private synchronized void notifyFailureListeners(Throwable e) {
        ArrayList<LottieListener<Throwable>> listenersCopy = new ArrayList<LottieListener<Throwable>>(this.failureListeners);
        if (listenersCopy.isEmpty()) {
            Logger.warning("Lottie encountered an error but no failure listener was added:", e);
            return;
        }
        for (LottieListener lottieListener : listenersCopy) {
            lottieListener.onResult(e);
        }
    }

    private class LottieFutureTask
    extends FutureTask<LottieResult<T>> {
        LottieFutureTask(Callable<LottieResult<T>> callable) {
            super(callable);
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                LottieTask.this.setResult((LottieResult)this.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LottieTask.this.setResult(new LottieResult(e));
            }
        }
    }
}

