/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.content.KeyPathElementContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.DropShadowKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.content.GradientColor;
import com.airbnb.lottie.model.content.GradientFill;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public class GradientFillContent
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener,
KeyPathElementContent {
    private static final int CACHE_STEPS_MS = 32;
    @NonNull
    private final String name;
    private final boolean hidden;
    private final BaseLayer layer;
    private final LongSparseArray<LinearGradient> linearGradientCache = new LongSparseArray();
    private final LongSparseArray<RadialGradient> radialGradientCache = new LongSparseArray();
    private final Path path = new Path();
    private final Paint paint = new LPaint(1);
    private final RectF boundsRect = new RectF();
    private final List<PathContent> paths = new ArrayList<PathContent>();
    private final GradientType type;
    private final BaseKeyframeAnimation<GradientColor, GradientColor> colorAnimation;
    private final BaseKeyframeAnimation<Integer, Integer> opacityAnimation;
    private final BaseKeyframeAnimation<PointF, PointF> startPointAnimation;
    private final BaseKeyframeAnimation<PointF, PointF> endPointAnimation;
    @Nullable
    private BaseKeyframeAnimation<ColorFilter, ColorFilter> colorFilterAnimation;
    @Nullable
    private ValueCallbackKeyframeAnimation colorCallbackAnimation;
    private final LottieDrawable lottieDrawable;
    private final int cacheSteps;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> blurAnimation;
    float blurMaskFilterRadius = 0.0f;
    @Nullable
    private DropShadowKeyframeAnimation dropShadowAnimation;

    public GradientFillContent(LottieDrawable lottieDrawable, LottieComposition composition, BaseLayer layer, GradientFill fill) {
        this.layer = layer;
        this.name = fill.getName();
        this.hidden = fill.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.type = fill.getGradientType();
        this.path.setFillType(fill.getFillType());
        this.cacheSteps = (int)(composition.getDuration() / 32.0f);
        this.colorAnimation = fill.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        layer.addAnimation(this.colorAnimation);
        this.opacityAnimation = fill.getOpacity().createAnimation();
        this.opacityAnimation.addUpdateListener(this);
        layer.addAnimation(this.opacityAnimation);
        this.startPointAnimation = fill.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = fill.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.endPointAnimation);
        if (layer.getBlurEffect() != null) {
            this.blurAnimation = layer.getBlurEffect().getBlurriness().createAnimation();
            this.blurAnimation.addUpdateListener(this);
            layer.addAnimation(this.blurAnimation);
        }
        if (layer.getDropShadowEffect() != null) {
            this.dropShadowAnimation = new DropShadowKeyframeAnimation(this, layer, layer.getDropShadowEffect());
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsAfter.size(); ++i) {
            Content content = contentsAfter.get(i);
            if (!(content instanceof PathContent)) continue;
            this.paths.add((PathContent)content);
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        if (this.hidden) {
            return;
        }
        L.beginSection("GradientFillContent#draw");
        this.path.reset();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.path.addPath(this.paths.get(i).getPath(), parentMatrix);
        }
        this.path.computeBounds(this.boundsRect, false);
        Object shader = this.type == GradientType.LINEAR ? this.getLinearGradient() : this.getRadialGradient();
        shader.setLocalMatrix(parentMatrix);
        this.paint.setShader((Shader)shader);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter(this.colorFilterAnimation.getValue());
        }
        if (this.blurAnimation != null) {
            float blurRadius = this.blurAnimation.getValue().floatValue();
            if (blurRadius == 0.0f) {
                this.paint.setMaskFilter(null);
            } else if (blurRadius != this.blurMaskFilterRadius) {
                BlurMaskFilter blur = new BlurMaskFilter(blurRadius, BlurMaskFilter.Blur.NORMAL);
                this.paint.setMaskFilter((MaskFilter)blur);
            }
            this.blurMaskFilterRadius = blurRadius;
        }
        if (this.dropShadowAnimation != null) {
            this.dropShadowAnimation.applyTo(this.paint);
        }
        int alpha = (int)((float)parentAlpha / 255.0f * (float)this.opacityAnimation.getValue().intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(MiscUtils.clamp(alpha, 0, 255));
        canvas.drawPath(this.path, this.paint);
        L.endSection("GradientFillContent#draw");
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        this.path.reset();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.path.addPath(this.paths.get(i).getPath(), parentMatrix);
        }
        this.path.computeBounds(outBounds, false);
        outBounds.set(outBounds.left - 1.0f, outBounds.top - 1.0f, outBounds.right + 1.0f, outBounds.bottom + 1.0f);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private LinearGradient getLinearGradient() {
        int gradientHash = this.getGradientHash();
        LinearGradient gradient = (LinearGradient)this.linearGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = this.startPointAnimation.getValue();
        PointF endPoint = this.endPointAnimation.getValue();
        GradientColor gradientColor = this.colorAnimation.getValue();
        int[] colors = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] positions = gradientColor.getPositions();
        gradient = new LinearGradient(startPoint.x, startPoint.y, endPoint.x, endPoint.y, colors, positions, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private RadialGradient getRadialGradient() {
        int gradientHash = this.getGradientHash();
        RadialGradient gradient = (RadialGradient)this.radialGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = this.startPointAnimation.getValue();
        PointF endPoint = this.endPointAnimation.getValue();
        GradientColor gradientColor = this.colorAnimation.getValue();
        int[] colors = this.applyDynamicColorsIfNeeded(gradientColor.getColors());
        float[] positions = gradientColor.getPositions();
        float x1 = endPoint.x;
        float x0 = startPoint.x;
        float y1 = endPoint.y;
        float y0 = startPoint.y;
        float r = (float)Math.hypot(x1 - x0, y1 - y0);
        if (r <= 0.0f) {
            r = 0.001f;
        }
        gradient = new RadialGradient(x0, y0, r, colors, positions, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private int getGradientHash() {
        int startPointProgress = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int endPointProgress = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int colorProgress = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int hash = 17;
        if (startPointProgress != 0) {
            hash = hash * 31 * startPointProgress;
        }
        if (endPointProgress != 0) {
            hash = hash * 31 * endPointProgress;
        }
        if (colorProgress != 0) {
            hash = hash * 31 * colorProgress;
        }
        return hash;
    }

    private int[] applyDynamicColorsIfNeeded(int[] colors) {
        block4: {
            if (this.colorCallbackAnimation == null) break block4;
            Integer[] dynamicColors = (Integer[])this.colorCallbackAnimation.getValue();
            if (colors.length == dynamicColors.length) {
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = dynamicColors[i];
                }
            } else {
                colors = new int[dynamicColors.length];
                for (int i = 0; i < dynamicColors.length; ++i) {
                    colors[i] = dynamicColors[i];
                }
            }
        }
        return colors;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        MiscUtils.resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath, this);
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.OPACITY) {
            this.opacityAnimation.setValueCallback(callback);
        } else if (property == LottieProperty.COLOR_FILTER) {
            if (this.colorFilterAnimation != null) {
                this.layer.removeAnimation(this.colorFilterAnimation);
            }
            if (callback == null) {
                this.colorFilterAnimation = null;
            } else {
                this.colorFilterAnimation = new ValueCallbackKeyframeAnimation<ColorFilter, T>(callback);
                this.colorFilterAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorFilterAnimation);
            }
        } else if (property == LottieProperty.GRADIENT_COLOR) {
            if (this.colorCallbackAnimation != null) {
                this.layer.removeAnimation(this.colorCallbackAnimation);
            }
            if (callback == null) {
                this.colorCallbackAnimation = null;
            } else {
                this.linearGradientCache.clear();
                this.radialGradientCache.clear();
                this.colorCallbackAnimation = new ValueCallbackKeyframeAnimation(callback);
                this.colorCallbackAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.colorCallbackAnimation);
            }
        } else if (property == LottieProperty.BLUR_RADIUS) {
            if (this.blurAnimation != null) {
                this.blurAnimation.setValueCallback(callback);
            } else {
                this.blurAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.blurAnimation.addUpdateListener(this);
                this.layer.addAnimation(this.blurAnimation);
            }
        } else if (property == LottieProperty.DROP_SHADOW_COLOR && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setColorCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_OPACITY && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setOpacityCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DIRECTION && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDirectionCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DISTANCE && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDistanceCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_RADIUS && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setRadiusCallback(callback);
        }
    }
}

