/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Color;
import android.graphics.Paint;
import androidx.annotation.Nullable;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.parser.DropShadowEffect;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;

public class DropShadowKeyframeAnimation
implements BaseKeyframeAnimation.AnimationListener {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private final BaseKeyframeAnimation.AnimationListener listener;
    private final BaseKeyframeAnimation<Integer, Integer> color;
    private final BaseKeyframeAnimation<Float, Float> opacity;
    private final BaseKeyframeAnimation<Float, Float> direction;
    private final BaseKeyframeAnimation<Float, Float> distance;
    private final BaseKeyframeAnimation<Float, Float> radius;
    private boolean isDirty = true;

    public DropShadowKeyframeAnimation(BaseKeyframeAnimation.AnimationListener listener, BaseLayer layer, DropShadowEffect dropShadowEffect) {
        this.listener = listener;
        this.color = dropShadowEffect.getColor().createAnimation();
        this.color.addUpdateListener(this);
        layer.addAnimation(this.color);
        this.opacity = dropShadowEffect.getOpacity().createAnimation();
        this.opacity.addUpdateListener(this);
        layer.addAnimation(this.opacity);
        this.direction = dropShadowEffect.getDirection().createAnimation();
        this.direction.addUpdateListener(this);
        layer.addAnimation(this.direction);
        this.distance = dropShadowEffect.getDistance().createAnimation();
        this.distance.addUpdateListener(this);
        layer.addAnimation(this.distance);
        this.radius = dropShadowEffect.getRadius().createAnimation();
        this.radius.addUpdateListener(this);
        layer.addAnimation(this.radius);
    }

    @Override
    public void onValueChanged() {
        this.isDirty = true;
        this.listener.onValueChanged();
    }

    public void applyTo(Paint paint) {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        double directionRad = (double)this.direction.getValue().floatValue() * (Math.PI / 180);
        float distance = this.distance.getValue().floatValue();
        float x = (float)Math.sin(directionRad) * distance;
        float y = (float)Math.cos(directionRad + Math.PI) * distance;
        int baseColor = this.color.getValue();
        int opacity = Math.round(this.opacity.getValue().floatValue());
        int color = Color.argb((int)opacity, (int)Color.red((int)baseColor), (int)Color.green((int)baseColor), (int)Color.blue((int)baseColor));
        float radius = this.radius.getValue().floatValue();
        paint.setShadowLayer(radius, x, y, color);
    }

    public void setColorCallback(@Nullable LottieValueCallback<Integer> callback) {
        this.color.setValueCallback(callback);
    }

    public void setOpacityCallback(final @Nullable LottieValueCallback<Float> callback) {
        if (callback == null) {
            this.opacity.setValueCallback(null);
            return;
        }
        this.opacity.setValueCallback(new LottieValueCallback<Float>(){

            @Override
            @Nullable
            public Float getValue(LottieFrameInfo<Float> frameInfo) {
                Float value = callback.getValue(frameInfo);
                if (value == null) {
                    return null;
                }
                return Float.valueOf(value.floatValue() * 2.55f);
            }
        });
    }

    public void setDirectionCallback(@Nullable LottieValueCallback<Float> callback) {
        this.direction.setValueCallback(callback);
    }

    public void setDistanceCallback(@Nullable LottieValueCallback<Float> callback) {
        this.distance.setValueCallback(callback);
    }

    public void setRadiusCallback(@Nullable LottieValueCallback<Float> callback) {
        this.radius.setValueCallback(callback);
    }
}

