/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.annotation.WorkerThread;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieResult;
import com.airbnb.lottie.LottieTask;
import com.airbnb.lottie.model.LottieCompositionCache;
import com.airbnb.lottie.parser.LottieCompositionMoshiParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.json.JSONObject;

public class LottieCompositionFactory {
    private static final Map<String, LottieTask<LottieComposition>> taskCache = new HashMap<String, LottieTask<LottieComposition>>();
    private static final byte[] MAGIC = new byte[]{80, 75, 3, 4};

    private LottieCompositionFactory() {
    }

    public static void setMaxCacheSize(int size) {
        LottieCompositionCache.getInstance().resize(size);
    }

    public static void clearCache(Context context) {
        taskCache.clear();
        LottieCompositionCache.getInstance().clear();
        L.networkCache(context).clear();
    }

    public static LottieTask<LottieComposition> fromUrl(Context context, String url) {
        return LottieCompositionFactory.fromUrl(context, url, "url_" + url);
    }

    public static LottieTask<LottieComposition> fromUrl(Context context, String url, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> {
            LottieResult<LottieComposition> result = L.networkFetcher(context).fetchSync(url, cacheKey);
            if (cacheKey != null && result.getValue() != null) {
                LottieCompositionCache.getInstance().put(cacheKey, result.getValue());
            }
            return result;
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromUrlSync(Context context, String url) {
        return LottieCompositionFactory.fromUrlSync(context, url, url);
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromUrlSync(Context context, String url, @Nullable String cacheKey) {
        LottieResult<LottieComposition> result = L.networkFetcher(context).fetchSync(url, cacheKey);
        if (cacheKey != null && result.getValue() != null) {
            LottieCompositionCache.getInstance().put(cacheKey, result.getValue());
        }
        return result;
    }

    public static LottieTask<LottieComposition> fromAsset(Context context, String fileName) {
        String cacheKey = "asset_" + fileName;
        return LottieCompositionFactory.fromAsset(context, fileName, cacheKey);
    }

    public static LottieTask<LottieComposition> fromAsset(Context context, String fileName, @Nullable String cacheKey) {
        Context appContext = context.getApplicationContext();
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromAssetSync(appContext, fileName, cacheKey));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromAssetSync(Context context, String fileName) {
        String cacheKey = "asset_" + fileName;
        return LottieCompositionFactory.fromAssetSync(context, fileName, cacheKey);
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromAssetSync(Context context, String fileName, @Nullable String cacheKey) {
        try {
            if (fileName.endsWith(".zip") || fileName.endsWith(".lottie")) {
                return LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(context.getAssets().open(fileName)), cacheKey);
            }
            return LottieCompositionFactory.fromJsonInputStreamSync(context.getAssets().open(fileName), cacheKey);
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    public static LottieTask<LottieComposition> fromRawRes(Context context, @RawRes int rawRes) {
        return LottieCompositionFactory.fromRawRes(context, rawRes, LottieCompositionFactory.rawResCacheKey(context, rawRes));
    }

    public static LottieTask<LottieComposition> fromRawRes(Context context, @RawRes int rawRes, @Nullable String cacheKey) {
        WeakReference<Context> contextRef = new WeakReference<Context>(context);
        Context appContext = context.getApplicationContext();
        return LottieCompositionFactory.cache(cacheKey, () -> {
            Context originalContext = (Context)contextRef.get();
            Context context1 = originalContext != null ? originalContext : appContext;
            return LottieCompositionFactory.fromRawResSync(context1, rawRes, cacheKey);
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromRawResSync(Context context, @RawRes int rawRes) {
        return LottieCompositionFactory.fromRawResSync(context, rawRes, LottieCompositionFactory.rawResCacheKey(context, rawRes));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromRawResSync(Context context, @RawRes int rawRes, @Nullable String cacheKey) {
        try {
            BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)context.getResources().openRawResource(rawRes)));
            if (LottieCompositionFactory.isZipCompressed(source).booleanValue()) {
                return LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(source.inputStream()), cacheKey);
            }
            return LottieCompositionFactory.fromJsonInputStreamSync(source.inputStream(), cacheKey);
        }
        catch (Resources.NotFoundException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    private static String rawResCacheKey(Context context, @RawRes int resId) {
        return "rawRes" + (LottieCompositionFactory.isNightMode(context) ? "_night_" : "_day_") + resId;
    }

    private static boolean isNightMode(Context context) {
        int nightModeMasked = context.getResources().getConfiguration().uiMode & 0x30;
        return nightModeMasked == 32;
    }

    public static LottieTask<LottieComposition> fromJsonInputStream(InputStream stream, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromJsonInputStreamSync(stream, cacheKey));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonInputStreamSync(InputStream stream, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonInputStreamSync(stream, cacheKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private static LottieResult<LottieComposition> fromJsonInputStreamSync(InputStream stream, @Nullable String cacheKey, boolean close) {
        try {
            LottieResult<LottieComposition> lottieResult = LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)stream))), cacheKey);
            return lottieResult;
        }
        finally {
            if (close) {
                Utils.closeQuietly(stream);
            }
        }
    }

    @Deprecated
    public static LottieTask<LottieComposition> fromJson(JSONObject json, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromJsonSync(json, cacheKey));
    }

    @Deprecated
    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonSync(JSONObject json, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonStringSync(json.toString(), cacheKey);
    }

    public static LottieTask<LottieComposition> fromJsonString(String json, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromJsonStringSync(json, cacheKey));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonStringSync(String json, @Nullable String cacheKey) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        return LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)stream))), cacheKey);
    }

    public static LottieTask<LottieComposition> fromJsonReader(JsonReader reader, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromJsonReaderSync(reader, cacheKey));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonReaderSync(JsonReader reader, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonReaderSyncInternal(reader, cacheKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LottieResult<LottieComposition> fromJsonReaderSyncInternal(JsonReader reader, @Nullable String cacheKey, boolean close) {
        try {
            LottieComposition composition = LottieCompositionMoshiParser.parse(reader);
            if (cacheKey != null) {
                LottieCompositionCache.getInstance().put(cacheKey, composition);
            }
            LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(composition);
            return lottieResult;
        }
        catch (Exception e) {
            LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(e);
            return lottieResult;
        }
        finally {
            if (close) {
                Utils.closeQuietly(reader);
            }
        }
    }

    public static LottieTask<LottieComposition> fromZipStream(ZipInputStream inputStream, @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, () -> LottieCompositionFactory.fromZipStreamSync(inputStream, cacheKey));
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromZipStreamSync(ZipInputStream inputStream, @Nullable String cacheKey) {
        try {
            LottieResult<LottieComposition> lottieResult = LottieCompositionFactory.fromZipStreamSyncInternal(inputStream, cacheKey);
            return lottieResult;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    @WorkerThread
    private static LottieResult<LottieComposition> fromZipStreamSyncInternal(ZipInputStream inputStream, @Nullable String cacheKey) {
        LottieComposition composition = null;
        HashMap<String, Bitmap> images = new HashMap<String, Bitmap>();
        try {
            ZipEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                String string = entry.getName();
                if (string.contains("__MACOSX")) {
                    inputStream.closeEntry();
                } else if (entry.getName().equalsIgnoreCase("manifest.json")) {
                    inputStream.closeEntry();
                } else if (entry.getName().contains(".json")) {
                    JsonReader reader = JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)inputStream)));
                    composition = LottieCompositionFactory.fromJsonReaderSyncInternal(reader, null, false).getValue();
                } else if (string.contains(".png") || string.contains(".webp") || string.contains(".jpg") || string.contains(".jpeg")) {
                    String[] splitName = string.split("/");
                    String name = splitName[splitName.length - 1];
                    images.put(name, BitmapFactory.decodeStream((InputStream)inputStream));
                } else {
                    inputStream.closeEntry();
                }
                entry = inputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
        if (composition == null) {
            return new LottieResult<LottieComposition>(new IllegalArgumentException("Unable to parse composition"));
        }
        for (Map.Entry entry : images.entrySet()) {
            LottieImageAsset imageAsset = LottieCompositionFactory.findImageAssetForFileName(composition, (String)entry.getKey());
            if (imageAsset == null) continue;
            imageAsset.setBitmap(Utils.resizeBitmapIfNeeded((Bitmap)entry.getValue(), imageAsset.getWidth(), imageAsset.getHeight()));
        }
        for (Map.Entry<Object, Object> entry : composition.getImages().entrySet()) {
            if (((LottieImageAsset)entry.getValue()).getBitmap() != null) continue;
            return new LottieResult<LottieComposition>(new IllegalStateException("There is no image for " + ((LottieImageAsset)entry.getValue()).getFileName()));
        }
        if (cacheKey != null) {
            LottieCompositionCache.getInstance().put(cacheKey, composition);
        }
        return new LottieResult<LottieComposition>(composition);
    }

    private static Boolean isZipCompressed(BufferedSource inputSource) {
        try {
            BufferedSource peek = inputSource.peek();
            for (byte b : MAGIC) {
                if (peek.readByte() == b) continue;
                return false;
            }
            peek.close();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
        catch (Exception e) {
            Logger.error("Failed to check zip file header", e);
            return false;
        }
    }

    @Nullable
    private static LottieImageAsset findImageAssetForFileName(LottieComposition composition, String fileName) {
        for (LottieImageAsset asset : composition.getImages().values()) {
            if (!asset.getFileName().equals(fileName)) continue;
            return asset;
        }
        return null;
    }

    private static LottieTask<LottieComposition> cache(@Nullable String cacheKey, Callable<LottieResult<LottieComposition>> callable) {
        LottieComposition cachedComposition;
        LottieComposition lottieComposition = cachedComposition = cacheKey == null ? null : LottieCompositionCache.getInstance().get(cacheKey);
        if (cachedComposition != null) {
            return new LottieTask<LottieComposition>(() -> new LottieResult<LottieComposition>(cachedComposition));
        }
        if (cacheKey != null && taskCache.containsKey(cacheKey)) {
            return taskCache.get(cacheKey);
        }
        LottieTask<LottieComposition> task = new LottieTask<LottieComposition>(callable);
        if (cacheKey != null) {
            AtomicBoolean resultAlreadyCalled = new AtomicBoolean(false);
            task.addListener(result -> {
                taskCache.remove(cacheKey);
                resultAlreadyCalled.set(true);
            });
            task.addFailureListener(result -> {
                taskCache.remove(cacheKey);
                resultAlreadyCalled.set(true);
            });
            if (!resultAlreadyCalled.get()) {
                taskCache.put(cacheKey, task);
            }
        }
        return task;
    }
}

