/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.annotation.RequiresApi;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieCompositionFactory;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieListener;
import com.airbnb.lottie.LottieOnCompositionLoadedListener;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.LottieTask;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.R;
import com.airbnb.lottie.RenderMode;
import com.airbnb.lottie.SimpleColorFilter;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LottieAnimationView
extends AppCompatImageView {
    private static final String TAG = LottieAnimationView.class.getSimpleName();
    private static final LottieListener<Throwable> DEFAULT_FAILURE_LISTENER = throwable -> {
        if (Utils.isNetworkException(throwable)) {
            Logger.warning("Unable to load composition.", throwable);
            return;
        }
        throw new IllegalStateException("Unable to parse composition", (Throwable)throwable);
    };
    private final LottieListener<LottieComposition> loadedListener = this::setComposition;
    private final LottieListener<Throwable> wrappedFailureListener = new LottieListener<Throwable>(){

        @Override
        public void onResult(Throwable result) {
            if (LottieAnimationView.this.fallbackResource != 0) {
                LottieAnimationView.this.setImageResource(LottieAnimationView.this.fallbackResource);
            }
            LottieListener l = LottieAnimationView.this.failureListener == null ? DEFAULT_FAILURE_LISTENER : LottieAnimationView.this.failureListener;
            l.onResult(result);
        }
    };
    @Nullable
    private LottieListener<Throwable> failureListener;
    @DrawableRes
    private int fallbackResource = 0;
    private final LottieDrawable lottieDrawable = new LottieDrawable();
    private String animationName;
    @RawRes
    private int animationResId;
    private boolean ignoreUnschedule = false;
    private boolean autoPlay = false;
    private boolean cacheComposition = true;
    private final Set<UserActionTaken> userActionsTaken = new HashSet<UserActionTaken>();
    private final Set<LottieOnCompositionLoadedListener> lottieOnCompositionLoadedListeners = new HashSet<LottieOnCompositionLoadedListener>();
    @Nullable
    private LottieTask<LottieComposition> compositionTask;
    @Nullable
    private LottieComposition composition;

    public LottieAnimationView(Context context) {
        super(context);
        this.init(null, R.attr.lottieAnimationViewStyle);
    }

    public LottieAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, R.attr.lottieAnimationViewStyle);
    }

    public LottieAnimationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(@Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        String url;
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.LottieAnimationView, defStyleAttr, 0);
        this.cacheComposition = ta.getBoolean(R.styleable.LottieAnimationView_lottie_cacheComposition, true);
        boolean hasRawRes = ta.hasValue(R.styleable.LottieAnimationView_lottie_rawRes);
        boolean hasFileName = ta.hasValue(R.styleable.LottieAnimationView_lottie_fileName);
        boolean hasUrl = ta.hasValue(R.styleable.LottieAnimationView_lottie_url);
        if (hasRawRes && hasFileName) {
            throw new IllegalArgumentException("lottie_rawRes and lottie_fileName cannot be used at the same time. Please use only one at once.");
        }
        if (hasRawRes) {
            int rawResId = ta.getResourceId(R.styleable.LottieAnimationView_lottie_rawRes, 0);
            if (rawResId != 0) {
                this.setAnimation(rawResId);
            }
        } else if (hasFileName) {
            String fileName = ta.getString(R.styleable.LottieAnimationView_lottie_fileName);
            if (fileName != null) {
                this.setAnimation(fileName);
            }
        } else if (hasUrl && (url = ta.getString(R.styleable.LottieAnimationView_lottie_url)) != null) {
            this.setAnimationFromUrl(url);
        }
        this.setFallbackResource(ta.getResourceId(R.styleable.LottieAnimationView_lottie_fallbackRes, 0));
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_autoPlay, false)) {
            this.autoPlay = true;
        }
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_loop, false)) {
            this.lottieDrawable.setRepeatCount(-1);
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_repeatMode)) {
            this.setRepeatMode(ta.getInt(R.styleable.LottieAnimationView_lottie_repeatMode, 1));
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_repeatCount)) {
            this.setRepeatCount(ta.getInt(R.styleable.LottieAnimationView_lottie_repeatCount, -1));
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_speed)) {
            this.setSpeed(ta.getFloat(R.styleable.LottieAnimationView_lottie_speed, 1.0f));
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_clipToCompositionBounds)) {
            this.setClipToCompositionBounds(ta.getBoolean(R.styleable.LottieAnimationView_lottie_clipToCompositionBounds, true));
        }
        this.setImageAssetsFolder(ta.getString(R.styleable.LottieAnimationView_lottie_imageAssetsFolder));
        this.setProgress(ta.getFloat(R.styleable.LottieAnimationView_lottie_progress, 0.0f));
        this.enableMergePathsForKitKatAndAbove(ta.getBoolean(R.styleable.LottieAnimationView_lottie_enableMergePathsForKitKatAndAbove, false));
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_colorFilter)) {
            int colorRes = ta.getResourceId(R.styleable.LottieAnimationView_lottie_colorFilter, -1);
            ColorStateList csl = AppCompatResources.getColorStateList((Context)this.getContext(), (int)colorRes);
            SimpleColorFilter filter = new SimpleColorFilter(csl.getDefaultColor());
            KeyPath keyPath = new KeyPath("**");
            LottieValueCallback<SimpleColorFilter> callback = new LottieValueCallback<SimpleColorFilter>(filter);
            this.addValueCallback(keyPath, LottieProperty.COLOR_FILTER, callback);
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_renderMode)) {
            int renderModeOrdinal = ta.getInt(R.styleable.LottieAnimationView_lottie_renderMode, RenderMode.AUTOMATIC.ordinal());
            if (renderModeOrdinal >= RenderMode.values().length) {
                renderModeOrdinal = RenderMode.AUTOMATIC.ordinal();
            }
            this.setRenderMode(RenderMode.values()[renderModeOrdinal]);
        }
        this.setIgnoreDisabledSystemAnimations(ta.getBoolean(R.styleable.LottieAnimationView_lottie_ignoreDisabledSystemAnimations, false));
        ta.recycle();
        this.lottieDrawable.setSystemAnimationsAreEnabled(Utils.getAnimationScale(this.getContext()) != 0.0f);
    }

    public void setImageResource(int resId) {
        this.cancelLoaderTask();
        super.setImageResource(resId);
    }

    public void setImageDrawable(Drawable drawable) {
        this.cancelLoaderTask();
        super.setImageDrawable(drawable);
    }

    public void setImageBitmap(Bitmap bm) {
        this.cancelLoaderTask();
        super.setImageBitmap(bm);
    }

    public void unscheduleDrawable(Drawable who) {
        if (!this.ignoreUnschedule && who == this.lottieDrawable && this.lottieDrawable.isAnimating()) {
            this.pauseAnimation();
        } else if (!this.ignoreUnschedule && who instanceof LottieDrawable && ((LottieDrawable)who).isAnimating()) {
            ((LottieDrawable)who).pauseAnimation();
        }
        super.unscheduleDrawable(who);
    }

    public void invalidateDrawable(@NonNull Drawable dr) {
        if (this.getDrawable() == this.lottieDrawable) {
            super.invalidateDrawable((Drawable)this.lottieDrawable);
        } else {
            super.invalidateDrawable(dr);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.animationName = this.animationName;
        ss.animationResId = this.animationResId;
        ss.progress = this.lottieDrawable.getProgress();
        ss.isAnimating = this.lottieDrawable.isAnimatingOrWillAnimateOnVisible();
        ss.imageAssetsFolder = this.lottieDrawable.getImageAssetsFolder();
        ss.repeatMode = this.lottieDrawable.getRepeatMode();
        ss.repeatCount = this.lottieDrawable.getRepeatCount();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.animationName = ss.animationName;
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_ANIMATION) && !TextUtils.isEmpty((CharSequence)this.animationName)) {
            this.setAnimation(this.animationName);
        }
        this.animationResId = ss.animationResId;
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_ANIMATION) && this.animationResId != 0) {
            this.setAnimation(this.animationResId);
        }
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_PROGRESS)) {
            this.setProgress(ss.progress);
        }
        if (!this.userActionsTaken.contains((Object)UserActionTaken.PLAY_OPTION) && ss.isAnimating) {
            this.playAnimation();
        }
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_IMAGE_ASSETS)) {
            this.setImageAssetsFolder(ss.imageAssetsFolder);
        }
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_REPEAT_MODE)) {
            this.setRepeatMode(ss.repeatMode);
        }
        if (!this.userActionsTaken.contains((Object)UserActionTaken.SET_REPEAT_COUNT)) {
            this.setRepeatCount(ss.repeatCount);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode() && this.autoPlay) {
            this.lottieDrawable.playAnimation();
        }
    }

    public void setIgnoreDisabledSystemAnimations(boolean ignore) {
        this.lottieDrawable.setIgnoreDisabledSystemAnimations(ignore);
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        this.lottieDrawable.enableMergePathsForKitKatAndAbove(enable);
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.lottieDrawable.isMergePathsEnabledForKitKatAndAbove();
    }

    public void setClipToCompositionBounds(boolean clipToCompositionBounds) {
        this.lottieDrawable.setClipToCompositionBounds(clipToCompositionBounds);
    }

    public boolean getClipToCompositionBounds() {
        return this.lottieDrawable.getClipToCompositionBounds();
    }

    public void setCacheComposition(boolean cacheComposition) {
        this.cacheComposition = cacheComposition;
    }

    public void setOutlineMasksAndMattes(boolean outline) {
        this.lottieDrawable.setOutlineMasksAndMattes(outline);
    }

    public void setAnimation(@RawRes int rawRes) {
        this.animationResId = rawRes;
        this.animationName = null;
        this.setCompositionTask(this.fromRawRes(rawRes));
    }

    private LottieTask<LottieComposition> fromRawRes(@RawRes int rawRes) {
        if (this.isInEditMode()) {
            return new LottieTask<LottieComposition>(() -> this.cacheComposition ? LottieCompositionFactory.fromRawResSync(this.getContext(), rawRes) : LottieCompositionFactory.fromRawResSync(this.getContext(), rawRes, null), true);
        }
        return this.cacheComposition ? LottieCompositionFactory.fromRawRes(this.getContext(), rawRes) : LottieCompositionFactory.fromRawRes(this.getContext(), rawRes, null);
    }

    public void setAnimation(String assetName) {
        this.animationName = assetName;
        this.animationResId = 0;
        this.setCompositionTask(this.fromAssets(assetName));
    }

    private LottieTask<LottieComposition> fromAssets(String assetName) {
        if (this.isInEditMode()) {
            return new LottieTask<LottieComposition>(() -> this.cacheComposition ? LottieCompositionFactory.fromAssetSync(this.getContext(), assetName) : LottieCompositionFactory.fromAssetSync(this.getContext(), assetName, null), true);
        }
        return this.cacheComposition ? LottieCompositionFactory.fromAsset(this.getContext(), assetName) : LottieCompositionFactory.fromAsset(this.getContext(), assetName, null);
    }

    @Deprecated
    public void setAnimationFromJson(String jsonString) {
        this.setAnimationFromJson(jsonString, null);
    }

    public void setAnimationFromJson(String jsonString, @Nullable String cacheKey) {
        this.setAnimation(new ByteArrayInputStream(jsonString.getBytes()), cacheKey);
    }

    public void setAnimation(InputStream stream, @Nullable String cacheKey) {
        this.setCompositionTask(LottieCompositionFactory.fromJsonInputStream(stream, cacheKey));
    }

    public void setAnimationFromUrl(String url) {
        LottieTask<LottieComposition> task = this.cacheComposition ? LottieCompositionFactory.fromUrl(this.getContext(), url) : LottieCompositionFactory.fromUrl(this.getContext(), url, null);
        this.setCompositionTask(task);
    }

    public void setAnimationFromUrl(String url, @Nullable String cacheKey) {
        LottieTask<LottieComposition> task = LottieCompositionFactory.fromUrl(this.getContext(), url, cacheKey);
        this.setCompositionTask(task);
    }

    public void setFailureListener(@Nullable LottieListener<Throwable> failureListener) {
        this.failureListener = failureListener;
    }

    public void setFallbackResource(@DrawableRes int fallbackResource) {
        this.fallbackResource = fallbackResource;
    }

    private void setCompositionTask(LottieTask<LottieComposition> compositionTask) {
        this.userActionsTaken.add(UserActionTaken.SET_ANIMATION);
        this.clearComposition();
        this.cancelLoaderTask();
        this.compositionTask = compositionTask.addListener(this.loadedListener).addFailureListener(this.wrappedFailureListener);
    }

    private void cancelLoaderTask() {
        if (this.compositionTask != null) {
            this.compositionTask.removeListener(this.loadedListener);
            this.compositionTask.removeFailureListener(this.wrappedFailureListener);
        }
    }

    public void setComposition(@NonNull LottieComposition composition) {
        if (L.DBG) {
            Log.v((String)TAG, (String)("Set Composition \n" + composition));
        }
        this.lottieDrawable.setCallback((Drawable.Callback)this);
        this.composition = composition;
        this.ignoreUnschedule = true;
        boolean isNewComposition = this.lottieDrawable.setComposition(composition);
        this.ignoreUnschedule = false;
        if (this.getDrawable() == this.lottieDrawable && !isNewComposition) {
            return;
        }
        if (!isNewComposition) {
            this.setLottieDrawable();
        }
        this.onVisibilityChanged((View)this, this.getVisibility());
        this.requestLayout();
        for (LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener : this.lottieOnCompositionLoadedListeners) {
            lottieOnCompositionLoadedListener.onCompositionLoaded(composition);
        }
    }

    @Nullable
    public LottieComposition getComposition() {
        return this.composition;
    }

    public boolean hasMasks() {
        return this.lottieDrawable.hasMasks();
    }

    public boolean hasMatte() {
        return this.lottieDrawable.hasMatte();
    }

    @MainThread
    public void playAnimation() {
        this.userActionsTaken.add(UserActionTaken.PLAY_OPTION);
        this.lottieDrawable.playAnimation();
    }

    @MainThread
    public void resumeAnimation() {
        this.userActionsTaken.add(UserActionTaken.PLAY_OPTION);
        this.lottieDrawable.resumeAnimation();
    }

    public void setMinFrame(int startFrame) {
        this.lottieDrawable.setMinFrame(startFrame);
    }

    public float getMinFrame() {
        return this.lottieDrawable.getMinFrame();
    }

    public void setMinProgress(float startProgress) {
        this.lottieDrawable.setMinProgress(startProgress);
    }

    public void setMaxFrame(int endFrame) {
        this.lottieDrawable.setMaxFrame(endFrame);
    }

    public float getMaxFrame() {
        return this.lottieDrawable.getMaxFrame();
    }

    public void setMaxProgress(@FloatRange(from=0.0, to=1.0) float endProgress) {
        this.lottieDrawable.setMaxProgress(endProgress);
    }

    public void setMinFrame(String markerName) {
        this.lottieDrawable.setMinFrame(markerName);
    }

    public void setMaxFrame(String markerName) {
        this.lottieDrawable.setMaxFrame(markerName);
    }

    public void setMinAndMaxFrame(String markerName) {
        this.lottieDrawable.setMinAndMaxFrame(markerName);
    }

    public void setMinAndMaxFrame(String startMarkerName, String endMarkerName, boolean playEndMarkerStartFrame) {
        this.lottieDrawable.setMinAndMaxFrame(startMarkerName, endMarkerName, playEndMarkerStartFrame);
    }

    public void setMinAndMaxFrame(int minFrame, int maxFrame) {
        this.lottieDrawable.setMinAndMaxFrame(minFrame, maxFrame);
    }

    public void setMinAndMaxProgress(@FloatRange(from=0.0, to=1.0) float minProgress, @FloatRange(from=0.0, to=1.0) float maxProgress) {
        this.lottieDrawable.setMinAndMaxProgress(minProgress, maxProgress);
    }

    public void reverseAnimationSpeed() {
        this.lottieDrawable.reverseAnimationSpeed();
    }

    public void setSpeed(float speed) {
        this.lottieDrawable.setSpeed(speed);
    }

    public float getSpeed() {
        return this.lottieDrawable.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.addAnimatorUpdateListener(updateListener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.removeAnimatorUpdateListener(updateListener);
    }

    public void removeAllUpdateListeners() {
        this.lottieDrawable.removeAllUpdateListeners();
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.addAnimatorListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.removeAnimatorListener(listener);
    }

    public void removeAllAnimatorListeners() {
        this.lottieDrawable.removeAllAnimatorListeners();
    }

    @RequiresApi(api=19)
    public void addAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.lottieDrawable.addAnimatorPauseListener(listener);
    }

    @RequiresApi(api=19)
    public void removeAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.lottieDrawable.removeAnimatorPauseListener(listener);
    }

    @Deprecated
    public void loop(boolean loop) {
        this.lottieDrawable.setRepeatCount(loop ? -1 : 0);
    }

    public void setRepeatMode(int mode) {
        this.userActionsTaken.add(UserActionTaken.SET_REPEAT_MODE);
        this.lottieDrawable.setRepeatMode(mode);
    }

    public int getRepeatMode() {
        return this.lottieDrawable.getRepeatMode();
    }

    public void setRepeatCount(int count) {
        this.userActionsTaken.add(UserActionTaken.SET_REPEAT_COUNT);
        this.lottieDrawable.setRepeatCount(count);
    }

    public int getRepeatCount() {
        return this.lottieDrawable.getRepeatCount();
    }

    public boolean isAnimating() {
        return this.lottieDrawable.isAnimating();
    }

    public void setImageAssetsFolder(String imageAssetsFolder) {
        this.lottieDrawable.setImagesAssetsFolder(imageAssetsFolder);
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.lottieDrawable.getImageAssetsFolder();
    }

    public void setMaintainOriginalImageBounds(boolean maintainOriginalImageBounds) {
        this.lottieDrawable.setMaintainOriginalImageBounds(maintainOriginalImageBounds);
    }

    public boolean getMaintainOriginalImageBounds() {
        return this.lottieDrawable.getMaintainOriginalImageBounds();
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        return this.lottieDrawable.updateBitmap(id, bitmap);
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.lottieDrawable.setImageAssetDelegate(assetDelegate);
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.lottieDrawable.setFontAssetDelegate(assetDelegate);
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.lottieDrawable.setTextDelegate(textDelegate);
    }

    public List<KeyPath> resolveKeyPath(KeyPath keyPath) {
        return this.lottieDrawable.resolveKeyPath(keyPath);
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, LottieValueCallback<T> callback) {
        this.lottieDrawable.addValueCallback(keyPath, property, callback);
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, final SimpleLottieValueCallback<T> callback) {
        this.lottieDrawable.addValueCallback(keyPath, property, new LottieValueCallback<T>(){

            @Override
            public T getValue(LottieFrameInfo<T> frameInfo) {
                return callback.getValue(frameInfo);
            }
        });
    }

    @MainThread
    public void cancelAnimation() {
        this.userActionsTaken.add(UserActionTaken.PLAY_OPTION);
        this.lottieDrawable.cancelAnimation();
    }

    @MainThread
    public void pauseAnimation() {
        this.autoPlay = false;
        this.lottieDrawable.pauseAnimation();
    }

    public void setFrame(int frame) {
        this.lottieDrawable.setFrame(frame);
    }

    public int getFrame() {
        return this.lottieDrawable.getFrame();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.userActionsTaken.add(UserActionTaken.SET_PROGRESS);
        this.lottieDrawable.setProgress(progress);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.lottieDrawable.getProgress();
    }

    public long getDuration() {
        return this.composition != null ? (long)this.composition.getDuration() : 0L;
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.lottieDrawable.setPerformanceTrackingEnabled(enabled);
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        return this.lottieDrawable.getPerformanceTracker();
    }

    private void clearComposition() {
        this.composition = null;
        this.lottieDrawable.clearComposition();
    }

    public void setSafeMode(boolean safeMode) {
        this.lottieDrawable.setSafeMode(safeMode);
    }

    public void setRenderMode(RenderMode renderMode) {
        this.lottieDrawable.setRenderMode(renderMode);
    }

    public RenderMode getRenderMode() {
        return this.lottieDrawable.getRenderMode();
    }

    public void setApplyingOpacityToLayersEnabled(boolean isApplyingOpacityToLayersEnabled) {
        this.lottieDrawable.setApplyingOpacityToLayersEnabled(isApplyingOpacityToLayersEnabled);
    }

    @Deprecated
    public void disableExtraScaleModeInFitXY() {
        this.lottieDrawable.disableExtraScaleModeInFitXY();
    }

    public boolean addLottieOnCompositionLoadedListener(@NonNull LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener) {
        LottieComposition composition = this.composition;
        if (composition != null) {
            lottieOnCompositionLoadedListener.onCompositionLoaded(composition);
        }
        return this.lottieOnCompositionLoadedListeners.add(lottieOnCompositionLoadedListener);
    }

    public boolean removeLottieOnCompositionLoadedListener(@NonNull LottieOnCompositionLoadedListener lottieOnCompositionLoadedListener) {
        return this.lottieOnCompositionLoadedListeners.remove(lottieOnCompositionLoadedListener);
    }

    public void removeAllLottieOnCompositionLoadedListener() {
        this.lottieOnCompositionLoadedListeners.clear();
    }

    private void setLottieDrawable() {
        boolean wasAnimating = this.isAnimating();
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
        if (wasAnimating) {
            this.lottieDrawable.resumeAnimation();
        }
    }

    private static enum UserActionTaken {
        SET_ANIMATION,
        SET_PROGRESS,
        SET_REPEAT_MODE,
        SET_REPEAT_COUNT,
        SET_IMAGE_ASSETS,
        PLAY_OPTION;

    }

    private static class SavedState
    extends View.BaseSavedState {
        String animationName;
        int animationResId;
        float progress;
        boolean isAnimating;
        String imageAssetsFolder;
        int repeatMode;
        int repeatCount;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.animationName = in.readString();
            this.progress = in.readFloat();
            this.isAnimating = in.readInt() == 1;
            this.imageAssetsFolder = in.readString();
            this.repeatMode = in.readInt();
            this.repeatCount = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.animationName);
            out.writeFloat(this.progress);
            out.writeInt(this.isAnimating ? 1 : 0);
            out.writeString(this.imageAssetsFolder);
            out.writeInt(this.repeatMode);
            out.writeInt(this.repeatCount);
        }
    }
}

