/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Rect;
import androidx.collection.LongSparseArray;
import androidx.collection.SparseArrayCompat;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.Marker;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.FontCharacterParser;
import com.airbnb.lottie.parser.FontParser;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LottieCompositionMoshiParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("w", "h", "ip", "op", "fr", "v", "layers", "assets", "fonts", "chars", "markers");
    static JsonReader.Options ASSETS_NAMES = JsonReader.Options.of("id", "layers", "w", "h", "p", "u");
    private static final JsonReader.Options FONT_NAMES = JsonReader.Options.of("list");
    private static final JsonReader.Options MARKER_NAMES = JsonReader.Options.of("cm", "tm", "dr");

    public static LottieComposition parse(JsonReader reader) throws IOException {
        float scale = Utils.dpScale();
        float startFrame = 0.0f;
        float endFrame = 0.0f;
        float frameRate = 0.0f;
        LongSparseArray layerMap = new LongSparseArray();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        int width = 0;
        int height = 0;
        HashMap<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
        HashMap<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
        HashMap<String, Font> fonts = new HashMap<String, Font>();
        ArrayList<Marker> markers = new ArrayList<Marker>();
        SparseArrayCompat characters = new SparseArrayCompat();
        LottieComposition composition = new LottieComposition();
        reader.beginObject();
        block13: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    width = reader.nextInt();
                    continue block13;
                }
                case 1: {
                    height = reader.nextInt();
                    continue block13;
                }
                case 2: {
                    startFrame = (float)reader.nextDouble();
                    continue block13;
                }
                case 3: {
                    endFrame = (float)reader.nextDouble() - 0.01f;
                    continue block13;
                }
                case 4: {
                    frameRate = (float)reader.nextDouble();
                    continue block13;
                }
                case 5: {
                    int patchVersion;
                    int minorVersion;
                    String version = reader.nextString();
                    String[] versions = version.split("\\.");
                    int majorVersion = Integer.parseInt(versions[0]);
                    if (Utils.isAtLeastVersion(majorVersion, minorVersion = Integer.parseInt(versions[1]), patchVersion = Integer.parseInt(versions[2]), 4, 4, 0)) continue block13;
                    composition.addWarning("Lottie only supports bodymovin >= 4.4.0");
                    continue block13;
                }
                case 6: {
                    LottieCompositionMoshiParser.parseLayers(reader, composition, layers, (LongSparseArray<Layer>)layerMap);
                    continue block13;
                }
                case 7: {
                    LottieCompositionMoshiParser.parseAssets(reader, composition, precomps, images);
                    continue block13;
                }
                case 8: {
                    LottieCompositionMoshiParser.parseFonts(reader, fonts);
                    continue block13;
                }
                case 9: {
                    LottieCompositionMoshiParser.parseChars(reader, composition, (SparseArrayCompat<FontCharacter>)characters);
                    continue block13;
                }
                case 10: {
                    LottieCompositionMoshiParser.parseMarkers(reader, composition, markers);
                    continue block13;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        Rect bounds = new Rect(0, 0, scaledWidth, scaledHeight);
        composition.init(bounds, startFrame, endFrame, frameRate, layers, (LongSparseArray<Layer>)layerMap, precomps, images, (SparseArrayCompat<FontCharacter>)characters, fonts, markers);
        return composition;
    }

    private static void parseLayers(JsonReader reader, LottieComposition composition, List<Layer> layers, LongSparseArray<Layer> layerMap) throws IOException {
        int imageCount = 0;
        reader.beginArray();
        while (reader.hasNext()) {
            Layer layer = LayerParser.parse(reader, composition);
            if (layer.getLayerType() == Layer.LayerType.IMAGE) {
                ++imageCount;
            }
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
            if (imageCount <= 4) continue;
            Logger.warning("You have " + imageCount + " images. Lottie should primarily be used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers to shape layers.");
        }
        reader.endArray();
    }

    private static void parseAssets(JsonReader reader, LottieComposition composition, Map<String, List<Layer>> precomps, Map<String, LottieImageAsset> images) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String id = null;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            LongSparseArray layerMap = new LongSparseArray();
            int width = 0;
            int height = 0;
            String imageFileName = null;
            String relativeFolder = null;
            reader.beginObject();
            block9: while (reader.hasNext()) {
                switch (reader.selectName(ASSETS_NAMES)) {
                    case 0: {
                        id = reader.nextString();
                        continue block9;
                    }
                    case 1: {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Layer layer = LayerParser.parse(reader, composition);
                            layerMap.put(layer.getId(), (Object)layer);
                            layers.add(layer);
                        }
                        reader.endArray();
                        continue block9;
                    }
                    case 2: {
                        width = reader.nextInt();
                        continue block9;
                    }
                    case 3: {
                        height = reader.nextInt();
                        continue block9;
                    }
                    case 4: {
                        imageFileName = reader.nextString();
                        continue block9;
                    }
                    case 5: {
                        relativeFolder = reader.nextString();
                        continue block9;
                    }
                }
                reader.skipName();
                reader.skipValue();
            }
            reader.endObject();
            if (imageFileName != null) {
                LottieImageAsset image = new LottieImageAsset(width, height, id, imageFileName, relativeFolder);
                images.put(image.getId(), image);
                continue;
            }
            precomps.put(id, layers);
        }
        reader.endArray();
    }

    private static void parseFonts(JsonReader reader, Map<String, Font> fonts) throws IOException {
        reader.beginObject();
        block3: while (reader.hasNext()) {
            switch (reader.selectName(FONT_NAMES)) {
                case 0: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        Font font = FontParser.parse(reader);
                        fonts.put(font.getName(), font);
                    }
                    reader.endArray();
                    continue block3;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
    }

    private static void parseChars(JsonReader reader, LottieComposition composition, SparseArrayCompat<FontCharacter> characters) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            FontCharacter character = FontCharacterParser.parse(reader, composition);
            characters.put(character.hashCode(), (Object)character);
        }
        reader.endArray();
    }

    private static void parseMarkers(JsonReader reader, LottieComposition composition, List<Marker> markers) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String comment = null;
            float frame = 0.0f;
            float durationFrames = 0.0f;
            reader.beginObject();
            block6: while (reader.hasNext()) {
                switch (reader.selectName(MARKER_NAMES)) {
                    case 0: {
                        comment = reader.nextString();
                        continue block6;
                    }
                    case 1: {
                        frame = (float)reader.nextDouble();
                        continue block6;
                    }
                    case 2: {
                        durationFrames = (float)reader.nextDouble();
                        continue block6;
                    }
                }
                reader.skipName();
                reader.skipValue();
            }
            reader.endObject();
            markers.add(new Marker(comment, frame, durationFrames));
        }
        reader.endArray();
    }
}

