/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Path;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.GradientFill;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.Collections;

class GradientFillParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "g", "o", "t", "s", "e", "r", "hd");
    private static final JsonReader.Options GRADIENT_NAMES = JsonReader.Options.of("p", "k");

    private GradientFillParser() {
    }

    static GradientFill parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableGradientColorValue color = null;
        AnimatableIntegerValue opacity = null;
        GradientType gradientType = null;
        AnimatablePointValue startPoint = null;
        AnimatablePointValue endPoint = null;
        Path.FillType fillType = Path.FillType.WINDING;
        boolean hidden = false;
        block14: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block14;
                }
                case 1: {
                    int points = -1;
                    reader.beginObject();
                    block15: while (reader.hasNext()) {
                        switch (reader.selectName(GRADIENT_NAMES)) {
                            case 0: {
                                points = reader.nextInt();
                                continue block15;
                            }
                            case 1: {
                                color = AnimatableValueParser.parseGradientColor(reader, composition, points);
                                continue block15;
                            }
                        }
                        reader.skipName();
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block14;
                }
                case 2: {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block14;
                }
                case 3: {
                    gradientType = reader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    continue block14;
                }
                case 4: {
                    startPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block14;
                }
                case 5: {
                    endPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block14;
                }
                case 6: {
                    fillType = reader.nextInt() == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
                    continue block14;
                }
                case 7: {
                    hidden = reader.nextBoolean();
                    continue block14;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        opacity = opacity == null ? new AnimatableIntegerValue(Collections.singletonList(new Keyframe<Integer>(100))) : opacity;
        return new GradientFill(name, gradientType, fillType, color, opacity, startPoint, endPoint, null, null, hidden);
    }
}

