/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.manager.FontAssetManager;
import com.airbnb.lottie.manager.ImageAssetManager;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.Marker;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.LottieValueAnimator;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LottieDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    private final Matrix matrix = new Matrix();
    private LottieComposition composition;
    private final LottieValueAnimator animator = new LottieValueAnimator();
    private float scale = 1.0f;
    private boolean systemAnimationsEnabled = true;
    private boolean ignoreSystemAnimationsDisabled = false;
    private boolean safeMode = false;
    private final ArrayList<LazyCompositionTask> lazyCompositionTasks = new ArrayList();
    private final ValueAnimator.AnimatorUpdateListener progressUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            if (LottieDrawable.this.compositionLayer != null) {
                LottieDrawable.this.compositionLayer.setProgress(LottieDrawable.this.animator.getAnimatedValueAbsolute());
            }
        }
    };
    @Nullable
    private ImageAssetManager imageAssetManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    @Nullable
    private FontAssetManager fontAssetManager;
    @Nullable
    FontAssetDelegate fontAssetDelegate;
    @Nullable
    TextDelegate textDelegate;
    private boolean enableMergePaths;
    @Nullable
    private CompositionLayer compositionLayer;
    private int alpha = 255;
    private boolean performanceTrackingEnabled;
    private boolean outlineMasksAndMattes;
    private boolean isApplyingOpacityToLayersEnabled;
    private boolean isExtraScaleEnabled = true;
    private boolean isDirty = false;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public LottieDrawable() {
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    public boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        if (this.enableMergePaths == enable) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            Logger.warning("Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = enable;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.imageAssetsFolder;
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.composition == composition) {
            return false;
        }
        this.isDirty = false;
        this.clearComposition();
        this.composition = composition;
        this.buildCompositionLayer();
        this.animator.setComposition(composition);
        this.setProgress(this.animator.getAnimatedFraction());
        this.setScale(this.scale);
        Iterator<LazyCompositionTask> it = new ArrayList<LazyCompositionTask>(this.lazyCompositionTasks).iterator();
        while (it.hasNext()) {
            LazyCompositionTask t = it.next();
            if (t != null) {
                t.run(composition);
            }
            it.remove();
        }
        this.lazyCompositionTasks.clear();
        composition.setPerformanceTrackingEnabled(this.performanceTrackingEnabled);
        Drawable.Callback callback = this.getCallback();
        if (callback instanceof ImageView) {
            ((ImageView)callback).setImageDrawable(null);
            ((ImageView)callback).setImageDrawable((Drawable)this);
        }
        return true;
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTrackingEnabled = enabled;
        if (this.composition != null) {
            this.composition.setPerformanceTrackingEnabled(enabled);
        }
    }

    public void setOutlineMasksAndMattes(boolean outline) {
        if (this.outlineMasksAndMattes == outline) {
            return;
        }
        this.outlineMasksAndMattes = outline;
        if (this.compositionLayer != null) {
            this.compositionLayer.setOutlineMasksAndMattes(outline);
        }
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        if (this.composition != null) {
            return this.composition.getPerformanceTracker();
        }
        return null;
    }

    public void setApplyingOpacityToLayersEnabled(boolean isApplyingOpacityToLayersEnabled) {
        this.isApplyingOpacityToLayersEnabled = isApplyingOpacityToLayersEnabled;
    }

    public void disableExtraScaleModeInFitXY() {
        this.isExtraScaleEnabled = false;
    }

    public boolean isApplyingOpacityToLayersEnabled() {
        return this.isApplyingOpacityToLayersEnabled;
    }

    private void buildCompositionLayer() {
        this.compositionLayer = new CompositionLayer(this, LayerParser.parse(this.composition), this.composition.getLayers(), this.composition);
        if (this.outlineMasksAndMattes) {
            this.compositionLayer.setOutlineMasksAndMattes(true);
        }
    }

    public void clearComposition() {
        if (this.animator.isRunning()) {
            this.animator.cancel();
        }
        this.composition = null;
        this.compositionLayer = null;
        this.imageAssetManager = null;
        this.animator.clearComposition();
        this.invalidateSelf();
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public void invalidateSelf() {
        if (this.isDirty) {
            return;
        }
        this.isDirty = true;
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Logger.warning("Use addColorFilter instead.");
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        this.isDirty = false;
        L.beginSection("Drawable#draw");
        if (this.safeMode) {
            try {
                this.drawInternal(canvas);
            }
            catch (Throwable e) {
                Logger.error("Lottie crashed in draw!", e);
            }
        } else {
            this.drawInternal(canvas);
        }
        L.endSection("Drawable#draw");
    }

    private void drawInternal(@NonNull Canvas canvas) {
        if (!this.boundsMatchesCompositionAspectRatio()) {
            this.drawWithNewAspectRatio(canvas);
        } else {
            this.drawWithOriginalAspectRatio(canvas);
        }
    }

    private boolean boundsMatchesCompositionAspectRatio() {
        LottieComposition composition = this.composition;
        if (composition == null || this.getBounds().isEmpty()) {
            return true;
        }
        return this.aspectRatio(this.getBounds()) == this.aspectRatio(composition.getBounds());
    }

    private float aspectRatio(Rect rect) {
        return (float)rect.width() / (float)rect.height();
    }

    @MainThread
    public void start() {
        Drawable.Callback callback = this.getCallback();
        if (callback instanceof View && !((View)callback).isInEditMode()) {
            this.playAnimation();
        }
    }

    @MainThread
    public void stop() {
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.isAnimating();
    }

    @MainThread
    public void playAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.playAnimation();
                }
            });
            return;
        }
        if (this.animationsEnabled() || this.getRepeatCount() == 0) {
            this.animator.playAnimation();
        }
        if (!this.animationsEnabled()) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
        }
    }

    @MainThread
    public void endAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.endAnimation();
    }

    @MainThread
    public void resumeAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.resumeAnimation();
                }
            });
            return;
        }
        if (this.animationsEnabled() || this.getRepeatCount() == 0) {
            this.animator.resumeAnimation();
        }
        if (!this.animationsEnabled()) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
        }
    }

    public void setMinFrame(final int minFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinFrame(minFrame);
                }
            });
            return;
        }
        this.animator.setMinFrame(minFrame);
    }

    public float getMinFrame() {
        return this.animator.getMinFrame();
    }

    public void setMinProgress(final float minProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinProgress(minProgress);
                }
            });
            return;
        }
        this.setMinFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress));
    }

    public void setMaxFrame(final int maxFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMaxFrame(maxFrame);
                }
            });
            return;
        }
        this.animator.setMaxFrame((float)maxFrame + 0.99f);
    }

    public float getMaxFrame() {
        return this.animator.getMaxFrame();
    }

    public void setMaxProgress(final @FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMaxProgress(maxProgress);
                }
            });
            return;
        }
        this.setMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void setMinFrame(final String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinFrame(markerName);
                }
            });
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        this.setMinFrame((int)marker.startFrame);
    }

    public void setMaxFrame(final String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMaxFrame(markerName);
                }
            });
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        this.setMaxFrame((int)(marker.startFrame + marker.durationFrames));
    }

    public void setMinAndMaxFrame(final String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinAndMaxFrame(markerName);
                }
            });
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        int startFrame = (int)marker.startFrame;
        this.setMinAndMaxFrame(startFrame, startFrame + (int)marker.durationFrames);
    }

    public void setMinAndMaxFrame(final String startMarkerName, final String endMarkerName, final boolean playEndMarkerStartFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinAndMaxFrame(startMarkerName, endMarkerName, playEndMarkerStartFrame);
                }
            });
            return;
        }
        Marker startMarker = this.composition.getMarker(startMarkerName);
        if (startMarker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + startMarkerName + ".");
        }
        int startFrame = (int)startMarker.startFrame;
        Marker endMarker = this.composition.getMarker(endMarkerName);
        if (endMarker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + endMarkerName + ".");
        }
        int endFrame = (int)(endMarker.startFrame + (playEndMarkerStartFrame ? 1.0f : 0.0f));
        this.setMinAndMaxFrame(startFrame, endFrame);
    }

    public void setMinAndMaxFrame(final int minFrame, final int maxFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinAndMaxFrame(minFrame, maxFrame);
                }
            });
            return;
        }
        this.animator.setMinAndMaxFrames(minFrame, (float)maxFrame + 0.99f);
    }

    public void setMinAndMaxProgress(final @FloatRange(from=0.0, to=1.0) float minProgress, final @FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinAndMaxProgress(minProgress, maxProgress);
                }
            });
            return;
        }
        this.setMinAndMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress), (int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void reverseAnimationSpeed() {
        this.animator.reverseAnimationSpeed();
    }

    public void setSpeed(float speed) {
        this.animator.setSpeed(speed);
    }

    public float getSpeed() {
        return this.animator.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    public void removeAllUpdateListeners() {
        this.animator.removeAllUpdateListeners();
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public void removeAllAnimatorListeners() {
        this.animator.removeAllListeners();
    }

    @RequiresApi(api=19)
    public void addAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.animator.addPauseListener(listener);
    }

    @RequiresApi(api=19)
    public void removeAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.animator.removePauseListener(listener);
    }

    public void setFrame(final int frame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setFrame(frame);
                }
            });
            return;
        }
        this.animator.setFrame(frame);
    }

    public int getFrame() {
        return (int)this.animator.getFrame();
    }

    public void setProgress(final @FloatRange(from=0.0, to=1.0) float progress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setProgress(progress);
                }
            });
            return;
        }
        L.beginSection("Drawable#setProgress");
        this.animator.setFrame(this.composition.getFrameForProgress(progress));
        L.endSection("Drawable#setProgress");
    }

    @Deprecated
    public void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    public void setRepeatMode(int mode) {
        this.animator.setRepeatMode(mode);
    }

    @SuppressLint(value={"WrongConstant"})
    public int getRepeatMode() {
        return this.animator.getRepeatMode();
    }

    public void setRepeatCount(int count) {
        this.animator.setRepeatCount(count);
    }

    public int getRepeatCount() {
        return this.animator.getRepeatCount();
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        if (this.animator == null) {
            return false;
        }
        return this.animator.isRunning();
    }

    private boolean animationsEnabled() {
        return this.systemAnimationsEnabled || this.ignoreSystemAnimationsDisabled;
    }

    void setSystemAnimationsAreEnabled(Boolean areEnabled) {
        this.systemAnimationsEnabled = areEnabled;
    }

    public void setIgnoreDisabledSystemAnimations(boolean ignore) {
        this.ignoreSystemAnimationsDisabled = ignore;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetManager != null) {
            this.imageAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.fontAssetDelegate = assetDelegate;
        if (this.fontAssetManager != null) {
            this.fontAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.textDelegate = textDelegate;
    }

    @Nullable
    public TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    public boolean useTextGlyphs() {
        return this.textDelegate == null && this.composition.getCharacters().size() > 0;
    }

    public float getScale() {
        return this.scale;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    public void cancelAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.cancel();
    }

    public void pauseAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.pauseAnimation();
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.animator.getAnimatedValueAbsolute();
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.getScale());
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.getScale());
    }

    public List<KeyPath> resolveKeyPath(KeyPath keyPath) {
        if (this.compositionLayer == null) {
            Logger.warning("Cannot resolve KeyPath. Composition is not set yet.");
            return Collections.emptyList();
        }
        ArrayList<KeyPath> keyPaths = new ArrayList<KeyPath>();
        this.compositionLayer.resolveKeyPath(keyPath, 0, keyPaths, new KeyPath(new String[0]));
        return keyPaths;
    }

    public <T> void addValueCallback(final KeyPath keyPath, final T property, final @Nullable LottieValueCallback<T> callback) {
        boolean invalidate;
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.addValueCallback(keyPath, property, callback);
                }
            });
            return;
        }
        if (keyPath == KeyPath.COMPOSITION) {
            this.compositionLayer.addValueCallback(property, callback);
            invalidate = true;
        } else if (keyPath.getResolvedElement() != null) {
            keyPath.getResolvedElement().addValueCallback(property, callback);
            invalidate = true;
        } else {
            List<KeyPath> elements = this.resolveKeyPath(keyPath);
            for (int i = 0; i < elements.size(); ++i) {
                elements.get(i).getResolvedElement().addValueCallback(property, callback);
            }
            boolean bl = invalidate = !elements.isEmpty();
        }
        if (invalidate) {
            this.invalidateSelf();
            if (property == LottieProperty.TIME_REMAP) {
                this.setProgress(this.getProgress());
            }
        }
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, final SimpleLottieValueCallback<T> callback) {
        this.addValueCallback(keyPath, property, new LottieValueCallback<T>(){

            @Override
            public T getValue(LottieFrameInfo<T> frameInfo) {
                return callback.getValue(frameInfo);
            }
        });
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm == null) {
            Logger.warning("Cannot update bitmap. Most likely the drawable is not added to a View which prevents Lottie from getting a Context.");
            return null;
        }
        Bitmap ret = bm.updateBitmap(id, bitmap);
        this.invalidateSelf();
        return ret;
    }

    @Nullable
    public Bitmap getImageAsset(String id) {
        LottieImageAsset imageAsset;
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm != null) {
            return bm.bitmapForId(id);
        }
        LottieImageAsset lottieImageAsset = imageAsset = this.composition == null ? null : this.composition.getImages().get(id);
        if (imageAsset != null) {
            return imageAsset.getBitmap();
        }
        return null;
    }

    private ImageAssetManager getImageAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.imageAssetManager != null && !this.imageAssetManager.hasSameContext(this.getContext())) {
            this.imageAssetManager = null;
        }
        if (this.imageAssetManager == null) {
            this.imageAssetManager = new ImageAssetManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetManager;
    }

    @Nullable
    public Typeface getTypeface(String fontFamily, String style) {
        FontAssetManager assetManager = this.getFontAssetManager();
        if (assetManager != null) {
            return assetManager.getTypeface(fontFamily, style);
        }
        return null;
    }

    private FontAssetManager getFontAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.fontAssetManager == null) {
            this.fontAssetManager = new FontAssetManager(this.getCallback(), this.fontAssetDelegate);
        }
        return this.fontAssetManager;
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }

    private float getMaxScale(@NonNull Canvas canvas) {
        float maxScaleX = (float)canvas.getWidth() / (float)this.composition.getBounds().width();
        float maxScaleY = (float)canvas.getHeight() / (float)this.composition.getBounds().height();
        return Math.min(maxScaleX, maxScaleY);
    }

    private void drawWithNewAspectRatio(Canvas canvas) {
        if (this.compositionLayer == null) {
            return;
        }
        int saveCount = -1;
        Rect bounds = this.getBounds();
        float scaleX = (float)bounds.width() / (float)this.composition.getBounds().width();
        float scaleY = (float)bounds.height() / (float)this.composition.getBounds().height();
        if (this.isExtraScaleEnabled) {
            float maxScale = Math.min(scaleX, scaleY);
            float extraScale = 1.0f;
            if (maxScale < 1.0f) {
                scaleX /= (extraScale /= maxScale);
                scaleY /= extraScale;
            }
            if (extraScale > 1.0f) {
                saveCount = canvas.save();
                float halfWidth = (float)bounds.width() / 2.0f;
                float halfHeight = (float)bounds.height() / 2.0f;
                float scaledHalfWidth = halfWidth * maxScale;
                float scaledHalfHeight = halfHeight * maxScale;
                canvas.translate(halfWidth - scaledHalfWidth, halfHeight - scaledHalfHeight);
                canvas.scale(extraScale, extraScale, scaledHalfWidth, scaledHalfHeight);
            }
        }
        this.matrix.reset();
        this.matrix.preScale(scaleX, scaleY);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        if (saveCount > 0) {
            canvas.restoreToCount(saveCount);
        }
    }

    private void drawWithOriginalAspectRatio(Canvas canvas) {
        if (this.compositionLayer == null) {
            return;
        }
        float scale = this.scale;
        float extraScale = 1.0f;
        float maxScale = this.getMaxScale(canvas);
        if (scale > maxScale) {
            scale = maxScale;
            extraScale = this.scale / scale;
        }
        int saveCount = -1;
        if (extraScale > 1.0f) {
            saveCount = canvas.save();
            float halfWidth = (float)this.composition.getBounds().width() / 2.0f;
            float halfHeight = (float)this.composition.getBounds().height() / 2.0f;
            float scaledHalfWidth = halfWidth * scale;
            float scaledHalfHeight = halfHeight * scale;
            canvas.translate(this.getScale() * halfWidth - scaledHalfWidth, this.getScale() * halfHeight - scaledHalfHeight);
            canvas.scale(extraScale, extraScale, scaledHalfWidth, scaledHalfHeight);
        }
        this.matrix.reset();
        this.matrix.preScale(scale, scale);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        if (saveCount > 0) {
            canvas.restoreToCount(saveCount);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }

    private static interface LazyCompositionTask {
        public void run(LottieComposition var1);
    }
}

