/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.os.TraceCompat;
import com.airbnb.lottie.network.DefaultLottieNetworkFetcher;
import com.airbnb.lottie.network.LottieNetworkCacheProvider;
import com.airbnb.lottie.network.LottieNetworkFetcher;
import com.airbnb.lottie.network.NetworkCache;
import com.airbnb.lottie.network.NetworkFetcher;
import java.io.File;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class L {
    public static boolean DBG = false;
    public static final String TAG = "LOTTIE";
    private static final int MAX_DEPTH = 20;
    private static boolean traceEnabled = false;
    private static String[] sections;
    private static long[] startTimeNs;
    private static int traceDepth;
    private static int depthPastMaxDepth;
    private static LottieNetworkFetcher fetcher;
    private static LottieNetworkCacheProvider cacheProvider;
    private static volatile NetworkFetcher networkFetcher;
    private static volatile NetworkCache networkCache;

    private L() {
    }

    public static void setTraceEnabled(boolean enabled) {
        if (traceEnabled == enabled) {
            return;
        }
        traceEnabled = enabled;
        if (traceEnabled) {
            sections = new String[20];
            startTimeNs = new long[20];
        }
    }

    public static void beginSection(String section) {
        if (!traceEnabled) {
            return;
        }
        if (traceDepth == 20) {
            ++depthPastMaxDepth;
            return;
        }
        L.sections[L.traceDepth] = section;
        L.startTimeNs[L.traceDepth] = System.nanoTime();
        TraceCompat.beginSection((String)section);
        ++traceDepth;
    }

    public static float endSection(String section) {
        if (depthPastMaxDepth > 0) {
            --depthPastMaxDepth;
            return 0.0f;
        }
        if (!traceEnabled) {
            return 0.0f;
        }
        if (--traceDepth == -1) {
            throw new IllegalStateException("Can't end trace section. There are none.");
        }
        if (!section.equals(sections[traceDepth])) {
            throw new IllegalStateException("Unbalanced trace call " + section + ". Expected " + sections[traceDepth] + ".");
        }
        TraceCompat.endSection();
        return (float)(System.nanoTime() - startTimeNs[traceDepth]) / 1000000.0f;
    }

    public static void setFetcher(LottieNetworkFetcher customFetcher) {
        fetcher = customFetcher;
    }

    public static void setCacheProvider(LottieNetworkCacheProvider customProvider) {
        cacheProvider = customProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static NetworkFetcher networkFetcher(@NonNull Context context) {
        NetworkFetcher local = networkFetcher;
        if (local != null) return local;
        Class<NetworkFetcher> clazz = NetworkFetcher.class;
        synchronized (NetworkFetcher.class) {
            local = networkFetcher;
            if (local != null) return local;
            networkFetcher = local = new NetworkFetcher(L.networkCache(context), fetcher != null ? fetcher : new DefaultLottieNetworkFetcher());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return local;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static NetworkCache networkCache(final @NonNull Context context) {
        NetworkCache local = networkCache;
        if (local != null) return local;
        Class<NetworkCache> clazz = NetworkCache.class;
        synchronized (NetworkCache.class) {
            local = networkCache;
            if (local != null) return local;
            networkCache = local = new NetworkCache(cacheProvider != null ? cacheProvider : new LottieNetworkCacheProvider(){

                @Override
                @NonNull
                public File getCacheDir() {
                    return new File(context.getCacheDir(), "lottie_network_cache");
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return local;
        }
    }

    static {
        traceDepth = 0;
        depthPastMaxDepth = 0;
    }
}

