/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Color;
import android.graphics.Rect;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTextFrame;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.AnimatableTextPropertiesParser;
import com.airbnb.lottie.parser.AnimatableTransformParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.ContentModelParser;
import com.airbnb.lottie.parser.MaskParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class LayerParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "ind", "refId", "ty", "parent", "sw", "sh", "sc", "ks", "tt", "masksProperties", "shapes", "t", "ef", "sr", "st", "w", "h", "ip", "op", "tm", "cl", "hd");
    private static final JsonReader.Options TEXT_NAMES = JsonReader.Options.of("d", "a");
    private static final JsonReader.Options EFFECTS_NAMES = JsonReader.Options.of("nm");

    private LayerParser() {
    }

    public static Layer parse(LottieComposition composition) {
        Rect bounds = composition.getBounds();
        return new Layer(Collections.emptyList(), composition, "__container", -1L, Layer.LayerType.PRE_COMP, -1L, null, Collections.emptyList(), new AnimatableTransform(), 0, 0, 0, 0.0f, 0.0f, bounds.width(), bounds.height(), null, null, Collections.emptyList(), Layer.MatteType.NONE, null, false);
    }

    public static Layer parse(JsonReader reader, LottieComposition composition) throws IOException {
        String layerName = "UNSET";
        Layer.LayerType layerType = null;
        String refId = null;
        long layerId = 0L;
        int solidWidth = 0;
        int solidHeight = 0;
        int solidColor = 0;
        int preCompWidth = 0;
        int preCompHeight = 0;
        long parentId = -1L;
        float timeStretch = 1.0f;
        float startFrame = 0.0f;
        float inFrame = 0.0f;
        float outFrame = 0.0f;
        String cl = null;
        boolean hidden = false;
        Layer.MatteType matteType = Layer.MatteType.NONE;
        AnimatableTransform transform = null;
        AnimatableTextFrame text = null;
        AnimatableTextProperties textProperties = null;
        AnimatableFloatValue timeRemapping = null;
        ArrayList<Mask> masks = new ArrayList<Mask>();
        ArrayList<ContentModel> shapes = new ArrayList<ContentModel>();
        reader.beginObject();
        block32: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    layerName = reader.nextString();
                    continue block32;
                }
                case 1: {
                    layerId = reader.nextInt();
                    continue block32;
                }
                case 2: {
                    refId = reader.nextString();
                    continue block32;
                }
                case 3: {
                    int layerTypeInt = reader.nextInt();
                    if (layerTypeInt < Layer.LayerType.UNKNOWN.ordinal()) {
                        layerType = Layer.LayerType.values()[layerTypeInt];
                        continue block32;
                    }
                    layerType = Layer.LayerType.UNKNOWN;
                    continue block32;
                }
                case 4: {
                    parentId = reader.nextInt();
                    continue block32;
                }
                case 5: {
                    solidWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block32;
                }
                case 6: {
                    solidHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block32;
                }
                case 7: {
                    solidColor = Color.parseColor((String)reader.nextString());
                    continue block32;
                }
                case 8: {
                    transform = AnimatableTransformParser.parse(reader, composition);
                    continue block32;
                }
                case 9: {
                    matteType = Layer.MatteType.values()[reader.nextInt()];
                    composition.incrementMatteOrMaskCount(1);
                    continue block32;
                }
                case 10: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        masks.add(MaskParser.parse(reader, composition));
                    }
                    composition.incrementMatteOrMaskCount(masks.size());
                    reader.endArray();
                    continue block32;
                }
                case 11: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        ContentModel shape = ContentModelParser.parse(reader, composition);
                        if (shape == null) continue;
                        shapes.add(shape);
                    }
                    reader.endArray();
                    continue block32;
                }
                case 12: {
                    reader.beginObject();
                    block35: while (reader.hasNext()) {
                        switch (reader.selectName(TEXT_NAMES)) {
                            case 0: {
                                text = AnimatableValueParser.parseDocumentData(reader, composition);
                                continue block35;
                            }
                            case 1: {
                                reader.beginArray();
                                if (reader.hasNext()) {
                                    textProperties = AnimatableTextPropertiesParser.parse(reader, composition);
                                }
                                while (reader.hasNext()) {
                                    reader.skipValue();
                                }
                                reader.endArray();
                                continue block35;
                            }
                        }
                        reader.skipName();
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block32;
                }
                case 13: {
                    reader.beginArray();
                    ArrayList<String> effectNames = new ArrayList<String>();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        block38: while (reader.hasNext()) {
                            switch (reader.selectName(EFFECTS_NAMES)) {
                                case 0: {
                                    effectNames.add(reader.nextString());
                                    continue block38;
                                }
                            }
                            reader.skipName();
                            reader.skipValue();
                        }
                        reader.endObject();
                    }
                    reader.endArray();
                    composition.addWarning("Lottie doesn't support layer effects. If you are using them for  fills, strokes, trim paths etc. then try adding them directly as contents  in your shape. Found: " + effectNames);
                    continue block32;
                }
                case 14: {
                    timeStretch = (float)reader.nextDouble();
                    continue block32;
                }
                case 15: {
                    startFrame = (float)reader.nextDouble();
                    continue block32;
                }
                case 16: {
                    preCompWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block32;
                }
                case 17: {
                    preCompHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block32;
                }
                case 18: {
                    inFrame = (float)reader.nextDouble();
                    continue block32;
                }
                case 19: {
                    outFrame = (float)reader.nextDouble();
                    continue block32;
                }
                case 20: {
                    timeRemapping = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block32;
                }
                case 21: {
                    cl = reader.nextString();
                    continue block32;
                }
                case 22: {
                    hidden = reader.nextBoolean();
                    continue block32;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        inFrame /= timeStretch;
        outFrame /= timeStretch;
        ArrayList<Keyframe<Float>> inOutKeyframes = new ArrayList<Keyframe<Float>>();
        if (inFrame > 0.0f) {
            Keyframe<Float> preKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(inFrame));
            inOutKeyframes.add(preKeyframe);
        }
        outFrame = outFrame > 0.0f ? outFrame : composition.getEndFrame();
        Keyframe<Float> visibleKeyframe = new Keyframe<Float>(composition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, inFrame, Float.valueOf(outFrame));
        inOutKeyframes.add(visibleKeyframe);
        Keyframe<Float> outKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, outFrame, Float.valueOf(Float.MAX_VALUE));
        inOutKeyframes.add(outKeyframe);
        if (layerName.endsWith(".ai") || "ai".equals(cl)) {
            composition.addWarning("Convert your Illustrator layers to shape layers.");
        }
        return new Layer(shapes, composition, layerName, layerId, layerType, parentId, refId, masks, transform, solidWidth, solidHeight, solidColor, timeStretch, startFrame, preCompWidth, preCompHeight, text, textProperties, inOutKeyframes, matteType, timeRemapping, hidden);
    }
}

