/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.util.Pair;
import com.airbnb.lottie.network.FileExtension;
import com.airbnb.lottie.utils.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NetworkCache {
    private final Context appContext;

    public NetworkCache(Context appContext) {
        this.appContext = appContext.getApplicationContext();
    }

    public void clear() {
        File parentDir = this.parentDir();
        if (parentDir.exists()) {
            File[] files = parentDir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : parentDir.listFiles()) {
                    file.delete();
                }
            }
            parentDir.delete();
        }
    }

    @Nullable
    @WorkerThread
    Pair<FileExtension, InputStream> fetch(String url) {
        FileInputStream inputStream;
        File cachedFile;
        try {
            cachedFile = this.getCachedFile(url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (cachedFile == null) {
            return null;
        }
        try {
            inputStream = new FileInputStream(cachedFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        FileExtension extension = cachedFile.getAbsolutePath().endsWith(".zip") ? FileExtension.ZIP : FileExtension.JSON;
        Logger.debug("Cache hit for " + url + " at " + cachedFile.getAbsolutePath());
        return new Pair((Object)extension, (Object)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File writeTempCacheFile(String url, InputStream stream, FileExtension extension) throws IOException {
        String fileName = NetworkCache.filenameForUrl(url, extension, true);
        File file = new File(this.parentDir(), fileName);
        try (FileOutputStream output = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, read);
            }
            output.flush();
        }
        finally {
            stream.close();
        }
        return file;
    }

    void renameTempFile(String url, FileExtension extension) {
        String fileName = NetworkCache.filenameForUrl(url, extension, true);
        File file = new File(this.parentDir(), fileName);
        String newFileName = file.getAbsolutePath().replace(".temp", "");
        File newFile = new File(newFileName);
        boolean renamed = file.renameTo(newFile);
        Logger.debug("Copying temp file to real file (" + newFile + ")");
        if (!renamed) {
            Logger.warning("Unable to rename cache file " + file.getAbsolutePath() + " to " + newFile.getAbsolutePath() + ".");
        }
    }

    @Nullable
    private File getCachedFile(String url) throws FileNotFoundException {
        File jsonFile = new File(this.parentDir(), NetworkCache.filenameForUrl(url, FileExtension.JSON, false));
        if (jsonFile.exists()) {
            return jsonFile;
        }
        File zipFile = new File(this.parentDir(), NetworkCache.filenameForUrl(url, FileExtension.ZIP, false));
        if (zipFile.exists()) {
            return zipFile;
        }
        return null;
    }

    private File parentDir() {
        File file = new File(this.appContext.getCacheDir(), "lottie_network_cache");
        if (file.isFile()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static String filenameForUrl(String url, FileExtension extension, boolean isTemp) {
        return "lottie_cache_" + url.replaceAll("\\W+", "") + (isTemp ? extension.tempExtension() : extension.extension);
    }
}

