/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.annotation.WorkerThread;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieListener;
import com.airbnb.lottie.LottieResult;
import com.airbnb.lottie.LottieTask;
import com.airbnb.lottie.model.LottieCompositionCache;
import com.airbnb.lottie.network.NetworkFetcher;
import com.airbnb.lottie.parser.LottieCompositionMoshiParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okio.Okio;
import okio.Source;
import org.json.JSONObject;

public class LottieCompositionFactory {
    private static final Map<String, LottieTask<LottieComposition>> taskCache = new HashMap<String, LottieTask<LottieComposition>>();

    private LottieCompositionFactory() {
    }

    public static void setMaxCacheSize(int size) {
        LottieCompositionCache.getInstance().resize(size);
    }

    public static LottieTask<LottieComposition> fromUrl(final Context context, final String url) {
        String urlCacheKey = "url_" + url;
        return LottieCompositionFactory.cache(urlCacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return NetworkFetcher.fetchSync(context, url);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromUrlSync(Context context, String url) {
        return NetworkFetcher.fetchSync(context, url);
    }

    public static LottieTask<LottieComposition> fromAsset(Context context, final String fileName) {
        final Context appContext = context.getApplicationContext();
        return LottieCompositionFactory.cache(fileName, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromAssetSync(appContext, fileName);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromAssetSync(Context context, String fileName) {
        try {
            String cacheKey = "asset_" + fileName;
            if (fileName.endsWith(".zip")) {
                return LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(context.getAssets().open(fileName)), cacheKey);
            }
            return LottieCompositionFactory.fromJsonInputStreamSync(context.getAssets().open(fileName), cacheKey);
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    public static LottieTask<LottieComposition> fromRawRes(Context context, final @RawRes int rawRes) {
        final WeakReference<Context> contextRef = new WeakReference<Context>(context);
        final Context appContext = context.getApplicationContext();
        return LottieCompositionFactory.cache(LottieCompositionFactory.rawResCacheKey(context, rawRes), new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                Context originalContext = (Context)contextRef.get();
                Context context = originalContext != null ? originalContext : appContext;
                return LottieCompositionFactory.fromRawResSync(context, rawRes);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromRawResSync(Context context, @RawRes int rawRes) {
        try {
            return LottieCompositionFactory.fromJsonInputStreamSync(context.getResources().openRawResource(rawRes), LottieCompositionFactory.rawResCacheKey(context, rawRes));
        }
        catch (Resources.NotFoundException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    private static String rawResCacheKey(Context context, @RawRes int resId) {
        return "rawRes" + (LottieCompositionFactory.isNightMode(context) ? "_night_" : "_day_") + resId;
    }

    private static boolean isNightMode(Context context) {
        int nightModeMasked = context.getResources().getConfiguration().uiMode & 0x30;
        return nightModeMasked == 32;
    }

    public static LottieTask<LottieComposition> fromJsonInputStream(final InputStream stream, final @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromJsonInputStreamSync(stream, cacheKey);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonInputStreamSync(InputStream stream, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonInputStreamSync(stream, cacheKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private static LottieResult<LottieComposition> fromJsonInputStreamSync(InputStream stream, @Nullable String cacheKey, boolean close) {
        try {
            LottieResult<LottieComposition> lottieResult = LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)stream))), cacheKey);
            return lottieResult;
        }
        finally {
            if (close) {
                Utils.closeQuietly(stream);
            }
        }
    }

    @Deprecated
    public static LottieTask<LottieComposition> fromJson(final JSONObject json, final @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromJsonSync(json, cacheKey);
            }
        });
    }

    @Deprecated
    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonSync(JSONObject json, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonStringSync(json.toString(), cacheKey);
    }

    public static LottieTask<LottieComposition> fromJsonString(final String json, final @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromJsonStringSync(json, cacheKey);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonStringSync(String json, @Nullable String cacheKey) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes());
        return LottieCompositionFactory.fromJsonReaderSync(JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)stream))), cacheKey);
    }

    public static LottieTask<LottieComposition> fromJsonReader(final JsonReader reader, final @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromJsonReaderSync(reader, cacheKey);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromJsonReaderSync(JsonReader reader, @Nullable String cacheKey) {
        return LottieCompositionFactory.fromJsonReaderSyncInternal(reader, cacheKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LottieResult<LottieComposition> fromJsonReaderSyncInternal(JsonReader reader, @Nullable String cacheKey, boolean close) {
        try {
            LottieComposition composition = LottieCompositionMoshiParser.parse(reader);
            if (cacheKey != null) {
                LottieCompositionCache.getInstance().put(cacheKey, composition);
            }
            LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(composition);
            return lottieResult;
        }
        catch (Exception e) {
            LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(e);
            return lottieResult;
        }
        finally {
            if (close) {
                Utils.closeQuietly(reader);
            }
        }
    }

    public static LottieTask<LottieComposition> fromZipStream(final ZipInputStream inputStream, final @Nullable String cacheKey) {
        return LottieCompositionFactory.cache(cacheKey, new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() {
                return LottieCompositionFactory.fromZipStreamSync(inputStream, cacheKey);
            }
        });
    }

    @WorkerThread
    public static LottieResult<LottieComposition> fromZipStreamSync(ZipInputStream inputStream, @Nullable String cacheKey) {
        try {
            LottieResult<LottieComposition> lottieResult = LottieCompositionFactory.fromZipStreamSyncInternal(inputStream, cacheKey);
            return lottieResult;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    @WorkerThread
    private static LottieResult<LottieComposition> fromZipStreamSyncInternal(ZipInputStream inputStream, @Nullable String cacheKey) {
        LottieComposition composition = null;
        HashMap<String, Bitmap> images = new HashMap<String, Bitmap>();
        try {
            ZipEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                String string = entry.getName();
                if (string.contains("__MACOSX")) {
                    inputStream.closeEntry();
                } else if (entry.getName().contains(".json")) {
                    JsonReader reader = JsonReader.of(Okio.buffer((Source)Okio.source((InputStream)inputStream)));
                    composition = LottieCompositionFactory.fromJsonReaderSyncInternal(reader, null, false).getValue();
                } else if (string.contains(".png") || string.contains(".webp")) {
                    String[] splitName = string.split("/");
                    String name = splitName[splitName.length - 1];
                    images.put(name, BitmapFactory.decodeStream((InputStream)inputStream));
                } else {
                    inputStream.closeEntry();
                }
                entry = inputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
        if (composition == null) {
            return new LottieResult<LottieComposition>(new IllegalArgumentException("Unable to parse composition"));
        }
        for (Map.Entry entry : images.entrySet()) {
            LottieImageAsset imageAsset = LottieCompositionFactory.findImageAssetForFileName(composition, (String)entry.getKey());
            if (imageAsset == null) continue;
            imageAsset.setBitmap(Utils.resizeBitmapIfNeeded((Bitmap)entry.getValue(), imageAsset.getWidth(), imageAsset.getHeight()));
        }
        for (Map.Entry<Object, Object> entry : composition.getImages().entrySet()) {
            if (((LottieImageAsset)entry.getValue()).getBitmap() != null) continue;
            return new LottieResult<LottieComposition>(new IllegalStateException("There is no image for " + ((LottieImageAsset)entry.getValue()).getFileName()));
        }
        if (cacheKey != null) {
            LottieCompositionCache.getInstance().put(cacheKey, composition);
        }
        return new LottieResult<LottieComposition>(composition);
    }

    @Nullable
    private static LottieImageAsset findImageAssetForFileName(LottieComposition composition, String fileName) {
        for (LottieImageAsset asset : composition.getImages().values()) {
            if (!asset.getFileName().equals(fileName)) continue;
            return asset;
        }
        return null;
    }

    private static LottieTask<LottieComposition> cache(final @Nullable String cacheKey, Callable<LottieResult<LottieComposition>> callable) {
        LottieComposition cachedComposition;
        LottieComposition lottieComposition = cachedComposition = cacheKey == null ? null : LottieCompositionCache.getInstance().get(cacheKey);
        if (cachedComposition != null) {
            return new LottieTask<LottieComposition>(new Callable<LottieResult<LottieComposition>>(){

                @Override
                public LottieResult<LottieComposition> call() {
                    return new LottieResult<LottieComposition>(cachedComposition);
                }
            });
        }
        if (cacheKey != null && taskCache.containsKey(cacheKey)) {
            return taskCache.get(cacheKey);
        }
        LottieTask<LottieComposition> task = new LottieTask<LottieComposition>(callable);
        task.addListener(new LottieListener<LottieComposition>(){

            @Override
            public void onResult(LottieComposition result) {
                taskCache.remove(cacheKey);
            }
        });
        task.addFailureListener(new LottieListener<Throwable>(){

            @Override
            public void onResult(Throwable result) {
                taskCache.remove(cacheKey);
            }
        });
        taskCache.put(cacheKey, task);
        return task;
    }
}

