/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Rect;
import androidx.collection.LongSparseArray;
import androidx.collection.SparseArrayCompat;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.Marker;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LottieCompositionParser {
    static JsonReader.Options NAMES = JsonReader.Options.of("w", "h", "ip", "op", "fr", "v", "layers", "assets", "fonts", "chars", "markers");

    public static LottieComposition parse(JsonReader reader) throws IOException {
        float scale = Utils.dpScale();
        float startFrame = 0.0f;
        float endFrame = 0.0f;
        float frameRate = 0.0f;
        LongSparseArray layerMap = new LongSparseArray();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        int width = 0;
        int height = 0;
        HashMap<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
        HashMap<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
        HashMap<String, Font> fonts = new HashMap<String, Font>();
        ArrayList<Marker> markers = new ArrayList<Marker>();
        SparseArrayCompat characters = new SparseArrayCompat();
        LottieComposition composition = new LottieComposition();
        reader.beginObject();
        block9: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    width = reader.nextInt();
                    continue block9;
                }
                case 1: {
                    height = reader.nextInt();
                    continue block9;
                }
                case 2: {
                    startFrame = (float)reader.nextDouble();
                    continue block9;
                }
                case 3: {
                    endFrame = (float)reader.nextDouble() - 0.01f;
                    continue block9;
                }
                case 4: {
                    frameRate = (float)reader.nextDouble();
                    continue block9;
                }
                case 5: {
                    int patchVersion;
                    int minorVersion;
                    String version = reader.nextString();
                    String[] versions = version.split("\\.");
                    int majorVersion = Integer.parseInt(versions[0]);
                    if (Utils.isAtLeastVersion(majorVersion, minorVersion = Integer.parseInt(versions[1]), patchVersion = Integer.parseInt(versions[2]), 4, 4, 0)) continue block9;
                    composition.addWarning("Lottie only supports bodymovin >= 4.4.0");
                    continue block9;
                }
                case 6: {
                    LottieCompositionParser.parseLayers(reader, composition, layers, (LongSparseArray<Layer>)layerMap);
                }
            }
            reader.skipValue();
        }
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        Rect bounds = new Rect(0, 0, scaledWidth, scaledHeight);
        composition.init(bounds, startFrame, endFrame, frameRate, layers, (LongSparseArray<Layer>)layerMap, precomps, images, (SparseArrayCompat<FontCharacter>)characters, fonts, markers);
        return composition;
    }

    private static void parseLayers(JsonReader reader, LottieComposition composition, List<Layer> layers, LongSparseArray<Layer> layerMap) throws IOException {
        int imageCount = 0;
        reader.beginArray();
        while (reader.hasNext()) {
            Layer layer = LayerParser.parse(reader, composition);
            if (layer.getLayerType() == Layer.LayerType.IMAGE) {
                ++imageCount;
            }
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
            if (imageCount <= 4) continue;
            Logger.warning("You have " + imageCount + " images. Lottie should primarily be used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers to shape layers.");
        }
        reader.endArray();
    }
}

