/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Matrix;
import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.ScaleXY;
import java.util.Collections;

public class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final Matrix skewMatrix1;
    private final Matrix skewMatrix2;
    private final Matrix skewMatrix3;
    private final float[] skewValues;
    @NonNull
    private BaseKeyframeAnimation<PointF, PointF> anchorPoint;
    @NonNull
    private BaseKeyframeAnimation<?, PointF> position;
    @NonNull
    private BaseKeyframeAnimation<ScaleXY, ScaleXY> scale;
    @NonNull
    private BaseKeyframeAnimation<Float, Float> rotation;
    @NonNull
    private BaseKeyframeAnimation<Integer, Integer> opacity;
    @Nullable
    private FloatKeyframeAnimation skew;
    @Nullable
    private FloatKeyframeAnimation skewAngle;
    @Nullable
    private BaseKeyframeAnimation<?, Float> startOpacity;
    @Nullable
    private BaseKeyframeAnimation<?, Float> endOpacity;

    public TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint() == null ? null : animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition() == null ? null : animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale() == null ? null : animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation() == null ? null : animatableTransform.getRotation().createAnimation();
        FloatKeyframeAnimation floatKeyframeAnimation = this.skew = animatableTransform.getSkew() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkew().createAnimation();
        if (this.skew != null) {
            this.skewMatrix1 = new Matrix();
            this.skewMatrix2 = new Matrix();
            this.skewMatrix3 = new Matrix();
            this.skewValues = new float[9];
        } else {
            this.skewMatrix1 = null;
            this.skewMatrix2 = null;
            this.skewMatrix3 = null;
            this.skewValues = null;
        }
        FloatKeyframeAnimation floatKeyframeAnimation2 = this.skewAngle = animatableTransform.getSkewAngle() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkewAngle().createAnimation();
        if (animatableTransform.getOpacity() != null) {
            this.opacity = animatableTransform.getOpacity().createAnimation();
        }
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    public void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.opacity);
        layer.addAnimation(this.startOpacity);
        layer.addAnimation(this.endOpacity);
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        layer.addAnimation(this.skew);
        layer.addAnimation(this.skewAngle);
    }

    public void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        if (this.opacity != null) {
            this.opacity.addUpdateListener(listener);
        }
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(listener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(listener);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.addUpdateListener(listener);
        }
        if (this.position != null) {
            this.position.addUpdateListener(listener);
        }
        if (this.scale != null) {
            this.scale.addUpdateListener(listener);
        }
        if (this.rotation != null) {
            this.rotation.addUpdateListener(listener);
        }
        if (this.skew != null) {
            this.skew.addUpdateListener(listener);
        }
        if (this.skewAngle != null) {
            this.skewAngle.addUpdateListener(listener);
        }
    }

    public void setProgress(float progress) {
        if (this.opacity != null) {
            this.opacity.setProgress(progress);
        }
        if (this.startOpacity != null) {
            this.startOpacity.setProgress(progress);
        }
        if (this.endOpacity != null) {
            this.endOpacity.setProgress(progress);
        }
        if (this.anchorPoint != null) {
            this.anchorPoint.setProgress(progress);
        }
        if (this.position != null) {
            this.position.setProgress(progress);
        }
        if (this.scale != null) {
            this.scale.setProgress(progress);
        }
        if (this.rotation != null) {
            this.rotation.setProgress(progress);
        }
        if (this.skew != null) {
            this.skew.setProgress(progress);
        }
        if (this.skewAngle != null) {
            this.skewAngle.setProgress(progress);
        }
    }

    @Nullable
    public BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getEndOpacity() {
        return this.endOpacity;
    }

    public Matrix getMatrix() {
        ScaleXY scaleTransform;
        float rotation;
        this.matrix.reset();
        if (this.position != null) {
            PointF position = this.position.getValue();
            if (position.x != 0.0f || position.y != 0.0f) {
                this.matrix.preTranslate(position.x, position.y);
            }
        }
        if (this.rotation != null && (rotation = this.rotation instanceof ValueCallbackKeyframeAnimation ? this.rotation.getValue().floatValue() : ((FloatKeyframeAnimation)this.rotation).getFloatValue()) != 0.0f) {
            this.matrix.preRotate(rotation);
        }
        if (this.skew != null) {
            float mCos = this.skewAngle == null ? 0.0f : (float)Math.cos(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float mSin = this.skewAngle == null ? 1.0f : (float)Math.sin(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float aTan = (float)Math.tan(Math.toRadians(this.skew.getFloatValue()));
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = mSin;
            this.skewValues[3] = -mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix1.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = 1.0f;
            this.skewValues[3] = aTan;
            this.skewValues[4] = 1.0f;
            this.skewValues[8] = 1.0f;
            this.skewMatrix2.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = -mSin;
            this.skewValues[3] = mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix3.setValues(this.skewValues);
            this.skewMatrix2.preConcat(this.skewMatrix1);
            this.skewMatrix3.preConcat(this.skewMatrix2);
            this.matrix.preConcat(this.skewMatrix3);
        }
        if (this.scale != null && ((scaleTransform = this.scale.getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f)) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        if (this.anchorPoint != null) {
            PointF anchorPoint = this.anchorPoint.getValue();
            if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
                this.matrix.preTranslate(-anchorPoint.x, -anchorPoint.y);
            }
        }
        return this.matrix;
    }

    private void clearSkewValues() {
        for (int i = 0; i < 9; ++i) {
            this.skewValues[i] = 0.0f;
        }
    }

    public Matrix getMatrixForRepeater(float amount) {
        PointF position = this.position == null ? null : this.position.getValue();
        ScaleXY scale = this.scale == null ? null : this.scale.getValue();
        this.matrix.reset();
        if (position != null) {
            this.matrix.preTranslate(position.x * amount, position.y * amount);
        }
        if (scale != null) {
            this.matrix.preScale((float)Math.pow(scale.getScaleX(), amount), (float)Math.pow(scale.getScaleY(), amount));
        }
        if (this.rotation != null) {
            float rotation = this.rotation.getValue().floatValue();
            PointF anchorPoint = this.anchorPoint == null ? null : this.anchorPoint.getValue();
            this.matrix.preRotate(rotation * amount, anchorPoint == null ? 0.0f : anchorPoint.x, anchorPoint == null ? 0.0f : anchorPoint.y);
        }
        return this.matrix;
    }

    public <T> boolean applyValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.TRANSFORM_ANCHOR_POINT) {
            if (this.anchorPoint == null) {
                this.anchorPoint = new ValueCallbackKeyframeAnimation<PointF, PointF>(callback, new PointF());
            } else {
                this.anchorPoint.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_POSITION) {
            if (this.position == null) {
                this.position = new ValueCallbackKeyframeAnimation(callback, new PointF());
            } else {
                this.position.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_SCALE) {
            if (this.scale == null) {
                this.scale = new ValueCallbackKeyframeAnimation<ScaleXY, ScaleXY>(callback, new ScaleXY());
            } else {
                this.scale.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_ROTATION) {
            if (this.rotation == null) {
                this.rotation = new ValueCallbackKeyframeAnimation<Float, Float>(callback, Float.valueOf(0.0f));
            } else {
                this.rotation.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_OPACITY) {
            if (this.opacity == null) {
                this.opacity = new ValueCallbackKeyframeAnimation<Integer, Integer>(callback, 100);
            } else {
                this.opacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_START_OPACITY && this.startOpacity != null) {
            if (this.startOpacity == null) {
                this.startOpacity = new ValueCallbackKeyframeAnimation(callback, 100);
            } else {
                this.startOpacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_END_OPACITY && this.endOpacity != null) {
            if (this.endOpacity == null) {
                this.endOpacity = new ValueCallbackKeyframeAnimation(callback, 100);
            } else {
                this.endOpacity.setValueCallback(callback);
            }
        } else if (property == LottieProperty.TRANSFORM_SKEW && this.skew != null) {
            if (this.skew == null) {
                this.skew = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.skew.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SKEW_ANGLE && this.skewAngle != null) {
            if (this.skewAngle == null) {
                this.skewAngle = new FloatKeyframeAnimation(Collections.singletonList(new Keyframe<Float>(Float.valueOf(0.0f))));
            }
            this.skewAngle.setValueCallback(callback);
        } else {
            return false;
        }
        return true;
    }
}

