/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.JsonReader;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.collection.LongSparseArray;
import androidx.collection.SparseArrayCompat;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.LottieCompositionFactory;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieListener;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.Marker;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LottieComposition {
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    private final HashSet<String> warnings = new HashSet();
    private Map<String, List<Layer>> precomps;
    private Map<String, LottieImageAsset> images;
    private Map<String, Font> fonts;
    private List<Marker> markers;
    private SparseArrayCompat<FontCharacter> characters;
    private LongSparseArray<Layer> layerMap;
    private List<Layer> layers;
    private Rect bounds;
    private float startFrame;
    private float endFrame;
    private float frameRate;
    private boolean hasDashPattern;
    private int maskAndMatteCount = 0;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void init(Rect bounds, float startFrame, float endFrame, float frameRate, List<Layer> layers, LongSparseArray<Layer> layerMap, Map<String, List<Layer>> precomps, Map<String, LottieImageAsset> images, SparseArrayCompat<FontCharacter> characters, Map<String, Font> fonts, List<Marker> markers) {
        this.bounds = bounds;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.frameRate = frameRate;
        this.layers = layers;
        this.layerMap = layerMap;
        this.precomps = precomps;
        this.images = images;
        this.characters = characters;
        this.fonts = fonts;
        this.markers = markers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addWarning(String warning) {
        Logger.warning(warning);
        this.warnings.add(warning);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setHasDashPattern(boolean hasDashPattern) {
        this.hasDashPattern = hasDashPattern;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void incrementMatteOrMaskCount(int amount) {
        this.maskAndMatteCount += amount;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean hasDashPattern() {
        return this.hasDashPattern;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getMaskAndMatteCount() {
        return this.maskAndMatteCount;
    }

    public ArrayList<String> getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTracker.setEnabled(enabled);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public float getDuration() {
        return (long)(this.getDurationFrames() / this.frameRate * 1000.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getStartFrame() {
        return this.startFrame;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getEndFrame() {
        return this.endFrame;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    public SparseArrayCompat<FontCharacter> getCharacters() {
        return this.characters;
    }

    public Map<String, Font> getFonts() {
        return this.fonts;
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    @Nullable
    public Marker getMarker(String markerName) {
        int size = this.markers.size();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (!marker.matchesName(markerName)) continue;
            return marker;
        }
        return null;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public Map<String, LottieImageAsset> getImages() {
        return this.images;
    }

    public float getDurationFrames() {
        return this.endFrame - this.startFrame;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    @Deprecated
    public static class Factory {
        private Factory() {
        }

        @Deprecated
        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener l) {
            ListenerAdapter listener = new ListenerAdapter(l);
            LottieCompositionFactory.fromAsset(context, fileName).addListener(listener);
            return listener;
        }

        @Deprecated
        public static Cancellable fromRawFile(Context context, @RawRes int resId, OnCompositionLoadedListener l) {
            ListenerAdapter listener = new ListenerAdapter(l);
            LottieCompositionFactory.fromRawRes(context, resId).addListener(listener);
            return listener;
        }

        @Deprecated
        public static Cancellable fromInputStream(InputStream stream, OnCompositionLoadedListener l) {
            ListenerAdapter listener = new ListenerAdapter(l);
            LottieCompositionFactory.fromJsonInputStream(stream, null).addListener(listener);
            return listener;
        }

        @Deprecated
        public static Cancellable fromJsonString(String jsonString, OnCompositionLoadedListener l) {
            ListenerAdapter listener = new ListenerAdapter(l);
            LottieCompositionFactory.fromJsonString(jsonString, null).addListener(listener);
            return listener;
        }

        @Deprecated
        public static Cancellable fromJsonReader(JsonReader reader, OnCompositionLoadedListener l) {
            ListenerAdapter listener = new ListenerAdapter(l);
            LottieCompositionFactory.fromJsonReader(reader, null).addListener(listener);
            return listener;
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromFileSync(Context context, String fileName) {
            return LottieCompositionFactory.fromAssetSync(context, fileName).getValue();
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromInputStreamSync(InputStream stream) {
            return LottieCompositionFactory.fromJsonInputStreamSync(stream, null).getValue();
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromInputStreamSync(InputStream stream, boolean close) {
            if (close) {
                Logger.warning("Lottie now auto-closes input stream!");
            }
            return LottieCompositionFactory.fromJsonInputStreamSync(stream, null).getValue();
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromJsonSync(Resources res, JSONObject json) {
            return LottieCompositionFactory.fromJsonSync(json, null).getValue();
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromJsonSync(String json) {
            return LottieCompositionFactory.fromJsonStringSync(json, null).getValue();
        }

        @Deprecated
        @Nullable
        @WorkerThread
        public static LottieComposition fromJsonSync(JsonReader reader) throws IOException {
            return LottieCompositionFactory.fromJsonReaderSync(reader, null).getValue();
        }

        private static final class ListenerAdapter
        implements LottieListener<LottieComposition>,
        Cancellable {
            private final OnCompositionLoadedListener listener;
            private boolean cancelled = false;

            private ListenerAdapter(OnCompositionLoadedListener listener) {
                this.listener = listener;
            }

            @Override
            public void onResult(LottieComposition composition) {
                if (this.cancelled) {
                    return;
                }
                this.listener.onCompositionLoaded(composition);
            }

            @Override
            public void cancel() {
                this.cancelled = true;
            }
        }
    }
}

