/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.support.annotation.FloatRange;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.Choreographer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.utils.BaseLottieAnimator;
import com.airbnb.lottie.utils.MiscUtils;

public class LottieValueAnimator
extends BaseLottieAnimator
implements Choreographer.FrameCallback {
    private float speed = 1.0f;
    private boolean speedReversedForRepeatMode = false;
    private long lastFrameTimeNs = 0L;
    private float frame = 0.0f;
    private int repeatCount = 0;
    private float minFrame = -2.1474836E9f;
    private float maxFrame = 2.1474836E9f;
    @Nullable
    private LottieComposition composition;
    @VisibleForTesting
    protected boolean running = false;

    public Object getAnimatedValue() {
        return Float.valueOf(this.getAnimatedValueAbsolute());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedValueAbsolute() {
        if (this.composition == null) {
            return 0.0f;
        }
        return (this.frame - this.composition.getStartFrame()) / (this.composition.getEndFrame() - this.composition.getStartFrame());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedFraction() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.isReversed()) {
            return (this.getMaxFrame() - this.frame) / (this.getMaxFrame() - this.getMinFrame());
        }
        return (this.frame - this.getMinFrame()) / (this.getMaxFrame() - this.getMinFrame());
    }

    public long getDuration() {
        return this.composition == null ? 0L : (long)this.composition.getDuration();
    }

    public float getFrame() {
        return this.frame;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void doFrame(long frameTimeNanos) {
        this.postFrameCallback();
        if (this.composition == null || !this.isRunning()) {
            return;
        }
        long now = frameTimeNanos;
        long timeSinceFrame = this.lastFrameTimeNs == 0L ? 0L : now - this.lastFrameTimeNs;
        float frameDuration = this.getFrameDurationNs();
        float dFrames = (float)timeSinceFrame / frameDuration;
        this.frame += this.isReversed() ? -dFrames : dFrames;
        boolean ended = !MiscUtils.contains(this.frame, this.getMinFrame(), this.getMaxFrame());
        this.frame = MiscUtils.clamp(this.frame, this.getMinFrame(), this.getMaxFrame());
        this.lastFrameTimeNs = now;
        this.notifyUpdate();
        if (ended) {
            if (this.getRepeatCount() != -1 && this.repeatCount >= this.getRepeatCount()) {
                this.frame = this.speed < 0.0f ? this.getMinFrame() : this.getMaxFrame();
                this.removeFrameCallback();
                this.notifyEnd(this.isReversed());
            } else {
                this.notifyRepeat();
                ++this.repeatCount;
                if (this.getRepeatMode() == 2) {
                    this.speedReversedForRepeatMode = !this.speedReversedForRepeatMode;
                    this.reverseAnimationSpeed();
                } else {
                    this.frame = this.isReversed() ? this.getMaxFrame() : this.getMinFrame();
                }
                this.lastFrameTimeNs = now;
            }
        }
        this.verifyFrame();
    }

    private float getFrameDurationNs() {
        if (this.composition == null) {
            return Float.MAX_VALUE;
        }
        return 1.0E9f / this.composition.getFrameRate() / Math.abs(this.speed);
    }

    public void clearComposition() {
        this.composition = null;
        this.minFrame = -2.1474836E9f;
        this.maxFrame = 2.1474836E9f;
    }

    public void setComposition(LottieComposition composition) {
        boolean keepMinAndMaxFrames = this.composition == null;
        this.composition = composition;
        if (keepMinAndMaxFrames) {
            this.setMinAndMaxFrames((int)Math.max(this.minFrame, composition.getStartFrame()), (int)Math.min(this.maxFrame, composition.getEndFrame()));
        } else {
            this.setMinAndMaxFrames((int)composition.getStartFrame(), (int)composition.getEndFrame());
        }
        float frame = this.frame;
        this.frame = 0.0f;
        this.setFrame((int)frame);
    }

    public void setFrame(int frame) {
        if (this.frame == (float)frame) {
            return;
        }
        this.frame = MiscUtils.clamp((float)frame, this.getMinFrame(), this.getMaxFrame());
        this.lastFrameTimeNs = 0L;
        this.notifyUpdate();
    }

    public void setMinFrame(int minFrame) {
        this.setMinAndMaxFrames(minFrame, (int)this.maxFrame);
    }

    public void setMaxFrame(float maxFrame) {
        this.setMinAndMaxFrames(this.minFrame, maxFrame);
    }

    public void setMinAndMaxFrames(float minFrame, float maxFrame) {
        if (minFrame > maxFrame) {
            throw new IllegalArgumentException(String.format("minFrame (%s) must be <= maxFrame (%s)", Float.valueOf(minFrame), Float.valueOf(maxFrame)));
        }
        float compositionMinFrame = this.composition == null ? -3.4028235E38f : this.composition.getStartFrame();
        float compositionMaxFrame = this.composition == null ? Float.MAX_VALUE : this.composition.getEndFrame();
        this.minFrame = MiscUtils.clamp(minFrame, compositionMinFrame, compositionMaxFrame);
        this.maxFrame = MiscUtils.clamp(maxFrame, compositionMinFrame, compositionMaxFrame);
        this.setFrame((int)MiscUtils.clamp(this.frame, minFrame, maxFrame));
    }

    public void reverseAnimationSpeed() {
        this.setSpeed(-this.getSpeed());
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setRepeatMode(int value) {
        super.setRepeatMode(value);
        if (value != 2 && this.speedReversedForRepeatMode) {
            this.speedReversedForRepeatMode = false;
            this.reverseAnimationSpeed();
        }
    }

    @MainThread
    public void playAnimation() {
        this.running = true;
        this.notifyStart(this.isReversed());
        this.setFrame((int)(this.isReversed() ? this.getMaxFrame() : this.getMinFrame()));
        this.lastFrameTimeNs = 0L;
        this.repeatCount = 0;
        this.postFrameCallback();
    }

    @MainThread
    public void endAnimation() {
        this.removeFrameCallback();
        this.notifyEnd(this.isReversed());
    }

    @MainThread
    public void pauseAnimation() {
        this.removeFrameCallback();
    }

    @MainThread
    public void resumeAnimation() {
        this.running = true;
        this.postFrameCallback();
        this.lastFrameTimeNs = 0L;
        if (this.isReversed() && this.getFrame() == this.getMinFrame()) {
            this.frame = this.getMaxFrame();
        } else if (!this.isReversed() && this.getFrame() == this.getMaxFrame()) {
            this.frame = this.getMinFrame();
        }
    }

    @MainThread
    public void cancel() {
        this.notifyCancel();
        this.removeFrameCallback();
    }

    private boolean isReversed() {
        return this.getSpeed() < 0.0f;
    }

    public float getMinFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.minFrame == -2.1474836E9f ? this.composition.getStartFrame() : this.minFrame;
    }

    public float getMaxFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.maxFrame == 2.1474836E9f ? this.composition.getEndFrame() : this.maxFrame;
    }

    protected void postFrameCallback() {
        if (this.isRunning()) {
            this.removeFrameCallback(false);
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    @MainThread
    protected void removeFrameCallback() {
        this.removeFrameCallback(true);
    }

    @MainThread
    protected void removeFrameCallback(boolean stopRunning) {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        if (stopRunning) {
            this.running = false;
        }
    }

    private void verifyFrame() {
        if (this.composition == null) {
            return;
        }
        if (this.frame < this.minFrame || this.frame > this.maxFrame) {
            throw new IllegalStateException(String.format("Frame must be [%f,%f]. It is %f", Float.valueOf(this.minFrame), Float.valueOf(this.maxFrame), Float.valueOf(this.frame)));
        }
    }
}

