/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.MaskKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.KeyPathElement;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.content.ShapeData;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.model.layer.ImageLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.model.layer.NullLayer;
import com.airbnb.lottie.model.layer.ShapeLayer;
import com.airbnb.lottie.model.layer.SolidLayer;
import com.airbnb.lottie.model.layer.TextLayer;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseLayer
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener,
KeyPathElement {
    private static final int CLIP_SAVE_FLAG = 2;
    private static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    private static final int MATRIX_SAVE_FLAG = 1;
    private static final int SAVE_FLAGS = 19;
    private final Path path = new Path();
    private final Matrix matrix = new Matrix();
    private final Paint contentPaint = new LPaint(1);
    private final Paint dstInPaint = new LPaint(1, PorterDuff.Mode.DST_IN);
    private final Paint dstOutPaint = new LPaint(1, PorterDuff.Mode.DST_OUT);
    private final Paint mattePaint = new LPaint(1);
    private final Paint clearPaint = new LPaint(PorterDuff.Mode.CLEAR);
    private final RectF rect = new RectF();
    private final RectF maskBoundsRect = new RectF();
    private final RectF matteBoundsRect = new RectF();
    private final RectF tempMaskBoundsRect = new RectF();
    private final String drawTraceName;
    final Matrix boundsMatrix = new Matrix();
    final LottieDrawable lottieDrawable;
    final Layer layerModel;
    @Nullable
    private MaskKeyframeAnimation mask;
    @Nullable
    private BaseLayer matteLayer;
    @Nullable
    private BaseLayer parentLayer;
    private List<BaseLayer> parentLayers;
    private final List<BaseKeyframeAnimation<?, ?>> animations = new ArrayList();
    final TransformKeyframeAnimation transform;
    private boolean visible = true;

    @Nullable
    static BaseLayer forModel(Layer layerModel, LottieDrawable drawable, LottieComposition composition) {
        switch (layerModel.getLayerType()) {
            case SHAPE: {
                return new ShapeLayer(drawable, layerModel);
            }
            case PRE_COMP: {
                return new CompositionLayer(drawable, layerModel, composition.getPrecomps(layerModel.getRefId()), composition);
            }
            case SOLID: {
                return new SolidLayer(drawable, layerModel);
            }
            case IMAGE: {
                return new ImageLayer(drawable, layerModel);
            }
            case NULL: {
                return new NullLayer(drawable, layerModel);
            }
            case TEXT: {
                return new TextLayer(drawable, layerModel);
            }
        }
        Logger.warning("Unknown layer type " + (Object)((Object)layerModel.getLayerType()));
        return null;
    }

    BaseLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        this.lottieDrawable = lottieDrawable;
        this.layerModel = layerModel;
        this.drawTraceName = layerModel.getName() + "#draw";
        if (layerModel.getMatteType() == Layer.MatteType.INVERT) {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        } else {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        }
        this.transform = layerModel.getTransform().createAnimation();
        this.transform.addListener(this);
        if (layerModel.getMasks() != null && !layerModel.getMasks().isEmpty()) {
            this.mask = new MaskKeyframeAnimation(layerModel.getMasks());
            for (BaseKeyframeAnimation<ShapeData, Path> baseKeyframeAnimation : this.mask.getMaskAnimations()) {
                baseKeyframeAnimation.addUpdateListener(this);
            }
            for (BaseKeyframeAnimation<Object, Object> baseKeyframeAnimation : this.mask.getOpacityAnimations()) {
                this.addAnimation(baseKeyframeAnimation);
                baseKeyframeAnimation.addUpdateListener(this);
            }
        }
        this.setupInOutAnimations();
    }

    @Override
    public void onValueChanged() {
        this.invalidateSelf();
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setMatteLayer(@Nullable BaseLayer matteLayer) {
        this.matteLayer = matteLayer;
    }

    boolean hasMatteOnThisLayer() {
        return this.matteLayer != null;
    }

    void setParentLayer(@Nullable BaseLayer parentLayer) {
        this.parentLayer = parentLayer;
    }

    private void setupInOutAnimations() {
        if (!this.layerModel.getInOutKeyframes().isEmpty()) {
            final FloatKeyframeAnimation inOutAnimation = new FloatKeyframeAnimation(this.layerModel.getInOutKeyframes());
            inOutAnimation.setIsDiscrete();
            inOutAnimation.addUpdateListener(new BaseKeyframeAnimation.AnimationListener(){

                @Override
                public void onValueChanged() {
                    BaseLayer.this.setVisible(inOutAnimation.getFloatValue() == 1.0f);
                }
            });
            this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f);
            this.addAnimation(inOutAnimation);
        } else {
            this.setVisible(true);
        }
    }

    private void invalidateSelf() {
        this.lottieDrawable.invalidateSelf();
    }

    @SuppressLint(value={"WrongConstant"})
    private void saveLayerCompat(Canvas canvas, RectF rect, Paint paint, boolean all) {
        if (Build.VERSION.SDK_INT < 23) {
            canvas.saveLayer(rect, paint, all ? 31 : 19);
        } else {
            canvas.saveLayer(rect, paint);
        }
    }

    public void addAnimation(@Nullable BaseKeyframeAnimation<?, ?> newAnimation) {
        if (newAnimation == null) {
            return;
        }
        this.animations.add(newAnimation);
    }

    public void removeAnimation(BaseKeyframeAnimation<?, ?> animation) {
        this.animations.remove(animation);
    }

    @Override
    @CallSuper
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.buildParentLayerListIfNeeded();
        this.boundsMatrix.set(parentMatrix);
        if (applyParents) {
            if (this.parentLayers != null) {
                for (int i = this.parentLayers.size() - 1; i >= 0; --i) {
                    this.boundsMatrix.preConcat(this.parentLayers.get((int)i).transform.getMatrix());
                }
            } else if (this.parentLayer != null) {
                this.boundsMatrix.preConcat(this.parentLayer.transform.getMatrix());
            }
        }
        this.boundsMatrix.preConcat(this.transform.getMatrix());
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        L.beginSection(this.drawTraceName);
        if (!this.visible || this.layerModel.isHidden()) {
            L.endSection(this.drawTraceName);
            return;
        }
        this.buildParentLayerListIfNeeded();
        L.beginSection("Layer#parentMatrix");
        this.matrix.reset();
        this.matrix.set(parentMatrix);
        for (int i = this.parentLayers.size() - 1; i >= 0; --i) {
            this.matrix.preConcat(this.parentLayers.get((int)i).transform.getMatrix());
        }
        L.endSection("Layer#parentMatrix");
        int opacity = this.transform.getOpacity() == null ? 100 : this.transform.getOpacity().getValue();
        int alpha = (int)((float)parentAlpha / 255.0f * (float)opacity / 100.0f * 255.0f);
        if (!this.hasMatteOnThisLayer() && !this.hasMasksOnThisLayer()) {
            this.matrix.preConcat(this.transform.getMatrix());
            L.beginSection("Layer#drawLayer");
            this.drawLayer(canvas, this.matrix, alpha);
            L.endSection("Layer#drawLayer");
            this.recordRenderTime(L.endSection(this.drawTraceName));
            return;
        }
        L.beginSection("Layer#computeBounds");
        this.getBounds(this.rect, this.matrix, false);
        this.intersectBoundsWithMatte(this.rect, parentMatrix);
        this.matrix.preConcat(this.transform.getMatrix());
        this.intersectBoundsWithMask(this.rect, this.matrix);
        L.endSection("Layer#computeBounds");
        if (!this.rect.isEmpty()) {
            L.beginSection("Layer#saveLayer");
            this.saveLayerCompat(canvas, this.rect, this.contentPaint, true);
            L.endSection("Layer#saveLayer");
            this.clearCanvas(canvas);
            L.beginSection("Layer#drawLayer");
            this.drawLayer(canvas, this.matrix, alpha);
            L.endSection("Layer#drawLayer");
            if (this.hasMasksOnThisLayer()) {
                this.applyMasks(canvas, this.matrix);
            }
            if (this.hasMatteOnThisLayer()) {
                L.beginSection("Layer#drawMatte");
                L.beginSection("Layer#saveLayer");
                this.saveLayerCompat(canvas, this.rect, this.mattePaint, false);
                L.endSection("Layer#saveLayer");
                this.clearCanvas(canvas);
                this.matteLayer.draw(canvas, parentMatrix, alpha);
                L.beginSection("Layer#restoreLayer");
                canvas.restore();
                L.endSection("Layer#restoreLayer");
                L.endSection("Layer#drawMatte");
            }
            L.beginSection("Layer#restoreLayer");
            canvas.restore();
            L.endSection("Layer#restoreLayer");
        }
        this.recordRenderTime(L.endSection(this.drawTraceName));
    }

    private void recordRenderTime(float ms) {
        this.lottieDrawable.getComposition().getPerformanceTracker().recordRenderTime(this.layerModel.getName(), ms);
    }

    private void clearCanvas(Canvas canvas) {
        L.beginSection("Layer#clearLayer");
        canvas.drawRect(this.rect.left - 1.0f, this.rect.top - 1.0f, this.rect.right + 1.0f, this.rect.bottom + 1.0f, this.clearPaint);
        L.endSection("Layer#clearLayer");
    }

    private void intersectBoundsWithMask(RectF rect, Matrix matrix) {
        this.maskBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        if (!this.hasMasksOnThisLayer()) {
            return;
        }
        int size = this.mask.getMasks().size();
        for (int i = 0; i < size; ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<ShapeData, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            Path maskPath = maskAnimation.getValue();
            this.path.set(maskPath);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MASK_MODE_SUBTRACT: {
                    return;
                }
                case MASK_MODE_INTERSECT: 
                case MASK_MODE_ADD: {
                    if (!mask.isInverted()) break;
                    return;
                }
            }
            this.path.computeBounds(this.tempMaskBoundsRect, false);
            if (i == 0) {
                this.maskBoundsRect.set(this.tempMaskBoundsRect);
                continue;
            }
            this.maskBoundsRect.set(Math.min(this.maskBoundsRect.left, this.tempMaskBoundsRect.left), Math.min(this.maskBoundsRect.top, this.tempMaskBoundsRect.top), Math.max(this.maskBoundsRect.right, this.tempMaskBoundsRect.right), Math.max(this.maskBoundsRect.bottom, this.tempMaskBoundsRect.bottom));
        }
        boolean intersects = rect.intersect(this.maskBoundsRect);
        if (!intersects) {
            rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void intersectBoundsWithMatte(RectF rect, Matrix matrix) {
        if (!this.hasMatteOnThisLayer()) {
            return;
        }
        if (this.layerModel.getMatteType() == Layer.MatteType.INVERT) {
            return;
        }
        this.matteBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.matteLayer.getBounds(this.matteBoundsRect, matrix, true);
        boolean intersects = rect.intersect(this.matteBoundsRect);
        if (!intersects) {
            rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    abstract void drawLayer(Canvas var1, Matrix var2, int var3);

    private void applyMasks(Canvas canvas, Matrix matrix) {
        L.beginSection("Layer#saveLayer");
        this.saveLayerCompat(canvas, this.rect, this.dstInPaint, false);
        L.endSection("Layer#saveLayer");
        block5: for (int i = 0; i < this.mask.getMasks().size(); ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<ShapeData, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            BaseKeyframeAnimation<Integer, Integer> opacityAnimation = this.mask.getOpacityAnimations().get(i);
            switch (mask.getMaskMode()) {
                case MASK_MODE_ADD: {
                    if (mask.isInverted()) {
                        this.applyInvertedAddMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                        continue block5;
                    }
                    this.applyAddMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                    continue block5;
                }
                case MASK_MODE_SUBTRACT: {
                    if (i == 0) {
                        Paint paint = new Paint();
                        paint.setColor(-16777216);
                        canvas.drawRect(this.rect, paint);
                    }
                    if (mask.isInverted()) {
                        this.applyInvertedSubtractMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                        continue block5;
                    }
                    this.applySubtractMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                    continue block5;
                }
                case MASK_MODE_INTERSECT: {
                    if (mask.isInverted()) {
                        this.applyInvertedIntersectMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                        continue block5;
                    }
                    this.applyIntersectMask(canvas, matrix, mask, maskAnimation, opacityAnimation);
                }
            }
        }
        L.beginSection("Layer#restoreLayer");
        canvas.restore();
        L.endSection("Layer#restoreLayer");
    }

    private void applyAddMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
        canvas.drawPath(this.path, this.contentPaint);
    }

    private void applyInvertedAddMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        this.saveLayerCompat(canvas, this.rect, this.contentPaint, true);
        canvas.drawRect(this.rect, this.contentPaint);
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    private void applySubtractMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
    }

    private void applyInvertedSubtractMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        this.saveLayerCompat(canvas, this.rect, this.dstOutPaint, true);
        canvas.drawRect(this.rect, this.contentPaint);
        this.dstOutPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    private void applyIntersectMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        this.saveLayerCompat(canvas, this.rect, this.dstInPaint, true);
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        this.contentPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
        canvas.drawPath(this.path, this.contentPaint);
        canvas.restore();
    }

    private void applyInvertedIntersectMask(Canvas canvas, Matrix matrix, Mask mask, BaseKeyframeAnimation<ShapeData, Path> maskAnimation, BaseKeyframeAnimation<Integer, Integer> opacityAnimation) {
        this.saveLayerCompat(canvas, this.rect, this.dstInPaint, true);
        canvas.drawRect(this.rect, this.contentPaint);
        this.dstOutPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
        Path maskPath = maskAnimation.getValue();
        this.path.set(maskPath);
        this.path.transform(matrix);
        canvas.drawPath(this.path, this.dstOutPaint);
        canvas.restore();
    }

    boolean hasMasksOnThisLayer() {
        return this.mask != null && !this.mask.getMaskAnimations().isEmpty();
    }

    private void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            this.invalidateSelf();
        }
    }

    void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        int i;
        this.transform.setProgress(progress);
        if (this.mask != null) {
            for (i = 0; i < this.mask.getMaskAnimations().size(); ++i) {
                this.mask.getMaskAnimations().get(i).setProgress(progress);
            }
        }
        if (this.layerModel.getTimeStretch() != 0.0f) {
            progress /= this.layerModel.getTimeStretch();
        }
        if (this.matteLayer != null) {
            float matteTimeStretch = this.matteLayer.layerModel.getTimeStretch();
            this.matteLayer.setProgress(progress * matteTimeStretch);
        }
        for (i = 0; i < this.animations.size(); ++i) {
            this.animations.get(i).setProgress(progress);
        }
    }

    private void buildParentLayerListIfNeeded() {
        if (this.parentLayers != null) {
            return;
        }
        if (this.parentLayer == null) {
            this.parentLayers = Collections.emptyList();
            return;
        }
        this.parentLayers = new ArrayList<BaseLayer>();
        BaseLayer layer = this.parentLayer;
        while (layer != null) {
            this.parentLayers.add(layer);
            layer = layer.parentLayer;
        }
    }

    @Override
    public String getName() {
        return this.layerModel.getName();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        if (!keyPath.matches(this.getName(), depth)) {
            return;
        }
        if (!"__container".equals(this.getName())) {
            currentPartialKeyPath = currentPartialKeyPath.addKey(this.getName());
            if (keyPath.fullyResolvesTo(this.getName(), depth)) {
                accumulator.add(currentPartialKeyPath.resolve(this));
            }
        }
        if (keyPath.propagateToChildren(this.getName(), depth)) {
            int newDepth = depth + keyPath.incrementDepthBy(this.getName(), depth);
            this.resolveChildKeyPath(keyPath, newDepth, accumulator, currentPartialKeyPath);
        }
    }

    void resolveChildKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
    }

    @Override
    @CallSuper
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        this.transform.applyValueCallback(property, callback);
    }
}

