/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Path;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ShapeFill;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class ShapeFillParser {
    private ShapeFillParser() {
    }

    static ShapeFill parse(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableColorValue color = null;
        boolean fillEnabled = false;
        AnimatableIntegerValue opacity = null;
        String name = null;
        int fillTypeInt = 1;
        boolean hidden = false;
        block16: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block16;
                }
                case "c": {
                    color = AnimatableValueParser.parseColor(reader, composition);
                    continue block16;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block16;
                }
                case "fillEnabled": {
                    fillEnabled = reader.nextBoolean();
                    continue block16;
                }
                case "r": {
                    fillTypeInt = reader.nextInt();
                    continue block16;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block16;
                }
            }
            reader.skipValue();
        }
        Path.FillType fillType = fillTypeInt == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
        return new ShapeFill(name, fillEnabled, fillType, color, opacity, hidden);
    }
}

