/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.ScaleXY;
import java.io.IOException;

public class AnimatableTransformParser {
    private AnimatableTransformParser() {
    }

    public static AnimatableTransform parse(JsonReader reader, LottieComposition composition) throws IOException {
        boolean isObject;
        AnimatablePathValue anchorPoint = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatableScaleValue scale = null;
        AnimatableFloatValue rotation = null;
        AnimatableIntegerValue opacity = null;
        AnimatableFloatValue startOpacity = null;
        AnimatableFloatValue endOpacity = null;
        AnimatableFloatValue skew = null;
        AnimatableFloatValue skewAngle = null;
        boolean bl = isObject = reader.peek() == JsonToken.BEGIN_OBJECT;
        if (isObject) {
            reader.beginObject();
        }
        block24: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "a": {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        if (reader.nextName().equals("k")) {
                            anchorPoint = AnimatablePathValueParser.parse(reader, composition);
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block24;
                }
                case "p": {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block24;
                }
                case "s": {
                    scale = AnimatableValueParser.parseScale(reader, composition);
                    continue block24;
                }
                case "rz": {
                    composition.addWarning("Lottie doesn't support 3D layers.");
                }
                case "r": {
                    rotation = AnimatableValueParser.parseFloat(reader, composition, false);
                    if (rotation.getKeyframes().isEmpty()) {
                        rotation.getKeyframes().add(new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(composition.getEndFrame())));
                        continue block24;
                    }
                    if (((Keyframe)rotation.getKeyframes().get((int)0)).startValue != null) continue block24;
                    rotation.getKeyframes().set(0, new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(composition.getEndFrame())));
                    continue block24;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block24;
                }
                case "so": {
                    startOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block24;
                }
                case "eo": {
                    endOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block24;
                }
                case "sk": {
                    skew = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block24;
                }
                case "sa": {
                    skewAngle = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block24;
                }
            }
            reader.skipValue();
        }
        if (isObject) {
            reader.endObject();
        }
        if (AnimatableTransformParser.isAnchorPointIdentity(anchorPoint)) {
            anchorPoint = null;
        }
        if (AnimatableTransformParser.isPositionIdentity(position)) {
            position = null;
        }
        if (AnimatableTransformParser.isRotationIdentity(rotation)) {
            rotation = null;
        }
        if (AnimatableTransformParser.isScaleIdentity(scale)) {
            scale = null;
        }
        if (AnimatableTransformParser.isSkewIdentity(skew)) {
            skew = null;
        }
        if (AnimatableTransformParser.isSkewAngleIdentity(skewAngle)) {
            skewAngle = null;
        }
        return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity, skew, skewAngle);
    }

    private static boolean isAnchorPointIdentity(AnimatablePathValue anchorPoint) {
        return anchorPoint == null || anchorPoint.isStatic() && ((PointF)anchorPoint.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isPositionIdentity(AnimatableValue<PointF, PointF> position) {
        return position == null || !(position instanceof AnimatableSplitDimensionPathValue) && position.isStatic() && ((PointF)position.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f);
    }

    private static boolean isRotationIdentity(AnimatableFloatValue rotation) {
        return rotation == null || rotation.isStatic() && ((Float)((Keyframe)rotation.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isScaleIdentity(AnimatableScaleValue scale) {
        return scale == null || scale.isStatic() && ((ScaleXY)((Keyframe)scale.getKeyframes().get((int)0)).startValue).equals(1.0f, 1.0f);
    }

    private static boolean isSkewIdentity(AnimatableFloatValue skew) {
        return skew == null || skew.isStatic() && ((Float)((Keyframe)skew.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }

    private static boolean isSkewAngleIdentity(AnimatableFloatValue skewAngle) {
        return skewAngle == null || skewAngle.isStatic() && ((Float)((Keyframe)skewAngle.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f;
    }
}

