/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Color;
import android.graphics.PointF;
import android.util.JsonReader;
import android.util.JsonToken;
import androidx.annotation.ColorInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class JsonUtils {
    private JsonUtils() {
    }

    @ColorInt
    static int jsonToColor(JsonReader reader) throws IOException {
        reader.beginArray();
        int r = (int)(reader.nextDouble() * 255.0);
        int g = (int)(reader.nextDouble() * 255.0);
        int b = (int)(reader.nextDouble() * 255.0);
        while (reader.hasNext()) {
            reader.skipValue();
        }
        reader.endArray();
        return Color.argb((int)255, (int)r, (int)g, (int)b);
    }

    static List<PointF> jsonToPoints(JsonReader reader, float scale) throws IOException {
        ArrayList<PointF> points = new ArrayList<PointF>();
        reader.beginArray();
        while (reader.peek() == JsonToken.BEGIN_ARRAY) {
            reader.beginArray();
            points.add(JsonUtils.jsonToPoint(reader, scale));
            reader.endArray();
        }
        reader.endArray();
        return points;
    }

    static PointF jsonToPoint(JsonReader reader, float scale) throws IOException {
        switch (reader.peek()) {
            case NUMBER: {
                return JsonUtils.jsonNumbersToPoint(reader, scale);
            }
            case BEGIN_ARRAY: {
                return JsonUtils.jsonArrayToPoint(reader, scale);
            }
            case BEGIN_OBJECT: {
                return JsonUtils.jsonObjectToPoint(reader, scale);
            }
        }
        throw new IllegalArgumentException("Unknown point starts with " + reader.peek());
    }

    private static PointF jsonNumbersToPoint(JsonReader reader, float scale) throws IOException {
        float x = (float)reader.nextDouble();
        float y = (float)reader.nextDouble();
        while (reader.hasNext()) {
            reader.skipValue();
        }
        return new PointF(x * scale, y * scale);
    }

    private static PointF jsonArrayToPoint(JsonReader reader, float scale) throws IOException {
        reader.beginArray();
        float x = (float)reader.nextDouble();
        float y = (float)reader.nextDouble();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.skipValue();
        }
        reader.endArray();
        return new PointF(x * scale, y * scale);
    }

    private static PointF jsonObjectToPoint(JsonReader reader, float scale) throws IOException {
        float x = 0.0f;
        float y = 0.0f;
        reader.beginObject();
        block8: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "x": {
                    x = JsonUtils.valueFromObject(reader);
                    continue block8;
                }
                case "y": {
                    y = JsonUtils.valueFromObject(reader);
                    continue block8;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new PointF(x * scale, y * scale);
    }

    static float valueFromObject(JsonReader reader) throws IOException {
        JsonToken token = reader.peek();
        switch (token) {
            case NUMBER: {
                return (float)reader.nextDouble();
            }
            case BEGIN_ARRAY: {
                reader.beginArray();
                float val = (float)reader.nextDouble();
                while (reader.hasNext()) {
                    reader.skipValue();
                }
                reader.endArray();
                return val;
            }
        }
        throw new IllegalArgumentException("Unknown value for token of type " + token);
    }
}

