/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;
import java.util.ArrayList;

class ShapeStrokeParser {
    private ShapeStrokeParser() {
    }

    static ShapeStroke parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableColorValue color = null;
        AnimatableFloatValue width = null;
        AnimatableIntegerValue opacity = null;
        ShapeStroke.LineCapType capType = null;
        ShapeStroke.LineJoinType joinType = null;
        AnimatableFloatValue offset = null;
        float miterLimit = 0.0f;
        boolean hidden = false;
        ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
        block39: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block39;
                }
                case "c": {
                    color = AnimatableValueParser.parseColor(reader, composition);
                    continue block39;
                }
                case "w": {
                    width = AnimatableValueParser.parseFloat(reader, composition);
                    continue block39;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block39;
                }
                case "lc": {
                    capType = ShapeStroke.LineCapType.values()[reader.nextInt() - 1];
                    continue block39;
                }
                case "lj": {
                    joinType = ShapeStroke.LineJoinType.values()[reader.nextInt() - 1];
                    continue block39;
                }
                case "ml": {
                    miterLimit = (float)reader.nextDouble();
                    continue block39;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block39;
                }
                case "d": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String n = null;
                        AnimatableFloatValue val = null;
                        reader.beginObject();
                        block41: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "n": {
                                    n = reader.nextString();
                                    continue block41;
                                }
                                case "v": {
                                    val = AnimatableValueParser.parseFloat(reader, composition);
                                    continue block41;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        switch (n) {
                            case "o": {
                                offset = val;
                                break;
                            }
                            case "d": 
                            case "g": {
                                composition.setHasDashPattern(true);
                                lineDashPattern.add(val);
                            }
                        }
                    }
                    reader.endArray();
                    if (lineDashPattern.size() != 1) continue block39;
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                    continue block39;
                }
            }
            reader.skipValue();
        }
        return new ShapeStroke(name, offset, lineDashPattern, color, opacity, width, capType, joinType, miterLimit, hidden);
    }
}

