/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Path;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.GradientFill;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class GradientFillParser {
    private GradientFillParser() {
    }

    static GradientFill parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableGradientColorValue color = null;
        AnimatableIntegerValue opacity = null;
        GradientType gradientType = null;
        AnimatablePointValue startPoint = null;
        AnimatablePointValue endPoint = null;
        Path.FillType fillType = Path.FillType.WINDING;
        boolean hidden = false;
        block28: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block28;
                }
                case "g": {
                    int points = -1;
                    reader.beginObject();
                    block29: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "p": {
                                points = reader.nextInt();
                                continue block29;
                            }
                            case "k": {
                                color = AnimatableValueParser.parseGradientColor(reader, composition, points);
                                continue block29;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block28;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block28;
                }
                case "t": {
                    gradientType = reader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    continue block28;
                }
                case "s": {
                    startPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block28;
                }
                case "e": {
                    endPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block28;
                }
                case "r": {
                    fillType = reader.nextInt() == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
                    continue block28;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block28;
                }
            }
            reader.skipValue();
        }
        return new GradientFill(name, gradientType, fillType, color, opacity, startPoint, endPoint, null, null, hidden);
    }
}

