/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class ShapeTrimPathParser {
    private ShapeTrimPathParser() {
    }

    static ShapeTrimPath parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        ShapeTrimPath.Type type = null;
        AnimatableFloatValue start = null;
        AnimatableFloatValue end = null;
        AnimatableFloatValue offset = null;
        boolean hidden = false;
        block16: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "s": {
                    start = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block16;
                }
                case "e": {
                    end = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block16;
                }
                case "o": {
                    offset = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block16;
                }
                case "nm": {
                    name = reader.nextString();
                    continue block16;
                }
                case "m": {
                    type = ShapeTrimPath.Type.forId(reader.nextInt());
                    continue block16;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block16;
                }
            }
            reader.skipValue();
        }
        return new ShapeTrimPath(name, type, start, end, offset, hidden);
    }
}

