/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Matrix;
import android.graphics.PointF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.ScaleXY;

public class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final Matrix skewMatrix1;
    private final Matrix skewMatrix2;
    private final Matrix skewMatrix3;
    private final float[] skewValues;
    private boolean isIdentity;
    private final BaseKeyframeAnimation<PointF, PointF> anchorPoint;
    private final BaseKeyframeAnimation<?, PointF> position;
    private final BaseKeyframeAnimation<ScaleXY, ScaleXY> scale;
    private final BaseKeyframeAnimation<Float, Float> rotation;
    private final BaseKeyframeAnimation<Integer, Integer> opacity;
    @Nullable
    private final FloatKeyframeAnimation skew;
    @Nullable
    private final FloatKeyframeAnimation skewAngle;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> startOpacity;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> endOpacity;

    public TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.isIdentity = animatableTransform.isIdentity();
        if (this.isIdentity) {
            this.anchorPoint = null;
            this.position = null;
            this.scale = null;
            this.rotation = null;
            this.skew = null;
            this.skewAngle = null;
            this.skewMatrix1 = null;
            this.skewMatrix2 = null;
            this.skewMatrix3 = null;
            this.skewValues = null;
        } else {
            this.anchorPoint = animatableTransform.getAnchorPoint().createAnimation();
            this.position = animatableTransform.getPosition().createAnimation();
            this.scale = animatableTransform.getScale().createAnimation();
            this.rotation = animatableTransform.getRotation().createAnimation();
            FloatKeyframeAnimation floatKeyframeAnimation = this.skew = animatableTransform.getSkew() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkew().createAnimation();
            if (this.skew != null) {
                this.skewMatrix1 = new Matrix();
                this.skewMatrix2 = new Matrix();
                this.skewMatrix3 = new Matrix();
                this.skewValues = new float[9];
            } else {
                this.skewMatrix1 = null;
                this.skewMatrix2 = null;
                this.skewMatrix3 = null;
                this.skewValues = null;
            }
            this.skewAngle = animatableTransform.getSkewAngle() == null ? null : (FloatKeyframeAnimation)animatableTransform.getSkewAngle().createAnimation();
        }
        this.opacity = animatableTransform.getOpacity().createAnimation();
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    public void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.opacity);
        if (this.startOpacity != null) {
            layer.addAnimation(this.startOpacity);
        }
        if (this.endOpacity != null) {
            layer.addAnimation(this.endOpacity);
        }
        if (this.isIdentity) {
            return;
        }
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        if (this.skew != null) {
            layer.addAnimation(this.skew);
        }
        if (this.skewAngle != null) {
            layer.addAnimation(this.skewAngle);
        }
    }

    public void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        this.opacity.addUpdateListener(listener);
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(listener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(listener);
        }
        if (this.isIdentity) {
            return;
        }
        this.anchorPoint.addUpdateListener(listener);
        this.position.addUpdateListener(listener);
        this.scale.addUpdateListener(listener);
        this.rotation.addUpdateListener(listener);
        if (this.skew != null) {
            this.skew.addUpdateListener(listener);
        }
        if (this.skewAngle != null) {
            this.skewAngle.addUpdateListener(listener);
        }
    }

    public void setProgress(float progress) {
        this.opacity.setProgress(progress);
        if (this.startOpacity != null) {
            this.startOpacity.setProgress(progress);
        }
        if (this.endOpacity != null) {
            this.endOpacity.setProgress(progress);
        }
        if (this.isIdentity) {
            return;
        }
        this.anchorPoint.setProgress(progress);
        this.position.setProgress(progress);
        this.scale.setProgress(progress);
        this.rotation.setProgress(progress);
        if (this.skew != null) {
            this.skew.setProgress(progress);
        }
        if (this.skewAngle != null) {
            this.skewAngle.setProgress(progress);
        }
    }

    public BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getEndOpacity() {
        return this.endOpacity;
    }

    public Matrix getMatrix() {
        ScaleXY scaleTransform;
        float rotation;
        if (this.isIdentity) {
            return this.matrix;
        }
        this.matrix.reset();
        PointF position = this.position.getValue();
        if (position.x != 0.0f || position.y != 0.0f) {
            this.matrix.preTranslate(position.x, position.y);
        }
        if ((rotation = ((FloatKeyframeAnimation)this.rotation).getFloatValue()) != 0.0f) {
            this.matrix.preRotate(rotation);
        }
        if (this.skew != null) {
            float mCos = this.skewAngle == null ? 0.0f : (float)Math.cos(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float mSin = this.skewAngle == null ? 0.0f : (float)Math.sin(Math.toRadians(-this.skewAngle.getFloatValue() + 90.0f));
            float aTan = (float)Math.tan(Math.toRadians(this.skew.getFloatValue()));
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = mSin;
            this.skewValues[3] = -mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix1.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = 1.0f;
            this.skewValues[3] = aTan;
            this.skewValues[4] = 1.0f;
            this.skewValues[8] = 1.0f;
            this.skewMatrix2.setValues(this.skewValues);
            this.clearSkewValues();
            this.skewValues[0] = mCos;
            this.skewValues[1] = -mSin;
            this.skewValues[3] = mSin;
            this.skewValues[4] = mCos;
            this.skewValues[8] = 1.0f;
            this.skewMatrix3.setValues(this.skewValues);
            this.skewMatrix2.preConcat(this.skewMatrix1);
            this.skewMatrix3.preConcat(this.skewMatrix2);
            this.matrix.preConcat(this.skewMatrix3);
        }
        if ((scaleTransform = this.scale.getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        PointF anchorPoint = this.anchorPoint.getValue();
        if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
            this.matrix.preTranslate(-anchorPoint.x, -anchorPoint.y);
        }
        return this.matrix;
    }

    private void clearSkewValues() {
        for (int i = 0; i < 9; ++i) {
            this.skewValues[i] = 0.0f;
        }
    }

    public Matrix getMatrixForRepeater(float amount) {
        if (this.isIdentity) {
            return this.matrix;
        }
        PointF position = this.position.getValue();
        PointF anchorPoint = this.anchorPoint.getValue();
        ScaleXY scale = this.scale.getValue();
        float rotation = this.rotation.getValue().floatValue();
        this.matrix.reset();
        this.matrix.preTranslate(position.x * amount, position.y * amount);
        this.matrix.preScale((float)Math.pow(scale.getScaleX(), amount), (float)Math.pow(scale.getScaleY(), amount));
        this.matrix.preRotate(rotation * amount, anchorPoint.x, anchorPoint.y);
        return this.matrix;
    }

    public <T> boolean applyValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        this.isIdentity = false;
        if (property == LottieProperty.TRANSFORM_ANCHOR_POINT) {
            this.anchorPoint.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_POSITION) {
            this.position.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SCALE) {
            this.scale.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_ROTATION) {
            this.rotation.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_OPACITY) {
            this.opacity.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_START_OPACITY && this.startOpacity != null) {
            this.startOpacity.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_END_OPACITY && this.endOpacity != null) {
            this.endOpacity.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SKEW && this.skew != null) {
            this.skew.setValueCallback(callback);
        } else if (property == LottieProperty.TRANSFORM_SKEW_ANGLE && this.skewAngle != null) {
            this.skewAngle.setValueCallback(callback);
        } else {
            return false;
        }
        return true;
    }
}

