/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Color;
import android.graphics.Rect;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTextFrame;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.AnimatableTextPropertiesParser;
import com.airbnb.lottie.parser.AnimatableTransformParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.ContentModelParser;
import com.airbnb.lottie.parser.MaskParser;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class LayerParser {
    private LayerParser() {
    }

    public static Layer parse(LottieComposition composition) {
        Rect bounds = composition.getBounds();
        return new Layer(Collections.emptyList(), composition, "__container", -1L, Layer.LayerType.PreComp, -1L, null, Collections.emptyList(), new AnimatableTransform(), 0, 0, 0, 0.0f, 0.0f, bounds.width(), bounds.height(), null, null, Collections.emptyList(), Layer.MatteType.None, null, false);
    }

    public static Layer parse(JsonReader reader, LottieComposition composition) throws IOException {
        String layerName = "UNSET";
        Layer.LayerType layerType = null;
        String refId = null;
        long layerId = 0L;
        int solidWidth = 0;
        int solidHeight = 0;
        int solidColor = 0;
        int preCompWidth = 0;
        int preCompHeight = 0;
        long parentId = -1L;
        float timeStretch = 1.0f;
        float startFrame = 0.0f;
        float inFrame = 0.0f;
        float outFrame = 0.0f;
        String cl = null;
        boolean hidden = false;
        Layer.MatteType matteType = Layer.MatteType.None;
        AnimatableTransform transform = null;
        AnimatableTextFrame text = null;
        AnimatableTextProperties textProperties = null;
        AnimatableFloatValue timeRemapping = null;
        ArrayList<Mask> masks = new ArrayList<Mask>();
        ArrayList<ContentModel> shapes = new ArrayList<ContentModel>();
        reader.beginObject();
        block64: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    layerName = reader.nextString();
                    continue block64;
                }
                case "ind": {
                    layerId = reader.nextInt();
                    continue block64;
                }
                case "refId": {
                    refId = reader.nextString();
                    continue block64;
                }
                case "ty": {
                    int layerTypeInt = reader.nextInt();
                    if (layerTypeInt < Layer.LayerType.Unknown.ordinal()) {
                        layerType = Layer.LayerType.values()[layerTypeInt];
                        continue block64;
                    }
                    layerType = Layer.LayerType.Unknown;
                    continue block64;
                }
                case "parent": {
                    parentId = reader.nextInt();
                    continue block64;
                }
                case "sw": {
                    solidWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block64;
                }
                case "sh": {
                    solidHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block64;
                }
                case "sc": {
                    solidColor = Color.parseColor((String)reader.nextString());
                    continue block64;
                }
                case "ks": {
                    transform = AnimatableTransformParser.parse(reader, composition);
                    continue block64;
                }
                case "tt": {
                    matteType = Layer.MatteType.values()[reader.nextInt()];
                    composition.incrementMatteOrMaskCount(1);
                    continue block64;
                }
                case "masksProperties": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        masks.add(MaskParser.parse(reader, composition));
                    }
                    composition.incrementMatteOrMaskCount(masks.size());
                    reader.endArray();
                    continue block64;
                }
                case "shapes": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        Object shape = ContentModelParser.parse(reader, composition);
                        if (shape == null) continue;
                        shapes.add((ContentModel)shape);
                    }
                    reader.endArray();
                    continue block64;
                }
                case "t": {
                    reader.beginObject();
                    block67: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "d": {
                                text = AnimatableValueParser.parseDocumentData(reader, composition);
                                continue block67;
                            }
                            case "a": {
                                reader.beginArray();
                                if (reader.hasNext()) {
                                    textProperties = AnimatableTextPropertiesParser.parse(reader, composition);
                                }
                                while (reader.hasNext()) {
                                    reader.skipValue();
                                }
                                reader.endArray();
                                continue block67;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block64;
                }
                case "ef": {
                    reader.beginArray();
                    ArrayList<String> effectNames = new ArrayList<String>();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        block70: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "nm": {
                                    effectNames.add(reader.nextString());
                                    continue block70;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                    }
                    reader.endArray();
                    composition.addWarning("Lottie doesn't support layer effects. If you are using them for  fills, strokes, trim paths etc. then try adding them directly as contents  in your shape. Found: " + effectNames);
                    continue block64;
                }
                case "sr": {
                    timeStretch = (float)reader.nextDouble();
                    continue block64;
                }
                case "st": {
                    startFrame = (float)reader.nextDouble();
                    continue block64;
                }
                case "w": {
                    preCompWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block64;
                }
                case "h": {
                    preCompHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                    continue block64;
                }
                case "ip": {
                    inFrame = (float)reader.nextDouble();
                    continue block64;
                }
                case "op": {
                    outFrame = (float)reader.nextDouble();
                    continue block64;
                }
                case "tm": {
                    timeRemapping = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block64;
                }
                case "cl": {
                    cl = reader.nextString();
                    continue block64;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block64;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        inFrame /= timeStretch;
        outFrame /= timeStretch;
        ArrayList<Keyframe<Float>> inOutKeyframes = new ArrayList<Keyframe<Float>>();
        if (inFrame > 0.0f) {
            Keyframe<Float> preKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(inFrame));
            inOutKeyframes.add(preKeyframe);
        }
        outFrame = outFrame > 0.0f ? outFrame : composition.getEndFrame();
        Keyframe<Float> visibleKeyframe = new Keyframe<Float>(composition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, inFrame, Float.valueOf(outFrame));
        inOutKeyframes.add(visibleKeyframe);
        Keyframe<Float> outKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, outFrame, Float.valueOf(Float.MAX_VALUE));
        inOutKeyframes.add(outKeyframe);
        if (layerName.endsWith(".ai") || "ai".equals(cl)) {
            composition.addWarning("Convert your Illustrator layers to shape layers.");
        }
        return new Layer(shapes, composition, layerName, layerId, layerType, parentId, refId, masks, transform, solidWidth, solidHeight, solidColor, timeStretch, startFrame, preCompWidth, preCompHeight, text, textProperties, inOutKeyframes, matteType, timeRemapping, hidden);
    }
}

