/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.PointF;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.PolystarContent;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;

public class PolystarShape
implements ContentModel {
    private final String name;
    private final Type type;
    private final AnimatableFloatValue points;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatableFloatValue rotation;
    private final AnimatableFloatValue innerRadius;
    private final AnimatableFloatValue outerRadius;
    private final AnimatableFloatValue innerRoundedness;
    private final AnimatableFloatValue outerRoundedness;
    private final boolean hidden;

    public PolystarShape(String name, Type type, AnimatableFloatValue points, AnimatableValue<PointF, PointF> position, AnimatableFloatValue rotation, AnimatableFloatValue innerRadius, AnimatableFloatValue outerRadius, AnimatableFloatValue innerRoundedness, AnimatableFloatValue outerRoundedness, boolean hidden) {
        this.name = name;
        this.type = type;
        this.points = points;
        this.position = position;
        this.rotation = rotation;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.innerRoundedness = innerRoundedness;
        this.outerRoundedness = outerRoundedness;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public AnimatableFloatValue getPoints() {
        return this.points;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    public AnimatableFloatValue getInnerRadius() {
        return this.innerRadius;
    }

    public AnimatableFloatValue getOuterRadius() {
        return this.outerRadius;
    }

    public AnimatableFloatValue getInnerRoundedness() {
        return this.innerRoundedness;
    }

    public AnimatableFloatValue getOuterRoundedness() {
        return this.outerRoundedness;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new PolystarContent(drawable, layer, this);
    }

    public static enum Type {
        Star(1),
        Polygon(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type forValue(int value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            return null;
        }
    }
}

