/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.PointF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ModifierContent;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.ScaleXY;

public class AnimatableTransform
implements ModifierContent,
ContentModel {
    private final AnimatablePathValue anchorPoint;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatableScaleValue scale;
    private final AnimatableFloatValue rotation;
    private final AnimatableIntegerValue opacity;
    private final boolean isIdentity;
    @Nullable
    private final AnimatableFloatValue startOpacity;
    @Nullable
    private final AnimatableFloatValue endOpacity;

    public AnimatableTransform() {
        this(new AnimatablePathValue(), new AnimatablePathValue(), new AnimatableScaleValue(), new AnimatableFloatValue(), new AnimatableIntegerValue(), new AnimatableFloatValue(), new AnimatableFloatValue());
    }

    public AnimatableTransform(AnimatablePathValue anchorPoint, AnimatableValue<PointF, PointF> position, AnimatableScaleValue scale, AnimatableFloatValue rotation, AnimatableIntegerValue opacity, @Nullable AnimatableFloatValue startOpacity, @Nullable AnimatableFloatValue endOpacity) {
        this.anchorPoint = anchorPoint;
        this.position = position;
        this.scale = scale;
        this.rotation = rotation;
        this.opacity = opacity;
        this.startOpacity = startOpacity;
        this.endOpacity = endOpacity;
        this.isIdentity = anchorPoint.isStatic() && ((PointF)anchorPoint.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f) && !(position instanceof AnimatableSplitDimensionPathValue) && position.isStatic() && ((PointF)position.getKeyframes().get((int)0).startValue).equals(0.0f, 0.0f) && scale.isStatic() && ((ScaleXY)((Keyframe)scale.getKeyframes().get((int)0)).startValue).equals(1.0f, 1.0f) && (rotation.isStatic() && ((Float)((Keyframe)rotation.getKeyframes().get((int)0)).startValue).floatValue() == 0.0f || rotation.keyframes.isEmpty());
    }

    public AnimatablePathValue getAnchorPoint() {
        return this.anchorPoint;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    @Nullable
    public AnimatableFloatValue getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public AnimatableFloatValue getEndOpacity() {
        return this.endOpacity;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public TransformKeyframeAnimation createAnimation() {
        return new TransformKeyframeAnimation(this);
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return null;
    }
}

