/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.parser.ContentModelParser;
import java.io.IOException;
import java.util.ArrayList;

class FontCharacterParser {
    private FontCharacterParser() {
    }

    static FontCharacter parse(JsonReader reader, LottieComposition composition) throws IOException {
        char character = '\u0000';
        double size = 0.0;
        double width = 0.0;
        String style = null;
        String fontFamily = null;
        ArrayList<ShapeGroup> shapes = new ArrayList<ShapeGroup>();
        reader.beginObject();
        block16: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "ch": {
                    character = reader.nextString().charAt(0);
                    continue block16;
                }
                case "size": {
                    size = reader.nextDouble();
                    continue block16;
                }
                case "w": {
                    width = reader.nextDouble();
                    continue block16;
                }
                case "style": {
                    style = reader.nextString();
                    continue block16;
                }
                case "fFamily": {
                    fontFamily = reader.nextString();
                    continue block16;
                }
                case "data": {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        if ("shapes".equals(reader.nextName())) {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                shapes.add((ShapeGroup)ContentModelParser.parse(reader, composition));
                            }
                            reader.endArray();
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block16;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new FontCharacter(shapes, character, size, width, style, fontFamily);
    }
}

